/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import org.apache.kylin.common.KylinVersion;
import org.junit.Assert;
import org.junit.Test;

public class KylinVersionTest {
    @Test
    public void testNormal() {
        KylinVersion ver1 = new KylinVersion("2.1.0");
        Assert.assertEquals((long)2L, (long)ver1.major);
        Assert.assertEquals((long)1L, (long)ver1.minor);
        Assert.assertEquals((long)0L, (long)ver1.revision);
    }

    @Test
    public void testNoRevision() {
        KylinVersion ver1 = new KylinVersion("2.1");
        Assert.assertEquals((long)2L, (long)ver1.major);
        Assert.assertEquals((long)1L, (long)ver1.minor);
        Assert.assertEquals((long)0L, (long)ver1.revision);
    }

    @Test
    public void testToString() {
        KylinVersion ver1 = new KylinVersion("2.1.7.321");
        Assert.assertEquals((long)2L, (long)ver1.major);
        Assert.assertEquals((long)1L, (long)ver1.minor);
        Assert.assertEquals((long)7L, (long)ver1.revision);
        Assert.assertEquals((long)321L, (long)ver1.internal);
        Assert.assertEquals((Object)"2.1.7.321", (Object)ver1.toString());
    }

    @Test
    public void testCompare() {
        Assert.assertEquals((Object)true, (Object)KylinVersion.isBefore200("1.9.9"));
        Assert.assertEquals((Object)false, (Object)KylinVersion.isBefore200("2.0.0"));
        Assert.assertEquals((Object)true, (Object)(new KylinVersion("2.1.0").compareTo(new KylinVersion("2.1.0.123")) < 0 ? 1 : 0));
    }
}

