/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kylin.common.HotLoadKylinPropertiesTestCase;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Test;

public class KylinConfigTest
extends HotLoadKylinPropertiesTestCase {
    @Test
    public void testMRConfigOverride() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Map<String, String> override = config.getMRConfigOverride();
        Assert.assertEquals((long)2L, (long)override.size());
        Assert.assertEquals((Object)"test1", (Object)override.get("test1"));
        Assert.assertEquals((Object)"test2", (Object)override.get("test2"));
    }

    @Test
    public void testBackwardCompatibility() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String oldk = "kylin.test.bcc.old.key";
        String newk = "kylin.test.bcc.new.key";
        Assert.assertNull((Object)config.getOptional("kylin.test.bcc.old.key"));
        Assert.assertNotNull((Object)config.getOptional("kylin.test.bcc.new.key"));
        HashMap<String, String> override = Maps.newHashMap();
        override.put("kylin.test.bcc.old.key", "1");
        KylinConfigExt ext = KylinConfigExt.createInstance(config, override);
        Assert.assertEquals((Object)ext.getOptional("kylin.test.bcc.old.key"), null);
        Assert.assertEquals((Object)ext.getOptional("kylin.test.bcc.new.key"), (Object)"1");
        Assert.assertNotEquals((Object)config.getOptional("kylin.test.bcc.new.key"), (Object)"1");
        config.setProperty("kylin.test.bcc.old.key", "2");
        Assert.assertEquals((Object)config.getOptional("kylin.test.bcc.new.key"), (Object)"2");
    }

    @Test
    public void testExtShareTheBase() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        HashMap<String, String> override = Maps.newHashMap();
        KylinConfigExt configExt = KylinConfigExt.createInstance(config, override);
        Assert.assertTrue((config.properties == configExt.properties ? 1 : 0) != 0);
        config.setProperty("1234", "1234");
        Assert.assertEquals((Object)"1234", (Object)configExt.getOptional("1234"));
    }

    @Test
    public void testPropertiesHotLoad() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Assert.assertEquals((Object)"whoami@kylin.apache.org", (Object)config.getKylinOwner());
        this.updateProperty("kylin.storage.hbase.owner-tag", "kylin@kylin.apache.org");
        KylinConfig.getInstanceFromEnv().reloadFromSiteProperties();
        Assert.assertEquals((Object)"kylin@kylin.apache.org", (Object)config.getKylinOwner());
    }

    @Test
    public void testGetMetadataUrlPrefix() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.setMetadataUrl("testMetaPrefix@hbase");
        Assert.assertEquals((Object)"testMetaPrefix", (Object)config.getMetadataUrlPrefix());
        config.setMetadataUrl("testMetaPrefix@hdfs");
        Assert.assertEquals((Object)"testMetaPrefix", (Object)config.getMetadataUrlPrefix());
        config.setMetadataUrl("/kylin/temp");
        Assert.assertEquals((Object)"/kylin/temp", (Object)config.getMetadataUrlPrefix());
    }

    @Test
    public void testThreadLocalOverride() throws InterruptedException {
        String metadata1 = "meta1";
        String metadata2 = "meta2";
        KylinConfig sysConfig = KylinConfig.getInstanceFromEnv();
        sysConfig.setMetadataUrl("meta1");
        Assert.assertEquals((Object)"meta1", (Object)KylinConfig.getInstanceFromEnv().getMetadataUrl().toString());
        KylinConfig threadConfig = KylinConfig.createKylinConfig(new Properties());
        threadConfig.setMetadataUrl("meta2");
        try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(threadConfig);){
            Assert.assertEquals((Object)"meta2", (Object)KylinConfig.getInstanceFromEnv().getMetadataUrl().toString());
            final String[] holder = new String[1];
            Thread child = new Thread(new Runnable(){

                @Override
                public void run() {
                    holder[0] = KylinConfig.getInstanceFromEnv().getMetadataUrl().toString();
                }
            });
            child.start();
            child.join();
            Assert.assertEquals((Object)"meta1", (Object)holder[0]);
        }
    }

    @Test
    public void testHdfsWorkingDir() {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        String hdfsWorkingDirectory = conf.getHdfsWorkingDirectory();
        Assert.assertTrue((boolean)hdfsWorkingDirectory.startsWith("file:/"));
    }

    @Test
    public void testUnexpectedBlackInPro() {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        Map<String, String> override = conf.getPropertiesByPrefix("kylin.engine.mr.config-override.");
        Assert.assertEquals((long)2L, (long)override.size());
        String s = override.get("test2");
        Assert.assertEquals((Object)"test2", (Object)s);
    }

    @Test
    public void testCalciteExtrasProperties() {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        Properties extras = conf.getCalciteExtrasProperties();
        Assert.assertEquals((Object)"true", (Object)extras.getProperty("caseSensitive"));
        Assert.assertEquals((Object)"TO_UPPER", (Object)extras.getProperty("unquotedCasing"));
        Assert.assertEquals((Object)"DOUBLE_QUOTE", (Object)extras.getProperty("quoting"));
        Assert.assertEquals((Object)"LENIENT", (Object)extras.getProperty("conformance"));
        conf.setProperty("kylin.query.calcite.extras-props.caseSensitive", "false");
        conf.setProperty("kylin.query.calcite.extras-props.unquotedCasing", "UNCHANGED");
        conf.setProperty("kylin.query.calcite.extras-props.quoting", "BRACKET");
        conf.setProperty("kylin.query.calcite.extras-props.conformance", "DEFAULT");
        extras = conf.getCalciteExtrasProperties();
        Assert.assertEquals((Object)"false", (Object)extras.getProperty("caseSensitive"));
        Assert.assertEquals((Object)"UNCHANGED", (Object)extras.getProperty("unquotedCasing"));
        Assert.assertEquals((Object)"BRACKET", (Object)extras.getProperty("quoting"));
        Assert.assertEquals((Object)"DEFAULT", (Object)extras.getProperty("conformance"));
    }

    @Test
    public void testSetKylinConfigInEnvIfMissingTakingEmptyProperties() {
        Properties properties = new Properties();
        KylinConfig.setKylinConfigInEnvIfMissing(properties);
        Assert.assertEquals((long)0L, (long)properties.size());
        Assert.assertTrue((boolean)properties.isEmpty());
        KylinConfig.setKylinConfigInEnvIfMissing(properties);
        Assert.assertEquals((long)0L, (long)properties.size());
        Assert.assertTrue((boolean)properties.isEmpty());
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateInstanceFromUriThrowsIllegalStateExceptionOne() {
        KylinConfig.createInstanceFromUri("cb%MnlG]3:nav");
    }

    @Test(expected=RuntimeException.class)
    public void testCreateInstanceFromUriThrowsRuntimeException() {
        Properties properties = new Properties();
        KylinConfig.setKylinConfigInEnvIfMissing(properties);
        Assert.assertEquals((long)0L, (long)properties.size());
        Assert.assertTrue((boolean)properties.isEmpty());
        KylinConfig.createInstanceFromUri("dHy3K~m");
    }

    @Test
    public void testKylinConfigExt() {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        HashMap<String, String> overrideConf1 = new HashMap<String, String>();
        overrideConf1.put("foo", "fooValue");
        overrideConf1.put("bar", "");
        KylinConfigExt ext1 = KylinConfigExt.createInstance(conf, overrideConf1);
        HashMap<String, String> overrideConf2 = new HashMap<String, String>();
        overrideConf2.put("bar", "barValue");
        KylinConfigExt ext2 = KylinConfigExt.createInstance(ext1, overrideConf2);
        Assert.assertEquals((Object)ext2.getOptional("foo"), (Object)"fooValue");
        Assert.assertEquals((Object)ext2.getOptional("bar"), (Object)"barValue");
    }
}

