/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.cachemanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.spy.memcached.MemcachedClientIF;
import org.apache.kylin.cache.memcached.MemcachedCache;
import org.apache.kylin.cache.memcached.MemcachedCacheConfig;
import org.apache.kylin.cache.memcached.MemcachedChunkingCache;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;
import org.springframework.cache.support.SimpleValueWrapper;

public class MemcachedCacheManager
extends AbstractCacheManager {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedCacheManager.class);
    private static final Long ONE_MINUTE = 60000L;
    @Autowired
    private MemcachedCacheConfig memcachedCacheConfig;
    private ScheduledExecutorService timer = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("Memcached-HealthChecker").build());
    private AtomicBoolean clusterHealth = new AtomicBoolean(true);

    protected Collection<? extends Cache> loadCaches() {
        MemCachedCacheAdaptor successCache = new MemCachedCacheAdaptor(new MemcachedChunkingCache(MemcachedCache.create(this.memcachedCacheConfig, "StorageCache")));
        this.addCache(successCache);
        Collection names = this.getCacheNames();
        ArrayList<Cache> caches = Lists.newArrayList();
        for (String name : names) {
            caches.add(this.getCache(name));
        }
        this.timer.scheduleWithFixedDelay(new MemcachedClusterHealthChecker(), ONE_MINUTE, ONE_MINUTE, TimeUnit.MILLISECONDS);
        return caches;
    }

    public boolean isClusterDown() {
        return !this.clusterHealth.get();
    }

    @VisibleForTesting
    void setClusterHealth(boolean ifHealth) {
        this.clusterHealth.set(ifHealth);
    }

    private class MemcachedClusterHealthChecker
    implements Runnable {
        private MemcachedClusterHealthChecker() {
        }

        @Override
        public void run() {
            Cache cache = MemcachedCacheManager.this.getCache("StorageCache");
            MemcachedClientIF cacheClient = (MemcachedClientIF)cache.getNativeCache();
            Collection liveServers = cacheClient.getAvailableServers();
            Collection deadServers = cacheClient.getUnavailableServers();
            if (liveServers.isEmpty()) {
                MemcachedCacheManager.this.clusterHealth.set(false);
                logger.error("All the servers in MemcachedCluster is down, UnavailableServers: " + deadServers);
            } else {
                MemcachedCacheManager.this.clusterHealth.set(true);
                if (deadServers.size() > liveServers.size()) {
                    logger.warn("Half of the servers in MemcachedCluster is down, LiveServers: " + liveServers + ", UnavailableServers: " + deadServers);
                }
            }
        }
    }

    public static class MemCachedCacheAdaptor
    implements Cache {
        private MemcachedCache memcachedCache;

        public MemCachedCacheAdaptor(MemcachedCache memcachedCache) {
            this.memcachedCache = memcachedCache;
        }

        public String getName() {
            return this.memcachedCache.getName();
        }

        public Object getNativeCache() {
            return this.memcachedCache.getNativeCache();
        }

        public Cache.ValueWrapper get(Object key) {
            byte[] value = this.memcachedCache.get(key);
            if (value == null) {
                return null;
            }
            return new SimpleValueWrapper(SerializationUtils.deserialize(value));
        }

        public void put(Object key, Object value) {
            this.memcachedCache.put(key, value);
        }

        public void evict(Object key) {
            this.memcachedCache.evict(key);
        }

        public void clear() {
            this.memcachedCache.clear();
        }

        public <T> T get(Object key, Class<T> type) {
            byte[] value = this.memcachedCache.get(key);
            if (value == null) {
                return null;
            }
            Object obj = SerializationUtils.deserialize(value);
            if (obj != null && type != null && !type.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
            }
            return obj;
        }

        public <T> T get(Object key, Callable<T> valueLoader) {
            throw new UnsupportedOperationException();
        }

        public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
            byte[] existing = this.memcachedCache.get(key);
            if (existing == null) {
                this.memcachedCache.put(key, value);
                return null;
            }
            return new SimpleValueWrapper(SerializationUtils.deserialize(existing));
        }
    }
}

