"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class SimpleFileEntry {
    constructor(_path, _content) {
        this._path = _path;
        this._content = _content;
    }
    get path() { return this._path; }
    get content() { return this._content; }
}
exports.SimpleFileEntry = SimpleFileEntry;
class LazyFileEntry {
    constructor(_path, _load) {
        this._path = _path;
        this._load = _load;
        this._content = null;
    }
    get path() { return this._path; }
    get content() { return this._content || (this._content = this._load(this._path)); }
}
exports.LazyFileEntry = LazyFileEntry;
//# sourceMappingURL=data:application/json;base64,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