/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiAuthRole;
import com.cloudera.api.swagger.model.ApiCluster;
import com.cloudera.api.swagger.model.ApiCmPeer;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiDataContextList;
import com.cloudera.api.swagger.model.ApiExternalUserMapping;
import com.cloudera.api.swagger.model.ApiHost;
import com.cloudera.api.swagger.model.ApiHostTemplateList;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiUser2;
import com.cloudera.api.swagger.model.ApiVersionInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This objects represents a deployment including all clusters, hosts, services, roles, etc in the system.  It can be used to save and restore all settings. This model will be used v18 and beyond since users will be represented by ApiUser2 v18 and beyond.")
public class ApiDeployment2 {
    @SerializedName(value="timestamp")
    private String timestamp = null;
    @SerializedName(value="clusters")
    private List<ApiCluster> clusters = null;
    @SerializedName(value="hosts")
    private List<ApiHost> hosts = null;
    @SerializedName(value="authRoles")
    private List<ApiAuthRole> authRoles = null;
    @SerializedName(value="externalUserMappings")
    private List<ApiExternalUserMapping> externalUserMappings = null;
    @SerializedName(value="users")
    private List<ApiUser2> users = null;
    @SerializedName(value="versionInfo")
    private ApiVersionInfo versionInfo = null;
    @SerializedName(value="managementService")
    private ApiService managementService = null;
    @SerializedName(value="managerSettings")
    private ApiConfigList managerSettings = null;
    @SerializedName(value="allHostsConfig")
    private ApiConfigList allHostsConfig = null;
    @SerializedName(value="peers")
    private List<ApiCmPeer> peers = null;
    @SerializedName(value="hostTemplates")
    private ApiHostTemplateList hostTemplates = null;
    @SerializedName(value="dataContexts")
    private ApiDataContextList dataContexts = null;

    public ApiDeployment2 timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="Readonly. This timestamp is provided when you request a deployment and is not required (or even read) when creating a deployment. This timestamp is useful if you have multiple deployments saved and want to determine which one to use as a restore point.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public ApiDeployment2 clusters(List<ApiCluster> clusters) {
        this.clusters = clusters;
        return this;
    }

    public ApiDeployment2 addClustersItem(ApiCluster clustersItem) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<ApiCluster>();
        }
        this.clusters.add(clustersItem);
        return this;
    }

    @ApiModelProperty(value="List of clusters in the system including their services, roles and complete config values.")
    public List<ApiCluster> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<ApiCluster> clusters) {
        this.clusters = clusters;
    }

    public ApiDeployment2 hosts(List<ApiHost> hosts) {
        this.hosts = hosts;
        return this;
    }

    public ApiDeployment2 addHostsItem(ApiHost hostsItem) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<ApiHost>();
        }
        this.hosts.add(hostsItem);
        return this;
    }

    @ApiModelProperty(value="List of hosts in the system")
    public List<ApiHost> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<ApiHost> hosts) {
        this.hosts = hosts;
    }

    public ApiDeployment2 authRoles(List<ApiAuthRole> authRoles) {
        this.authRoles = authRoles;
        return this;
    }

    public ApiDeployment2 addAuthRolesItem(ApiAuthRole authRolesItem) {
        if (this.authRoles == null) {
            this.authRoles = new ArrayList<ApiAuthRole>();
        }
        this.authRoles.add(authRolesItem);
        return this;
    }

    @ApiModelProperty(value="List of all auth roles in the system Available from v32")
    public List<ApiAuthRole> getAuthRoles() {
        return this.authRoles;
    }

    public void setAuthRoles(List<ApiAuthRole> authRoles) {
        this.authRoles = authRoles;
    }

    public ApiDeployment2 externalUserMappings(List<ApiExternalUserMapping> externalUserMappings) {
        this.externalUserMappings = externalUserMappings;
        return this;
    }

    public ApiDeployment2 addExternalUserMappingsItem(ApiExternalUserMapping externalUserMappingsItem) {
        if (this.externalUserMappings == null) {
            this.externalUserMappings = new ArrayList<ApiExternalUserMapping>();
        }
        this.externalUserMappings.add(externalUserMappingsItem);
        return this;
    }

    @ApiModelProperty(value="List of all external user mappings in the system Available from v32")
    public List<ApiExternalUserMapping> getExternalUserMappings() {
        return this.externalUserMappings;
    }

    public void setExternalUserMappings(List<ApiExternalUserMapping> externalUserMappings) {
        this.externalUserMappings = externalUserMappings;
    }

    public ApiDeployment2 users(List<ApiUser2> users) {
        this.users = users;
        return this;
    }

    public ApiDeployment2 addUsersItem(ApiUser2 usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<ApiUser2>();
        }
        this.users.add(usersItem);
        return this;
    }

    @ApiModelProperty(value="List of all users in the system")
    public List<ApiUser2> getUsers() {
        return this.users;
    }

    public void setUsers(List<ApiUser2> users) {
        this.users = users;
    }

    public ApiDeployment2 versionInfo(ApiVersionInfo versionInfo) {
        this.versionInfo = versionInfo;
        return this;
    }

    @ApiModelProperty(value="Full version information about the running Cloudera Manager instance")
    public ApiVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(ApiVersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public ApiDeployment2 managementService(ApiService managementService) {
        this.managementService = managementService;
        return this;
    }

    @ApiModelProperty(value="The full configuration of the Cloudera Manager management service including all the management roles and their config values")
    public ApiService getManagementService() {
        return this.managementService;
    }

    public void setManagementService(ApiService managementService) {
        this.managementService = managementService;
    }

    public ApiDeployment2 managerSettings(ApiConfigList managerSettings) {
        this.managerSettings = managerSettings;
        return this;
    }

    @ApiModelProperty(value="The full configuration of Cloudera Manager itself including licensing info")
    public ApiConfigList getManagerSettings() {
        return this.managerSettings;
    }

    public void setManagerSettings(ApiConfigList managerSettings) {
        this.managerSettings = managerSettings;
    }

    public ApiDeployment2 allHostsConfig(ApiConfigList allHostsConfig) {
        this.allHostsConfig = allHostsConfig;
        return this;
    }

    @ApiModelProperty(value="Configuration parameters that apply to all hosts, unless overridden at the host level. Available since API v3.")
    public ApiConfigList getAllHostsConfig() {
        return this.allHostsConfig;
    }

    public void setAllHostsConfig(ApiConfigList allHostsConfig) {
        this.allHostsConfig = allHostsConfig;
    }

    public ApiDeployment2 peers(List<ApiCmPeer> peers) {
        this.peers = peers;
        return this;
    }

    public ApiDeployment2 addPeersItem(ApiCmPeer peersItem) {
        if (this.peers == null) {
            this.peers = new ArrayList<ApiCmPeer>();
        }
        this.peers.add(peersItem);
        return this;
    }

    @ApiModelProperty(value="The list of peers configured in Cloudera Manager. Available since API v3.")
    public List<ApiCmPeer> getPeers() {
        return this.peers;
    }

    public void setPeers(List<ApiCmPeer> peers) {
        this.peers = peers;
    }

    public ApiDeployment2 hostTemplates(ApiHostTemplateList hostTemplates) {
        this.hostTemplates = hostTemplates;
        return this;
    }

    @ApiModelProperty(value="The list of all host templates in Cloudera Manager.")
    public ApiHostTemplateList getHostTemplates() {
        return this.hostTemplates;
    }

    public void setHostTemplates(ApiHostTemplateList hostTemplates) {
        this.hostTemplates = hostTemplates;
    }

    public ApiDeployment2 dataContexts(ApiDataContextList dataContexts) {
        this.dataContexts = dataContexts;
        return this;
    }

    @ApiModelProperty(value="The list of all the data contexts in the Cloudera Manager.")
    public ApiDataContextList getDataContexts() {
        return this.dataContexts;
    }

    public void setDataContexts(ApiDataContextList dataContexts) {
        this.dataContexts = dataContexts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiDeployment2 apiDeployment2 = (ApiDeployment2)o;
        return Objects.equals(this.timestamp, apiDeployment2.timestamp) && Objects.equals(this.clusters, apiDeployment2.clusters) && Objects.equals(this.hosts, apiDeployment2.hosts) && Objects.equals(this.authRoles, apiDeployment2.authRoles) && Objects.equals(this.externalUserMappings, apiDeployment2.externalUserMappings) && Objects.equals(this.users, apiDeployment2.users) && Objects.equals(this.versionInfo, apiDeployment2.versionInfo) && Objects.equals(this.managementService, apiDeployment2.managementService) && Objects.equals(this.managerSettings, apiDeployment2.managerSettings) && Objects.equals(this.allHostsConfig, apiDeployment2.allHostsConfig) && Objects.equals(this.peers, apiDeployment2.peers) && Objects.equals(this.hostTemplates, apiDeployment2.hostTemplates) && Objects.equals(this.dataContexts, apiDeployment2.dataContexts);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.clusters, this.hosts, this.authRoles, this.externalUserMappings, this.users, this.versionInfo, this.managementService, this.managerSettings, this.allHostsConfig, this.peers, this.hostTemplates, this.dataContexts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiDeployment2 {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    clusters: ").append(this.toIndentedString(this.clusters)).append("\n");
        sb.append("    hosts: ").append(this.toIndentedString(this.hosts)).append("\n");
        sb.append("    authRoles: ").append(this.toIndentedString(this.authRoles)).append("\n");
        sb.append("    externalUserMappings: ").append(this.toIndentedString(this.externalUserMappings)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    versionInfo: ").append(this.toIndentedString(this.versionInfo)).append("\n");
        sb.append("    managementService: ").append(this.toIndentedString(this.managementService)).append("\n");
        sb.append("    managerSettings: ").append(this.toIndentedString(this.managerSettings)).append("\n");
        sb.append("    allHostsConfig: ").append(this.toIndentedString(this.allHostsConfig)).append("\n");
        sb.append("    peers: ").append(this.toIndentedString(this.peers)).append("\n");
        sb.append("    hostTemplates: ").append(this.toIndentedString(this.hostTemplates)).append("\n");
        sb.append("    dataContexts: ").append(this.toIndentedString(this.dataContexts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

