/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout;

import org.opensaml.saml.saml2.core.LogoutRequest;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.state.StateGenerator;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.logout.impl.SAML2LogoutRequestBuilder;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.profile.api.SAML2ProfileHandler;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class SAML2LogoutActionBuilder<U extends SAML2Profile>
implements LogoutActionBuilder<U> {
    protected SAML2LogoutRequestBuilder saml2LogoutRequestBuilder;
    protected final SAML2ProfileHandler<LogoutRequest> logoutProfileHandler;
    protected final SAMLContextProvider contextProvider;
    protected final SAML2Configuration configuration;
    protected final StateGenerator stateGenerator;
    protected final LogoutHandler logoutHandler;

    public SAML2LogoutActionBuilder(SAML2Client client) {
        this.logoutProfileHandler = client.getLogoutProfileHandler();
        this.contextProvider = client.getContextProvider();
        this.configuration = client.getConfiguration();
        this.stateGenerator = client.getStateGenerator();
        this.saml2LogoutRequestBuilder = new SAML2LogoutRequestBuilder(this.configuration.getSpLogoutRequestBindingType());
        this.logoutHandler = client.getConfiguration().getLogoutHandler();
    }

    public RedirectAction getLogoutAction(WebContext context, U currentProfile, String targetUrl) {
        SAML2MessageContext samlContext = this.contextProvider.buildContext(context);
        String relayState = this.stateGenerator.generateState(context);
        LogoutRequest logoutRequest = this.saml2LogoutRequestBuilder.build(samlContext, (SAML2Profile)((Object)currentProfile));
        this.logoutProfileHandler.send(samlContext, logoutRequest, relayState);
        this.logoutHandler.destroySessionFront(context, ((SAML2Profile)((Object)currentProfile)).getSessionIndex());
        Pac4jSAMLResponse adapter = samlContext.getProfileRequestContextOutboundMessageTransportResponse();
        if (this.configuration.getSpLogoutRequestBindingType().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            String content = adapter.getOutgoingContent();
            return RedirectAction.success((String)content);
        }
        String location = adapter.getRedirectUrl();
        return RedirectAction.redirect((String)location);
    }
}

