/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.KubernetesJwtSupplier;

public class KubernetesServiceAccountTokenFile
implements KubernetesJwtSupplier {
    public static final String DEFAULT_KUBERNETES_SERVICE_ACCOUNT_TOKEN_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private byte[] token;

    public KubernetesServiceAccountTokenFile() {
        this(DEFAULT_KUBERNETES_SERVICE_ACCOUNT_TOKEN_FILE);
    }

    public KubernetesServiceAccountTokenFile(String path) {
        this((Resource)new FileSystemResource(path));
    }

    public KubernetesServiceAccountTokenFile(File file) {
        this((Resource)new FileSystemResource(file));
    }

    public KubernetesServiceAccountTokenFile(Resource resource) {
        Assert.isTrue((boolean)resource.exists(), () -> String.format("Resource %s does not exist", resource));
        try {
            this.token = KubernetesServiceAccountTokenFile.readToken(resource);
        }
        catch (IOException e) {
            throw new VaultException(String.format("Kube JWT token retrieval from %s failed", resource), e);
        }
    }

    @Override
    public String get() {
        return new String(this.token, StandardCharsets.US_ASCII);
    }

    protected static byte[] readToken(Resource resource) throws IOException {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        try (InputStream is = resource.getInputStream();){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
    }
}

