/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.security;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.filter.security.AbstractIdentityAssertionBase;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.GatewaySpiResources;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.security.principal.PrincipalMapper;
import org.apache.knox.gateway.security.principal.PrincipalMappingException;
import org.apache.knox.gateway.security.principal.SimplePrincipalMapper;

public abstract class AbstractIdentityAssertionFilter
extends AbstractIdentityAssertionBase
implements Filter {
    private static final GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final GatewaySpiResources RES = (GatewaySpiResources)ResourcesFactory.get(GatewaySpiResources.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    protected PrincipalMapper mapper = new SimplePrincipalMapper();

    protected void loadPrincipalMappings(FilterConfig filterConfig) {
        String principalMapping = filterConfig.getServletContext().getInitParameter("principal.mapping");
        String groupMapping = filterConfig.getServletContext().getInitParameter("group.principal.mapping");
        if (principalMapping != null && !principalMapping.isEmpty() || groupMapping != null && !groupMapping.isEmpty()) {
            try {
                this.mapper.loadMappingTable(principalMapping, groupMapping);
            }
            catch (PrincipalMappingException pme) {
                LOG.failedToLoadPrincipalMappingTable(pme);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.loadPrincipalMappings(filterConfig);
    }

    public void destroy() {
    }
}

