/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.util.HashMap;
import java.util.Map;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAdminConfigurationNotifier
implements ConfigurationNotifier {
    public static Logger LOG = LoggerFactory.getLogger(EventAdminConfigurationNotifier.class);
    private ServiceTracker<EventAdmin, EventAdmin> tracker;

    public EventAdminConfigurationNotifier(BundleContext context) {
        this.tracker = new ServiceTracker(context, EventAdmin.class, null);
        this.tracker.open();
    }

    @Override
    public void configurationDone() {
        EventAdmin ea = (EventAdmin)this.tracker.getService();
        if (ea != null) {
            LOG.info("Sending Event Admin notification (configuration successful) to org/ops4j/pax/logging/Configuration");
            ea.postEvent(new Event("org/ops4j/pax/logging/Configuration", (Map)null));
        } else {
            LOG.info("Logging configuration changed. (Event Admin service unavailable - no notification sent).");
        }
    }

    @Override
    public void configurationError(Throwable t) {
        EventAdmin ea = (EventAdmin)this.tracker.getService();
        if (ea != null) {
            LOG.warn("Sending Event Admin notification (configuration error) to org/ops4j/pax/logging/Configuration");
            HashMap<String, Throwable> properties = new HashMap<String, Throwable>();
            properties.put("exception", t);
            ea.postEvent(new Event("org/ops4j/pax/logging/Configuration", (Map)new EventProperties(properties)));
        } else {
            LOG.warn("Logging configuration problem. (Event Admin service unavailable - no notification sent).", t);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }
}

