/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="shell", name="kill", description="Interrupt a given thread")
@Service
public class ThreadKillAction
implements Action {
    @Argument(name="id", description="Interrupt the thread with this id", required=true, multiValued=false)
    Long id;

    public Object execute() throws Exception {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threadList = new Thread[threadGroup.activeCount()];
        int count = threadGroup.enumerate(threadList, true);
        for (int i = 0; i < count; ++i) {
            if (threadList[i].getId() != this.id.longValue()) continue;
            try {
                System.out.println("Interrupting " + threadList[i].getName() + " (" + threadList[i].getId() + ")");
                threadList[i].interrupt();
            }
            catch (Exception e) {
                System.err.println("Can't interrtupt: " + e.getMessage());
            }
            return null;
        }
        System.err.println("kill " + this.id + " failed: no such thread");
        return null;
    }
}

