/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.karaf.bundle.command.BundleCommand;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.util.bundles.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;

@Command(scope="bundle", name="update", description="Update bundle.")
@Service
public class Update
extends BundleCommand {
    @Argument(index=1, name="location", description="The bundles update location", required=false, multiValued=false)
    URI location;
    @Option(name="--raw", description="Do not update the bundles's Bundle-UpdateLocation manifest header")
    boolean raw;
    @Option(name="-r", aliases={"--refresh"}, description="Perform a refresh after the bundle update", required=false, multiValued=false)
    boolean refresh;

    @Override
    protected Object doExecute(Bundle bundle) throws Exception {
        if (this.location != null) {
            this.update(bundle, this.location.toURL());
        } else {
            String loc = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
            if (loc != null && !loc.equals(bundle.getLocation())) {
                this.update(bundle, new URL(loc));
            } else {
                bundle.update();
            }
        }
        if (this.refresh) {
            FrameworkWiring wiring = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
            wiring.refreshBundles(null, new FrameworkListener[0]);
        }
        return null;
    }

    private void update(Bundle bundle, URL location) throws IOException, BundleException {
        block12: {
            try (InputStream is = location.openStream();){
                if (this.raw) {
                    bundle.update(is);
                    break block12;
                }
                File file = BundleUtils.fixBundleWithUpdateLocation(is, location.toString());
                try (FileInputStream fis = new FileInputStream(file);){
                    bundle.update((InputStream)fis);
                }
                file.delete();
            }
        }
    }
}

