/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;

public class RSABufferPublicKeyParser
extends AbstractBufferPublicKeyParser<RSAPublicKey> {
    public static final RSABufferPublicKeyParser INSTANCE = new RSABufferPublicKeyParser();

    public RSABufferPublicKeyParser() {
        super(RSAPublicKey.class, "ssh-rsa");
    }

    @Override
    public RSAPublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(keyType), "Unsupported key type: %s", (Object)keyType);
        BigInteger e = buffer.getMPInt();
        BigInteger n = buffer.getMPInt();
        return (RSAPublicKey)this.generatePublicKey("RSA", new RSAPublicKeySpec(n, e));
    }
}

