/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.karaf.features.BootFinished;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.internal.service.FeaturesServiceImpl;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootFeaturesInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(BootFeaturesInstaller.class);
    private final FeaturesServiceImpl featuresService;
    private final BundleContext bundleContext;
    private final String[] repositories;
    private final String features;
    private final boolean asynchronous;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;

    public BootFeaturesInstaller(BundleContext bundleContext, FeaturesServiceImpl featuresService, String[] repositories, String features, boolean asynchronous) {
        this.bundleContext = bundleContext;
        this.featuresService = featuresService;
        this.repositories = repositories;
        this.features = features;
        this.asynchronous = asynchronous;
    }

    public void start() {
        if (this.featuresService.isBootDone()) {
            this.publishBootFinished();
            return;
        }
        if (this.asynchronous) {
            new Thread("Initial Features Provisioning"){

                @Override
                public void run() {
                    BootFeaturesInstaller.this.installBootFeatures();
                }
            }.start();
        } else {
            this.installBootFeatures();
        }
    }

    protected void installBootFeatures() {
        try {
            this.addRepositories();
            List<Set<String>> stagedFeatures = this.parseBootFeatures(this.features);
            for (Set<String> features : stagedFeatures) {
                this.featuresService.installFeatures(features, EnumSet.of(FeaturesService.Option.NoFailOnFeatureNotFound));
            }
            this.featuresService.bootDone();
            this.publishBootFinished();
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                try {
                    this.bundleContext.getBundle();
                }
                catch (IllegalStateException ies) {
                    return;
                }
            }
            LOGGER.error("Error installing boot features", e);
        }
    }

    private void addRepositories() {
        for (String repo : this.repositories) {
            if ((repo = repo.trim()).isEmpty()) continue;
            repo = this.separatorsToUnix(repo);
            repo = this.encodePath(repo);
            try {
                this.featuresService.addRepository(URI.create(repo));
            }
            catch (Exception e) {
                LOGGER.error("Error installing boot feature repository " + repo, (Throwable)e);
            }
        }
    }

    protected List<Set<String>> parseBootFeatures(String bootFeatures) {
        ArrayList<Set<String>> stages = new ArrayList<Set<String>>();
        StringTokenizer tokenizer = new StringTokenizer(bootFeatures, " \t\r\n,()", true);
        int paren = 0;
        LinkedHashSet<String> stage = new LinkedHashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("(")) {
                if (paren == 0) {
                    if (!stage.isEmpty()) {
                        stages.add(stage);
                        stage = new LinkedHashSet();
                    }
                    ++paren;
                    continue;
                }
                throw new IllegalArgumentException("Bad syntax in boot features: '" + bootFeatures + "'");
            }
            if (token.equals(")")) {
                if (paren == 1) {
                    if (!stage.isEmpty()) {
                        stages.add(stage);
                        stage = new LinkedHashSet();
                    }
                    --paren;
                    continue;
                }
                throw new IllegalArgumentException("Bad syntax in boot features: '" + bootFeatures + "'");
            }
            if (token.matches("[ \t\r\n]+|,")) continue;
            stage.add(token);
        }
        if (!stage.isEmpty()) {
            stages.add(stage);
        }
        return stages;
    }

    private void publishBootFinished() {
        if (this.bundleContext != null) {
            BootFinished bootFinished = new BootFinished(){};
            this.bundleContext.registerService(BootFinished.class, (Object)bootFinished, new Hashtable());
        }
    }

    private String separatorsToUnix(String path) {
        if (SYSTEM_SEPARATOR == '\\') {
            if (path == null || path.indexOf(92) == -1) {
                return path;
            }
            path = path.replace('\\', '/');
            LOGGER.debug("Converted path to unix separators: {}", (Object)path);
        }
        return path;
    }

    private String encodePath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(" ", "%20");
    }
}

