/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;

public class KarafConfigurationPlugin
implements ConfigurationPlugin {
    public static final String PLUGIN_ID = "org.apache.karaf.config.plugin";
    public static final int PLUGIN_RANKING = 500;

    public void modifyConfiguration(ServiceReference<?> reference, Dictionary<String, Object> properties) {
        Object pid = properties.get("service.pid");
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String value;
            String key = keys.nextElement();
            String env = (pid + "." + key).toUpperCase().replaceAll("\\.", "_");
            String sys = pid + "." + key;
            if (System.getenv(env) != null) {
                value = InterpolationHelper.substVars(System.getenv(env), null, null, KarafConfigurationPlugin.convertDictionaryToMap(properties));
                if (properties.get(key) != null && properties.get(key) instanceof Number) {
                    properties.put(key, Integer.parseInt(value));
                    continue;
                }
                properties.put(key, value);
                continue;
            }
            if (System.getProperty(sys) == null) continue;
            value = InterpolationHelper.substVars(System.getProperty(sys), null, null, KarafConfigurationPlugin.convertDictionaryToMap(properties));
            if (properties.get(key) != null && properties.get(key) instanceof Number) {
                properties.put(key, Integer.parseInt(value));
                continue;
            }
            properties.put(key, value);
        }
    }

    private static Map<String, String> convertDictionaryToMap(Dictionary<String, Object> dictionary) {
        HashMap<String, String> converted = new HashMap<String, String>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            converted.put(key, dictionary.get(key).toString());
        }
        return converted;
    }
}

