/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.AuditLevel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.MessageFormatter;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.log.LogLevel;

public abstract class Category
implements AppenderAttachable,
PaxLoggingManagerAwareLogger {
    protected static final String LOG4J_FQCN = Logger.class.getName();
    protected static PaxLoggingManager m_paxLogging;
    protected PaxLogger m_delegate;
    protected String name;
    protected volatile Level level;
    protected volatile Category parent;
    private static final String FQCN;
    protected LoggerRepository repository;
    protected boolean additive = true;

    protected Category(String name) {
        this.name = name;
    }

    protected Category(String name, PaxLogger delegate) {
        this.name = name;
        this.m_delegate = delegate;
    }

    public static void configurePaxLoggingManager(PaxLoggingManager manager) {
        m_paxLogging = manager;
    }

    @Override
    public void setPaxLoggingManager(PaxLoggingManager loggingManager) {
        this.m_delegate = loggingManager == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(Logger.class), this.name) : loggingManager.getLogger(this.name, LOG4J_FQCN);
    }

    @Override
    public synchronized void addAppender(Appender newAppender) {
        throw new UnsupportedOperationException("Operation not supported in pax-logging");
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.error(msg);
        }
    }

    public void callAppenders(LoggingEvent event) {
        Throwable t = event.getThrowableInformation() == null ? null : event.getThrowableInformation().getThrowable();
        this.log(event.getFQNOfLoggerClass(), event.getLevel(), event.getMessage(), t);
    }

    synchronized void closeNestedAppenders() {
    }

    public void debug(Object message) {
        this.m_delegate.debug(message == null ? null : message.toString());
    }

    public void debug(Object message, Throwable t) {
        this.m_delegate.debug(message == null ? null : message.toString(), (Object)t);
    }

    public void debug(Object messagePattern, Object arg) {
        if (this.m_delegate.isDebugEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.debug(msgStr);
        }
    }

    public void debug(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isDebugEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.debug(msgStr);
        }
    }

    public void trace(Object message) {
        this.m_delegate.trace(message == null ? null : message.toString());
    }

    public void trace(Object message, Throwable t) {
        this.m_delegate.trace(message == null ? null : message.toString(), (Object)t);
    }

    public void trace(Object messagePattern, Object arg) {
        if (this.m_delegate.isTraceEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.trace(msgStr);
        }
    }

    public void trace(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isTraceEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.trace(msgStr);
        }
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public void error(Object message) {
        this.m_delegate.error(message == null ? null : message.toString());
    }

    public void error(Object message, Throwable t) {
        this.m_delegate.error(message == null ? null : message.toString(), (Object)t);
    }

    public void error(Object messagePattern, Object arg) {
        if (this.m_delegate.isErrorEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.error(msgStr);
        }
    }

    public void error(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isErrorEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.error(msgStr);
        }
    }

    public static Logger exists(String name) {
        throw new UnsupportedOperationException("Deprecated in log4j since Sep 5, 2001");
    }

    public void fatal(Object message) {
        this.m_delegate.fatal(message == null ? null : message.toString());
    }

    public void fatal(Object messagePattern, Object arg) {
        if (this.m_delegate.isFatalEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.fatal(msgStr);
        }
    }

    public void fatal(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isFatalEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.fatal(msgStr);
        }
    }

    public void fatal(Object message, Throwable t) {
        this.m_delegate.fatal(message == null ? null : message.toString(), (Object)t);
    }

    protected void forcedLog(String fqcn, Priority level, Object message, Throwable t) {
        this.log(fqcn, level, message, t);
    }

    public boolean getAdditivity() {
        return this.additive;
    }

    @Override
    public synchronized Enumeration getAllAppenders() {
        return NullEnumeration.getInstance();
    }

    @Override
    public synchronized Appender getAppender(String name) {
        throw new UnsupportedOperationException("Operation not supported in pax-logging");
    }

    public Level getEffectiveLevel() {
        LogLevel level = this.m_delegate.getLogLevel();
        if (level == LogLevel.AUDIT) {
            return AuditLevel.AUDIT;
        }
        if (level == LogLevel.TRACE) {
            return Level.TRACE;
        }
        if (level == LogLevel.DEBUG) {
            return Level.DEBUG;
        }
        if (level == LogLevel.INFO) {
            return Level.INFO;
        }
        if (level == LogLevel.WARN) {
            return Level.WARN;
        }
        if (level == LogLevel.ERROR) {
            return Level.ERROR;
        }
        return Level.OFF;
    }

    public Priority getChainedPriority() {
        throw new UnsupportedOperationException("Deprecated in log4j since Mar 12, 2002");
    }

    public static Enumeration getCurrentCategories() {
        throw new UnsupportedOperationException("Deprecated in log4j since Sep 5, 2001");
    }

    public static LoggerRepository getDefaultHierarchy() {
        throw new UnsupportedOperationException("Deprecated in log4j since Nov 18, 2001");
    }

    public LoggerRepository getHierarchy() {
        throw new UnsupportedOperationException("Deprecated in log4j since Sep 5, 2001");
    }

    public LoggerRepository getLoggerRepository() {
        return this.repository;
    }

    public static Category getInstance(String name) {
        return Logger.getLogger(name);
    }

    public static Category getInstance(Class clazz) {
        return Logger.getLogger(clazz);
    }

    public final String getName() {
        return this.m_delegate.getName();
    }

    public final Category getParent() {
        return null;
    }

    public final Level getLevel() {
        return this.getEffectiveLevel();
    }

    public final Level getPriority() {
        return this.getEffectiveLevel();
    }

    public static Category getRoot() {
        throw new UnsupportedOperationException("Deprecated in log4j since Sep 5, 2001");
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    protected String getResourceBundleString(String key) {
        return null;
    }

    public void info(Object message) {
        this.m_delegate.info(message == null ? null : message.toString());
    }

    public void info(Object messagePattern, Object arg) {
        if (this.m_delegate.isInfoEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.info(msgStr);
        }
    }

    public void info(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isInfoEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.info(msgStr);
        }
    }

    public void info(Object message, Throwable t) {
        this.m_delegate.info(message == null ? null : message.toString(), (Object)t);
    }

    @Override
    public boolean isAttached(Appender appender) {
        return false;
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isEnabledFor(Priority level) {
        if (level == null) {
            return false;
        }
        switch (level.level) {
            case 50000: {
                return this.m_delegate.isFatalEnabled();
            }
            case 40000: {
                return this.m_delegate.isErrorEnabled();
            }
            case 30000: {
                return this.m_delegate.isWarnEnabled();
            }
            case 20000: {
                return this.m_delegate.isInfoEnabled();
            }
            case 10000: {
                return this.m_delegate.isDebugEnabled();
            }
            case -2147483648: 
            case 5000: {
                return this.m_delegate.isTraceEnabled();
            }
        }
        return false;
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        this.log(FQCN, priority, key, t);
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        this.log(FQCN, priority, key, t);
    }

    public void log(Priority priority, Object message, Throwable t) {
        if (priority == null) {
            return;
        }
        switch (priority.level) {
            case 50000: {
                this.fatal(message, t);
                break;
            }
            case 40000: {
                this.error(message, t);
                break;
            }
            case 30000: {
                this.warn(message, t);
                break;
            }
            case 20000: {
                this.info(message, t);
                break;
            }
            case 10000: {
                this.debug(message, t);
                break;
            }
            case -2147483648: 
            case 5000: {
                this.trace(message, t);
            }
        }
    }

    public void log(Priority priority, Object message) {
        this.log(priority, message, null);
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        this.log(level, message, t);
    }

    @Override
    public synchronized void removeAllAppenders() {
        throw new UnsupportedOperationException("Operation not supported in pax-logging");
    }

    @Override
    public synchronized void removeAppender(Appender appender) {
        throw new UnsupportedOperationException("Operation not supported in pax-logging");
    }

    @Override
    public synchronized void removeAppender(String name) {
        throw new UnsupportedOperationException("Operation not supported in pax-logging");
    }

    public void setAdditivity(boolean additive) {
        this.additive = additive;
    }

    final void setHierarchy(LoggerRepository repository) {
        throw new UnsupportedOperationException("Operation not supported in pax-logging");
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setPriority(Priority priority) {
        this.level = (Level)priority;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        throw new UnsupportedOperationException("Operation not supported in pax-logging");
    }

    public static void shutdown() {
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public void warn(Object message) {
        this.m_delegate.warn(message == null ? null : message.toString());
    }

    public void warn(Object message, Throwable t) {
        this.m_delegate.warn(message == null ? null : message.toString(), (Object)t);
    }

    public void warn(Object messagePattern, Object arg) {
        if (this.m_delegate.isWarnEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.warn(msgStr);
        }
    }

    public void warn(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isWarnEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.warn(msgStr);
        }
    }

    static {
        FQCN = Category.class.getName();
    }
}

