/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.specinterface;

import aQute.lib.converter.Converter;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SpecInterface<T> {
    private static final Pattern ASSIGNMENT = Pattern.compile("(\\w++)\\s*=\\s*(\\S+)\\s*");
    private final T instance;
    private final IllegalArgumentException failure;

    public SpecInterface(T convert) {
        this.instance = convert;
        this.failure = null;
    }

    public SpecInterface(IllegalArgumentException exception) {
        this.instance = null;
        this.failure = exception;
    }

    public T instance() {
        if (this.instance == null) {
            throw this.failure;
        }
        return this.instance;
    }

    public String failure() {
        if (this.failure == null) {
            return null;
        }
        return this.failure.getMessage();
    }

    public boolean isFailure() {
        return this.failure != null;
    }

    public static <T> SpecInterface<T> getOptions(Class<T> specification, List<String> args, File base) throws Exception {
        try {
            ArrayList<String> arguments = new ArrayList<String>(args);
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            HashMap<String, Object> values = new HashMap<String, Object>();
            Map<String, O> options = SpecInterface.parse(specification);
            int n = 0;
            while (n < arguments.size()) {
                String option = (String)arguments.get(n);
                if (option.startsWith("--")) {
                    arguments.remove(n);
                    if (option.equals("--")) break;
                    O o = options.get(option);
                    if (o == null) {
                        throw new IllegalArgumentException("No such option " + option);
                    }
                    if (!o.hasParameter) continue;
                    String value = (String)arguments.remove(n);
                    SpecInterface.add(values, o, value);
                    continue;
                }
                if (option.startsWith("-")) {
                    arguments.remove(n);
                    for (int i = 1; i < option.length(); ++i) {
                        String opt = "-" + option.charAt(i);
                        O o = options.get(opt);
                        if (o == null) {
                            throw new IllegalArgumentException("No such option " + opt);
                        }
                        if (o.hasParameter) {
                            if (i != option.length() - 1) {
                                throw new IllegalArgumentException("Option " + opt + " has a value but it is not the last in a sequence " + option);
                            }
                            String value = (String)arguments.remove(n);
                            SpecInterface.add(values, o, value);
                            continue;
                        }
                        values.put(o.name, true);
                    }
                    continue;
                }
                Matcher m = ASSIGNMENT.matcher(option);
                if (m.matches()) {
                    arguments.remove(n);
                    properties.put(m.group(1), m.group(2));
                    continue;
                }
                ++n;
            }
            values.put("_arguments", arguments);
            values.put("_properties", properties);
            Converter c = new Converter();
            if (base != null) {
                c.setBase(base);
            }
            return new SpecInterface<T>(c.convert(specification, values));
        }
        catch (IllegalArgumentException e) {
            return new SpecInterface<T>(e);
        }
    }

    public static Class<?> getParameterizedSuperType(Class<?> baseType) {
        ParameterizedType ptype;
        Type p1;
        assert (baseType != null);
        Type type = baseType.getGenericSuperclass();
        if (type instanceof ParameterizedType && (p1 = (ptype = (ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)p1;
        }
        return null;
    }

    public static Class<?> getParameterizedInterfaceType(Class<?> baseType, Class<?> interfce) {
        assert (baseType != null);
        assert (interfce != null);
        assert (interfce.isInterface());
        for (Type type : baseType.getGenericInterfaces()) {
            Type p1;
            ParameterizedType ptype;
            if (!(type instanceof ParameterizedType) || (ptype = (ParameterizedType)type).getRawType() != interfce || !((p1 = ptype.getActualTypeArguments()[0]) instanceof Class)) continue;
            return (Class)p1;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void add(Map<String, Object> map, O o, String value) {
        Object v = map.get(o.name);
        if (v != null) {
            if (!Converter.isMultiple(o.type)) throw new IllegalArgumentException("multiple return values for " + o + " " + v + ", " + value);
            if (v instanceof List) {
                ((List)v).add(value);
                return;
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(v);
                l.add(value);
                map.put(o.name, l);
            }
            return;
        } else {
            map.put(o.name, value);
        }
    }

    static Map<String, O> parse(Class<?> type) {
        LinkedHashMap<String, O> map = new LinkedHashMap<String, O>();
        List<Method> methods = Arrays.asList(type.getMethods());
        Collections.sort(methods, (a, b) -> a.getName().compareTo(b.getName()));
        for (Method m : methods) {
            if (m.getParameterCount() > 1) continue;
            O o = (O)map.get(m.getName());
            if (o == null) {
                o = new O(m);
                map.put(m.getName(), o);
                char c = m.getName().charAt(0);
                String alias = "-" + c;
                O minor = map.putIfAbsent(alias, o);
                if (minor != null) {
                    alias = "-" + Character.toUpperCase(c);
                    map.putIfAbsent(alias, o);
                } else {
                    alias = null;
                }
                if (alias != null) {
                    o.aliases.add(alias);
                }
                String longAlias = "--" + m.getName();
                map.put(longAlias, o);
                o.aliases.add(longAlias);
            }
            if (m.getParameterCount() == 0) {
                o.noargs = m;
            } else {
                o.withDefault = m;
            }
            if (o.type == null) {
                o.type = m.getGenericReturnType();
                o.hasParameter = o.type != Boolean.class && o.type != Boolean.TYPE;
                continue;
            }
            assert (o.type.equals(m.getGenericReturnType())) : "two parameter/option methods have different types " + m.getName();
        }
        return map;
    }

    static class O {
        String name;
        List<String> aliases = new ArrayList<String>();
        Type type;
        Method noargs;
        Method withDefault;
        boolean hasParameter;

        public O(Method m) {
            this.name = m.getName();
        }

        public String toString() {
            return this.aliases.stream().collect(Collectors.joining()) + (this.hasParameter ? this.type : "");
        }
    }
}

