/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command.completers;

import java.util.List;
import org.apache.karaf.config.core.impl.MetaServiceCaller;
import org.apache.karaf.shell.api.action.lifecycle.Init;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MetaCompleter
implements Completer,
BundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(MetaCompleter.class);
    private final StringsCompleter delegate = new StringsCompleter();
    @Reference
    BundleContext context;

    @Init
    public void init() {
        try {
            this.updateMeta();
            this.context.registerService(BundleListener.class, (Object)this, null);
        }
        catch (Throwable e) {
            Throwable ncdfe;
            for (ncdfe = e; ncdfe != null && !(ncdfe instanceof NoClassDefFoundError); ncdfe = ncdfe.getCause()) {
            }
            if (ncdfe != null && ncdfe.getMessage().equals("org/osgi/service/metatype/MetaTypeService")) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("config:meta disabled because the org.osgi.service.metatype package is not wired", e);
                } else {
                    LOG.warn("config:meta disabled because the org.osgi.service.metatype package is not wired (enable debug logging for full stack trace).");
                }
            }
            throw e;
        }
    }

    public synchronized int complete(Session session, CommandLine commandLine, List<String> candidates) {
        return this.delegate.complete(session, commandLine, candidates);
    }

    public void bundleChanged(BundleEvent event) {
        this.updateMeta();
    }

    private synchronized void updateMeta() {
        List<String> pids = MetaServiceCaller.getPidsWithMetaInfo(this.context);
        if (pids != null) {
            this.delegate.getStrings().clear();
            this.delegate.getStrings().addAll(pids);
        }
    }
}

