/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.security.SignatureException;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    private List<NamedFactory<Signature>> factories;

    public UserAuthPublicKey() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthPublicKey(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        boolean authed;
        ValidateUtils.checkTrue(init, "Instance not initialized");
        ServerSession session = this.getServerSession();
        String username = this.getUsername();
        boolean hasSig = buffer.getBoolean();
        String alg = buffer.getString();
        int oldLim = buffer.wpos();
        int oldPos = buffer.rpos();
        int len = buffer.getInt();
        int remaining = buffer.available();
        if (len < 0 || len > remaining) {
            this.log.error("doAuth({}@{}) illogical algorithm={} signature length ({}) when remaining={}", new Object[]{username, session, alg, len, remaining});
            throw new IndexOutOfBoundsException("Illogical signature length (" + len + ") for algorithm=" + alg);
        }
        buffer.wpos(buffer.rpos() + len);
        PublicKey key = buffer.getRawPublicKey();
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, session), "No signature factories for session=%s", session);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) verify key type={}, factories={}, fingerprint={}", new Object[]{username, session, alg, NamedResource.getNames(factories), KeyUtils.getFingerPrint(key)});
        }
        Signature verifier = ValidateUtils.checkNotNull(NamedFactory.create(factories, alg), "No verifier located for algorithm=%s", (Object)alg);
        verifier.initVerifier(session, key);
        buffer.wpos(oldLim);
        byte[] sig = hasSig ? buffer.getBytes() : null;
        PublickeyAuthenticator authenticator = session.getPublickeyAuthenticator();
        if (authenticator == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - no authenticator", new Object[]{username, session, alg, KeyUtils.getFingerPrint(key)});
            }
            return Boolean.FALSE;
        }
        try {
            authed = authenticator.authenticate(username, key, session);
        }
        catch (Error e) {
            this.log.warn("doAuth({}@{}) failed ({}) to consult delegate for {} key={}: {}", new Object[]{username, session, e.getClass().getSimpleName(), alg, KeyUtils.getFingerPrint(key), e.getMessage()});
            if (debugEnabled) {
                this.log.debug("doAuth(" + username + "@" + session + ") delegate failure details", (Throwable)e);
            }
            throw new RuntimeSshException(e);
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - authentication result: {}", new Object[]{username, session, alg, KeyUtils.getFingerPrint(key), authed});
        }
        if (!authed) {
            return Boolean.FALSE;
        }
        if (!hasSig) {
            this.sendPublicKeyResponse(session, username, alg, key, buffer.array(), oldPos, 4 + len, buffer);
            return null;
        }
        buffer.rpos(oldPos);
        buffer.wpos(oldPos + 4 + len);
        if (!this.verifySignature(session, username, alg, key, buffer, verifier, sig)) {
            throw new SignatureException("Key verification failed");
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - verified", new Object[]{username, session, alg, KeyUtils.getFingerPrint(key)});
        }
        return Boolean.TRUE;
    }

    protected boolean verifySignature(ServerSession session, String username, String alg, PublicKey key, Buffer buffer, Signature verifier, byte[] sig) throws Exception {
        byte[] id = session.getSessionId();
        String service = this.getService();
        String name = this.getName();
        ByteArrayBuffer buf = new ByteArrayBuffer(id.length + username.length() + service.length() + name.length() + alg.length() + 256 + 64, false);
        buf.putBytes(id);
        ((Buffer)buf).putByte((byte)50);
        buf.putString(username);
        buf.putString(service);
        buf.putString(name);
        buf.putBoolean(true);
        buf.putString(alg);
        buf.putBuffer(buffer);
        if (this.log.isTraceEnabled()) {
            this.log.trace("verifySignature({}@{})[{}][{}] key type={}, fingerprint={} - verification data={}", new Object[]{username, session, service, name, alg, KeyUtils.getFingerPrint(key), buf.toHex()});
            this.log.trace("verifySignature({}@{})[{}][{}] key type={}, fingerprint={} - expected signature={}", new Object[]{username, session, service, name, alg, KeyUtils.getFingerPrint(key), BufferUtils.toHex(sig)});
        }
        verifier.update(session, ((Buffer)buf).array(), ((Buffer)buf).rpos(), buf.available());
        return verifier.verify(session, sig);
    }

    protected void sendPublicKeyResponse(ServerSession session, String username, String alg, PublicKey key, byte[] keyBlob, int offset, int blobLen, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doAuth({}@{}) send SSH_MSG_USERAUTH_PK_OK for key type={}, fingerprint={}", new Object[]{username, session, alg, KeyUtils.getFingerPrint(key)});
        }
        Buffer buf = session.createBuffer((byte)60, GenericUtils.length(alg) + blobLen + 32);
        buf.putString(alg);
        buf.putRawBytes(keyBlob, offset, blobLen);
        session.writePacket(buf);
    }
}

