/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.security.AccessController;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.StandardLevel;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.spi.support.FormattingTriple;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerConsumer;

public class PaxLoggerImpl
implements PaxLogger {
    static String FQCN = PaxLoggerImpl.class.getName();
    static Level AUDIT = Level.forName((String)"AUDIT", (int)50);
    private ExtendedLogger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private PaxLoggingServiceImpl m_service;
    private boolean m_printfFormatting;

    PaxLoggerImpl(Bundle bundle, ExtendedLogger delegate, String fqcn, PaxLoggingServiceImpl service, boolean printfFormatting) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
        this.m_printfFormatting = printfFormatting;
    }

    public void setDelegate(ExtendedLogger m_delegate) {
        this.m_delegate = m_delegate;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isFatalEnabled();
    }

    public boolean isTraceEnabled(PaxMarker marker) {
        return this.m_delegate.isTraceEnabled(marker.log4j2Marker());
    }

    public boolean isDebugEnabled(PaxMarker marker) {
        return this.m_delegate.isDebugEnabled(marker.log4j2Marker());
    }

    public boolean isInfoEnabled(PaxMarker marker) {
        return this.m_delegate.isInfoEnabled(marker.log4j2Marker());
    }

    public boolean isWarnEnabled(PaxMarker marker) {
        return this.m_delegate.isWarnEnabled(marker.log4j2Marker());
    }

    public boolean isErrorEnabled(PaxMarker marker) {
        return this.m_delegate.isErrorEnabled(marker.log4j2Marker());
    }

    public boolean isFatalEnabled(PaxMarker marker) {
        return this.m_delegate.isFatalEnabled(marker.log4j2Marker());
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.doLog(null, Level.TRACE, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        if (this.isTraceEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void trace(PaxMarker marker, String message) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.TRACE, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void trace(PaxMarker marker, String format, Object arg) {
        if (this.isTraceEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.log4j2Marker(), Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.log4j2Marker(), Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void trace(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void trace(PaxMarker marker, String format, Object ... arguments) {
        if (this.isTraceEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.log4j2Marker(), Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.log4j2Marker(), Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void trace(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isTraceEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.doLog(null, Level.DEBUG, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        if (this.isDebugEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void debug(PaxMarker marker, String message) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.DEBUG, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void debug(PaxMarker marker, String format, Object arg) {
        if (this.isDebugEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.log4j2Marker(), Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.log4j2Marker(), Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void debug(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void debug(PaxMarker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.log4j2Marker(), Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.log4j2Marker(), Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void debug(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isDebugEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.doLog(null, Level.INFO, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        if (this.isInfoEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void info(PaxMarker marker, String message) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.INFO, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void info(PaxMarker marker, String format, Object arg) {
        if (this.isInfoEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.log4j2Marker(), Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.log4j2Marker(), Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void info(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void info(PaxMarker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.log4j2Marker(), Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.log4j2Marker(), Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void info(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isInfoEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.doLog(null, Level.WARN, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        if (this.isWarnEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void warn(PaxMarker marker, String message) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.WARN, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void warn(PaxMarker marker, String format, Object arg) {
        if (this.isWarnEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.log4j2Marker(), Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.log4j2Marker(), Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void warn(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void warn(PaxMarker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.log4j2Marker(), Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.log4j2Marker(), Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void warn(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isWarnEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.doLog(null, Level.ERROR, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        if (this.isErrorEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void error(PaxMarker marker, String message) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.ERROR, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void error(PaxMarker marker, String format, Object arg) {
        if (this.isErrorEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.log4j2Marker(), Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.log4j2Marker(), Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void error(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void error(PaxMarker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.log4j2Marker(), Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.log4j2Marker(), Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void error(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isErrorEnabled(marker)) {
            consumer.accept((Logger)this);
        }
    }

    public void fatal(String message) {
        if (this.isFatalEnabled()) {
            this.doLog(null, Level.FATAL, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void fatal(String format, Object arg) {
        if (this.isFatalEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(null, Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(null, Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void fatal(String format, Object arg1, Object arg2) {
        if (this.isFatalEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(null, Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(null, Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void fatal(String format, Object ... arguments) {
        if (this.isFatalEnabled()) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(null, Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(null, Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public <E extends Exception> void fatal(LoggerConsumer<E> consumer) throws E {
        if (this.isFatalEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void fatal(PaxMarker marker, String message) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.FATAL, this.m_fqcn, message, null, null, new Object[0]);
        }
    }

    public void fatal(PaxMarker marker, String format, Object arg) {
        if (this.isFatalEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
                this.doLog(marker.log4j2Marker(), Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg);
                this.doLog(marker.log4j2Marker(), Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void fatal(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.isFatalEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
                this.doLog(marker.log4j2Marker(), Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void fatal(PaxMarker marker, String format, Object ... arguments) {
        if (this.isFatalEnabled(marker)) {
            if (this.m_printfFormatting) {
                FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
                this.doLog(marker.log4j2Marker(), Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
            } else {
                FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
                this.doLog(marker.log4j2Marker(), Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
            }
        }
    }

    public void audit(String message) {
        this.doLog(null, AUDIT, this.m_fqcn, message, null, null, new Object[0]);
    }

    public void audit(String format, Object arg) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
            this.doLog(null, AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arg);
            this.doLog(null, AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public void audit(String format, Object arg1, Object arg2) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
            this.doLog(null, AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
            this.doLog(null, AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public void audit(String format, Object ... arguments) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
            this.doLog(null, AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
            this.doLog(null, AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public <E extends Exception> void audit(LoggerConsumer<E> consumer) throws E {
        consumer.accept((Logger)this);
    }

    public void audit(PaxMarker marker, String message) {
        this.doLog(marker.log4j2Marker(), AUDIT, this.m_fqcn, message, null, null, new Object[0]);
    }

    public void audit(PaxMarker marker, String format, Object arg) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arg);
            this.doLog(marker.log4j2Marker(), AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arg);
            this.doLog(marker.log4j2Marker(), AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public void audit(PaxMarker marker, String format, Object arg1, Object arg2) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arg1, arg2);
            this.doLog(marker.log4j2Marker(), AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arg1, arg2);
            this.doLog(marker.log4j2Marker(), AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public void audit(PaxMarker marker, String format, Object ... arguments) {
        if (this.m_printfFormatting) {
            FormattingTriple ft = FormattingTriple.resolve(format, true, arguments);
            this.doLog(marker.log4j2Marker(), AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), new Object[0]);
        } else {
            FormattingTriple ft = FormattingTriple.discover(format, false, arguments);
            this.doLog(marker.log4j2Marker(), AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference(), ft.getArgArray());
        }
    }

    public <E extends Exception> void audit(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept((Logger)this);
    }

    public <E extends Exception> void fatal(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        if (this.isFatalEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void fqtrace(String fqcn, String message) {
        if (this.isTraceEnabled()) {
            this.doLog(null, Level.TRACE, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqdebug(String fqcn, String message) {
        if (this.isDebugEnabled()) {
            this.doLog(null, Level.DEBUG, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqinfo(String fqcn, String message) {
        if (this.isInfoEnabled()) {
            this.doLog(null, Level.INFO, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqwarn(String fqcn, String message) {
        if (this.isWarnEnabled()) {
            this.doLog(null, Level.WARN, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqerror(String fqcn, String message) {
        if (this.isErrorEnabled()) {
            this.doLog(null, Level.ERROR, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqfatal(String fqcn, String message) {
        if (this.isFatalEnabled()) {
            this.doLog(null, Level.FATAL, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqtrace(String fqcn, PaxMarker marker, String message) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.TRACE, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqdebug(String fqcn, PaxMarker marker, String message) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.DEBUG, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqinfo(String fqcn, PaxMarker marker, String message) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.INFO, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqwarn(String fqcn, PaxMarker marker, String message) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.WARN, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqerror(String fqcn, PaxMarker marker, String message) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.ERROR, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqfatal(String fqcn, PaxMarker marker, String message) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.FATAL, fqcn, message, null, null, new Object[0]);
        }
    }

    public void fqtrace(String fqcn, String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.doLog(null, Level.TRACE, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqdebug(String fqcn, String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.doLog(null, Level.DEBUG, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqinfo(String fqcn, String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.doLog(null, Level.INFO, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqwarn(String fqcn, String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.doLog(null, Level.WARN, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqerror(String fqcn, String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.doLog(null, Level.ERROR, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqfatal(String fqcn, String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.doLog(null, Level.FATAL, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqtrace(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.TRACE, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqdebug(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.DEBUG, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqinfo(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.INFO, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqwarn(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.WARN, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqerror(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.ERROR, fqcn, message, t, null, new Object[0]);
        }
    }

    public void fqfatal(String fqcn, PaxMarker marker, String message, Throwable t) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.log4j2Marker(), Level.FATAL, fqcn, message, t, null, new Object[0]);
        }
    }

    public int getPaxLogLevel() {
        switch (this.m_delegate.getLevel().getStandardLevel()) {
            case TRACE: {
                return 0;
            }
            case DEBUG: {
                return 1;
            }
            case INFO: {
                return 2;
            }
            case WARN: {
                return 3;
            }
        }
        return 4;
    }

    public LogLevel getLogLevel() {
        return this.getLogLevel(this.m_delegate.getLevel().getStandardLevel());
    }

    private LogLevel getLogLevel(StandardLevel level) {
        switch (level) {
            case OFF: {
                return null;
            }
            case ALL: {
                return LogLevel.AUDIT;
            }
            case TRACE: {
                return LogLevel.TRACE;
            }
            case DEBUG: {
                return LogLevel.DEBUG;
            }
            case INFO: {
                return LogLevel.INFO;
            }
            case WARN: {
                return LogLevel.WARN;
            }
        }
        return LogLevel.ERROR;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }

    private void doLog(Marker marker, Level level, String fqcn, String message, Throwable t, ServiceReference<?> ref, Object ... args) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                this.doLog0(marker, level, fqcn, message, t, ref, args);
                return null;
            });
        } else {
            this.doLog0(marker, level, fqcn, message, t, ref, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog0(Marker marker, Level level, String fqcn, String message, Throwable t, ServiceReference<?> ref, Object ... args) {
        Message originalMessage = this.setDelegateContext();
        try {
            Message msg = originalMessage == null ? this.m_delegate.getMessageFactory().newMessage(message, args) : originalMessage;
            this.m_delegate.logMessage(fqcn, level, marker, msg, t);
        }
        finally {
            this.clearDelegateContext();
        }
        LogLevel l = level == AUDIT ? LogLevel.AUDIT : this.getLogLevel(level.getStandardLevel());
        this.m_service.handleEvents(this.getName(), this.m_bundle, ref, l, message, t);
    }

    private Message setDelegateContext() {
        Message originalMessage = null;
        Map context = this.getPaxContext().getContext();
        if (context != null) {
            originalMessage = (Message)context.remove(".log4j2_message");
            for (Map.Entry entry : context.entrySet()) {
                this.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.m_bundle != null) {
            this.put("bundle.id", this.m_bundle.getBundleId());
            this.put("bundle.name", this.m_bundle.getSymbolicName());
            this.put("bundle.version", this.m_bundle.getVersion().toString());
        }
        this.m_service.lock(false);
        return originalMessage;
    }

    private void put(String name, Object o) {
        if (o != null) {
            ThreadContext.put((String)name, (String)o.toString());
        }
    }

    private void clearDelegateContext() {
        this.m_service.unlock(false);
        ThreadContext.remove((String)"bundle.id");
        ThreadContext.remove((String)"bundle.name");
        ThreadContext.remove((String)"bundle.version");
    }
}

