/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.util.List;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.auth.keyboard.InteractiveChallenge;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class DefaultKeyboardInteractiveAuthenticator
extends AbstractLoggingBean
implements KeyboardInteractiveAuthenticator {
    public static final DefaultKeyboardInteractiveAuthenticator INSTANCE = new DefaultKeyboardInteractiveAuthenticator();

    @Override
    public InteractiveChallenge generateChallenge(ServerSession session, String username, String lang, String subMethods) throws Exception {
        PasswordAuthenticator auth = session.getPasswordAuthenticator();
        if (auth == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("generateChallenge({})[{}] no password authenticator", (Object)session, (Object)username);
            }
            return null;
        }
        InteractiveChallenge challenge = new InteractiveChallenge();
        challenge.setInteractionName(this.getInteractionName(session));
        challenge.setInteractionInstruction(this.getInteractionInstruction(session));
        challenge.setLanguageTag(this.getInteractionLanguage(session));
        challenge.addPrompt(this.getInteractionPrompt(session), this.isInteractionPromptEchoEnabled(session));
        return challenge;
    }

    @Override
    public boolean authenticate(ServerSession session, String username, List<String> responses) throws Exception {
        PasswordAuthenticator auth = session.getPasswordAuthenticator();
        if (auth == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no password authenticator", (Object)session, (Object)username);
            }
            return false;
        }
        int numResp = GenericUtils.size(responses);
        if (numResp != 1) {
            throw new SshException("Mismatched number of responses");
        }
        try {
            return auth.authenticate(username, responses.get(0), session);
        }
        catch (Error e) {
            this.warn("authenticate({})[{}] failed ({}) to consult password authenticator: {}", session, username, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
    }

    protected String getInteractionName(ServerSession session) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_NAME.getRequired(session);
    }

    protected String getInteractionInstruction(ServerSession session) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_INSTRUCTION.getRequired(session);
    }

    protected String getInteractionLanguage(ServerSession session) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_LANG.getRequired(session);
    }

    protected String getInteractionPrompt(ServerSession session) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_PROMPT.getRequired(session);
    }

    protected boolean isInteractionPromptEchoEnabled(ServerSession session) {
        return CoreModuleProperties.KB_SERVER_INTERACTIVE_ECHO_PROMPT.getRequired(session);
    }
}

