/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.memoize;

import aQute.bnd.memoize.MemoizingSupplier;
import aQute.bnd.memoize.PredicateMemoizingSupplier;
import aQute.bnd.memoize.ReferenceMemoizingSupplier;
import aQute.bnd.memoize.RefreshingMemoizingSupplier;
import java.lang.ref.Reference;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Memoize<S>
extends Supplier<S> {
    public static <T> Memoize<T> supplier(Supplier<? extends T> supplier) {
        if (supplier instanceof MemoizingSupplier) {
            Memoize memoized = (Memoize)supplier;
            return memoized;
        }
        return new MemoizingSupplier<T>(supplier);
    }

    public static <T, R> Memoize<R> supplier(Function<? super T, ? extends R> function, T argument) {
        Objects.requireNonNull(function);
        return Memoize.supplier(() -> function.apply((Object)argument));
    }

    public static <T> Memoize<T> refreshingSupplier(Supplier<? extends T> supplier, long time_to_live, TimeUnit unit) {
        return new RefreshingMemoizingSupplier<T>(supplier, time_to_live, unit);
    }

    public static <T> Memoize<T> referenceSupplier(Supplier<? extends T> supplier, Function<? super T, ? extends Reference<? extends T>> reference) {
        return new ReferenceMemoizingSupplier<T>(supplier, reference);
    }

    public static <T> Memoize<T> predicateSupplier(Supplier<? extends T> supplier, Predicate<? super T> predicate) {
        return new PredicateMemoizingSupplier<T>(supplier, predicate);
    }

    @Override
    public S get();

    public S peek();

    public boolean isPresent();

    default public <R> Memoize<R> map(Function<? super S, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return Memoize.supplier(() -> mapper.apply((S)this.get()));
    }

    default public <R> Memoize<R> flatMap(Function<? super S, ? extends Supplier<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return Memoize.supplier(() -> ((Supplier)mapper.apply((S)this.get())).get());
    }

    default public Memoize<S> filter(Predicate<? super S> predicate) {
        Objects.requireNonNull(predicate);
        return Memoize.supplier(() -> {
            S value = this.get();
            return predicate.test((S)value) ? value : null;
        });
    }

    default public Memoize<S> accept(Consumer<? super S> consumer) {
        Objects.requireNonNull(consumer);
        consumer.accept(this.get());
        return this;
    }

    default public Memoize<S> ifPresent(Consumer<? super S> consumer) {
        if (this.isPresent()) {
            return this.accept(consumer);
        }
        return this;
    }
}

