/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.util.GenericUtils;

public final class SshClientConfigFileReader {
    public static final String SETENV_PROP = "SetEnv";
    public static final String SENDENV_PROP = "SendEnv";
    public static final String REQUEST_TTY_OPTION = "RequestTTY";
    public static final String CLIENT_LIVECHECK_INTERVAL_PROP = "ClientAliveInterval";
    public static final long DEFAULT_ALIVE_INTERVAL = 0L;
    public static final String CLIENT_LIVECHECK_USE_NULLS = "ClientAliveUseNullPackets";
    public static final boolean DEFAULT_LIVECHECK_USE_NULLS = false;
    public static final String CLIENT_LIVECHECK_REPLIES_WAIT = "ClientAliveReplyWait";
    public static final long DEFAULT_LIVECHECK_REPLY_WAIT = 0L;

    private SshClientConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static <C extends SshClient> C setupClientHeartbeat(C client, PropertyResolver props) {
        if (client == null || props == null) {
            return client;
        }
        long interval = PropertyResolverUtils.getLongProperty(props, CLIENT_LIVECHECK_INTERVAL_PROP, 0L);
        if (interval <= 0L) {
            return client;
        }
        if (PropertyResolverUtils.getBooleanProperty(props, CLIENT_LIVECHECK_USE_NULLS, false)) {
            client.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, TimeUnit.SECONDS, interval);
        } else {
            PropertyResolverUtils.updateProperty(client, "heartbeat-interval", TimeUnit.SECONDS.toMillis(interval));
            interval = PropertyResolverUtils.getLongProperty(props, CLIENT_LIVECHECK_REPLIES_WAIT, 0L);
            if (interval > 0L) {
                PropertyResolverUtils.updateProperty(client, "heartbeat-reply-wait", TimeUnit.SECONDS.toMillis(interval));
            }
        }
        return client;
    }

    public static <C extends SshClient> C setupClientHeartbeat(C client, Map<String, ?> options) {
        if (client == null || GenericUtils.isEmpty(options)) {
            return client;
        }
        return SshClientConfigFileReader.setupClientHeartbeat(client, PropertyResolverUtils.toPropertyResolver(options));
    }

    public static <C extends SshClient> C configure(C client, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configure(client, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureKeyExchanges(client, props, lenient, ClientBuilder.DH2KEX, ignoreUnsupported);
        SshClientConfigFileReader.setupClientHeartbeat(client, props);
        return client;
    }
}

