/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.useradmin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.codec.AuthorizationData;
import org.apache.aries.jmx.codec.GroupData;
import org.apache.aries.jmx.codec.PropertyData;
import org.apache.aries.jmx.codec.RoleData;
import org.apache.aries.jmx.codec.UserData;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Authorization;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

public class UserAdmin
implements UserAdminMBean {
    private org.osgi.service.useradmin.UserAdmin userAdmin;

    public UserAdmin(org.osgi.service.useradmin.UserAdmin userAdmin) {
        this.userAdmin = userAdmin;
    }

    private void validateRoleType(Role role, int roleType) throws IOException {
        if (role.getType() != roleType) {
            throw new IOException("Unexpected role type. Expected " + roleType + " but got " + role.getType());
        }
    }

    public void addCredential(String key, byte[] value, String username) throws IOException {
        this.addCredential(key, (Object)value, username);
    }

    public void addCredentialString(String key, String value, String username) throws IOException {
        this.addCredential(key, value, username);
    }

    private void addCredential(String key, Object value, String username) throws IOException {
        if (username == null) {
            throw new IOException("User name cannot be null");
        }
        if (key == null) {
            throw new IOException("Credential key cannot be null");
        }
        Role role = this.userAdmin.getRole(username);
        if (role == null) {
            throw new IOException("Operation fails user with provided username = [" + username + "] doesn't exist");
        }
        this.validateRoleType(role, 1);
        Dictionary credentials = ((User)role).getCredentials();
        if (credentials != null) {
            credentials.put(key, value);
        }
    }

    public boolean addMember(String groupname, String rolename) throws IOException {
        if (groupname == null) {
            throw new IOException("Group name cannot be null");
        }
        if (rolename == null) {
            throw new IOException("Role name cannot be null");
        }
        Role group = this.userAdmin.getRole(groupname);
        Role member = this.userAdmin.getRole(rolename);
        if (group == null) {
            throw new IOException("Operation fails role with provided groupname = [" + groupname + "] doesn't exist");
        }
        this.validateRoleType(group, 2);
        return ((Group)group).addMember(member);
    }

    public void addPropertyString(String key, String value, String rolename) throws IOException {
        this.addRoleProperty(key, value, rolename);
    }

    public void addProperty(String key, byte[] value, String rolename) throws IOException {
        this.addRoleProperty(key, value, rolename);
    }

    private void addRoleProperty(String key, Object value, String rolename) throws IOException {
        if (rolename == null) {
            throw new IOException("Role name cannot be null");
        }
        if (key == null) {
            throw new IOException("Property key cannot be null");
        }
        Role role = this.userAdmin.getRole(rolename);
        if (role == null) {
            throw new IOException("Operation fails role with provided rolename = [" + rolename + "] doesn't exist");
        }
        Dictionary properties = role.getProperties();
        if (properties != null) {
            properties.put(key, value);
        }
    }

    public boolean addRequiredMember(String groupname, String rolename) throws IOException {
        if (groupname == null) {
            throw new IOException("Group name cannot be null");
        }
        if (rolename == null) {
            throw new IOException("Role name cannot be null");
        }
        Role group = this.userAdmin.getRole(groupname);
        Role member = this.userAdmin.getRole(rolename);
        if (group == null) {
            throw new IOException("Operation fails role with provided groupname = [" + groupname + "] doesn't exist");
        }
        this.validateRoleType(group, 2);
        return ((Group)group).addRequiredMember(member);
    }

    public void createGroup(String name) throws IOException {
        if (name == null) {
            throw new IOException("Group name cannot be null");
        }
        this.userAdmin.createRole(name, 2);
    }

    public void createRole(String name) throws IOException {
        throw new IOException("Deprecated: use createGroup or createUser");
    }

    public void createUser(String name) throws IOException {
        if (name == null) {
            throw new IOException("User name cannot be null");
        }
        this.userAdmin.createRole(name, 1);
    }

    public CompositeData getAuthorization(String username) throws IOException {
        if (username == null) {
            throw new IOException("User name cannot be null");
        }
        Role role = this.userAdmin.getRole(username);
        if (role == null) {
            return null;
        }
        this.validateRoleType(role, 1);
        Authorization auth = this.userAdmin.getAuthorization((User)role);
        if (auth == null) {
            return null;
        }
        return new AuthorizationData(auth).toCompositeData();
    }

    public TabularData getCredentials(String username) throws IOException {
        if (username == null) {
            throw new IOException("User name cannot be null");
        }
        Role role = this.userAdmin.getRole(username);
        if (role == null) {
            return null;
        }
        this.validateRoleType(role, 1);
        Dictionary credentials = ((User)role).getCredentials();
        if (credentials == null) {
            return null;
        }
        TabularDataSupport data = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        Enumeration keys = credentials.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            data.put(PropertyData.newInstance(key, credentials.get(key)).toCompositeData());
        }
        return data;
    }

    public CompositeData getGroup(String groupname) throws IOException {
        if (groupname == null) {
            throw new IOException("Group name cannot be null");
        }
        Role role = this.userAdmin.getRole(groupname);
        if (role == null) {
            return null;
        }
        this.validateRoleType(role, 2);
        return new GroupData((Group)role).toCompositeData();
    }

    public String[] getGroups(String filter) throws IOException {
        Role[] roles = null;
        try {
            roles = this.userAdmin.getRoles(filter);
        }
        catch (InvalidSyntaxException ise) {
            IOException ioex = new IOException("Operation fails illegal filter provided: " + filter);
            ioex.initCause(ise);
            throw ioex;
        }
        if (roles == null) {
            return null;
        }
        return this.getRoleByType(roles, 2);
    }

    public String[] getImpliedRoles(String username) throws IOException {
        if (username == null) {
            throw new IOException("User name cannot be null");
        }
        Role role = this.userAdmin.getRole(username);
        if (role != null) {
            this.validateRoleType(role, 1);
            Authorization auth = this.userAdmin.getAuthorization((User)role);
            if (auth != null) {
                return auth.getRoles();
            }
        }
        return null;
    }

    public String[] getMembers(String groupname) throws IOException {
        if (groupname == null) {
            throw new IOException("Group name cannot be null");
        }
        Role role = this.userAdmin.getRole(groupname);
        if (role != null) {
            this.validateRoleType(role, 2);
            Role[] roles = ((Group)role).getMembers();
            if (roles != null) {
                String[] members = new String[roles.length];
                for (int i = 0; i < roles.length; ++i) {
                    members[i] = roles[i].getName();
                }
                return members;
            }
        }
        return null;
    }

    public TabularData getProperties(String rolename) throws IOException {
        if (rolename == null) {
            throw new IOException("Role name cannot be null");
        }
        Role role = this.userAdmin.getRole(rolename);
        if (role == null) {
            return null;
        }
        Dictionary properties = role.getProperties();
        if (properties == null) {
            return null;
        }
        TabularDataSupport data = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            data.put(PropertyData.newInstance(key, properties.get(key)).toCompositeData());
        }
        return data;
    }

    public String[] getRequiredMembers(String groupname) throws IOException {
        if (groupname == null) {
            throw new IOException("Group name cannot be null");
        }
        Role role = this.userAdmin.getRole(groupname);
        if (role != null) {
            this.validateRoleType(role, 2);
            Role[] roles = ((Group)role).getRequiredMembers();
            if (roles != null) {
                String[] reqMembers = new String[roles.length];
                for (int i = 0; i < roles.length; ++i) {
                    reqMembers[i] = roles[i].getName();
                }
                return reqMembers;
            }
        }
        return null;
    }

    public CompositeData getRole(String name) throws IOException {
        if (name == null) {
            throw new IOException("Role name cannot be null");
        }
        Role role = this.userAdmin.getRole(name);
        if (role == null) {
            return null;
        }
        return new RoleData(role).toCompositeData();
    }

    public String[] getRoles(String filter) throws IOException {
        Role[] roles = null;
        try {
            roles = this.userAdmin.getRoles(filter);
        }
        catch (InvalidSyntaxException ise) {
            IOException ioex = new IOException("Operation fails illegal filter provided: " + filter);
            ioex.initCause(ise);
            throw ioex;
        }
        if (roles == null) {
            return null;
        }
        return this.getRoleByType(roles, 0);
    }

    public CompositeData getUser(String username) throws IOException {
        if (username == null) {
            throw new IOException("User name cannot be null");
        }
        Role role = this.userAdmin.getRole(username);
        if (role == null) {
            return null;
        }
        this.validateRoleType(role, 1);
        return new UserData((User)role).toCompositeData();
    }

    public String getUserWithProperty(String key, String value) throws IOException {
        if (key == null) {
            throw new IOException("Property key cannot be null");
        }
        User user = this.userAdmin.getUser(key, value);
        if (user == null) {
            return null;
        }
        return user.getName();
    }

    public String[] getUsers(String filter) throws IOException {
        Role[] roles = null;
        try {
            roles = this.userAdmin.getRoles(filter);
        }
        catch (InvalidSyntaxException ise) {
            IOException ioex = new IOException("Operation fails illegal filter provided: " + filter);
            ioex.initCause(ise);
            throw ioex;
        }
        if (roles == null) {
            return null;
        }
        return this.getRoleByType(roles, 1);
    }

    public String[] listGroups() throws IOException {
        Role[] roles = null;
        try {
            roles = this.userAdmin.getRoles(null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (roles == null) {
            return null;
        }
        return this.getRoleByType(roles, 2);
    }

    public String[] listRoles() throws IOException {
        Role[] roles = null;
        try {
            roles = this.userAdmin.getRoles(null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (roles == null) {
            return null;
        }
        return this.getRoleByType(roles, 0);
    }

    public String[] listUsers() throws IOException {
        Role[] roles = null;
        try {
            roles = this.userAdmin.getRoles(null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (roles == null) {
            return null;
        }
        return this.getRoleByType(roles, 1);
    }

    private String[] getRoleByType(Role[] roles, int roleType) {
        ArrayList<String> rs = new ArrayList<String>();
        for (Role role : roles) {
            if (roleType == 0) {
                rs.add(role.getName());
                continue;
            }
            if (role.getType() != roleType) continue;
            rs.add(role.getName());
        }
        return rs.toArray(new String[rs.size()]);
    }

    public void removeCredential(String key, String username) throws IOException {
        if (username == null) {
            throw new IOException("User name cannot be null");
        }
        if (key == null) {
            throw new IOException("Credential key cannot be null");
        }
        Role role = this.userAdmin.getRole(username);
        if (role == null) {
            throw new IOException("Operation fails can't find user with username = [" + username + "] doesn't exist");
        }
        this.validateRoleType(role, 1);
        ((User)role).getCredentials().remove(key);
    }

    public boolean removeGroup(String name) throws IOException {
        if (name == null) {
            throw new IOException("Group name cannot be null");
        }
        return this.userAdmin.removeRole(name);
    }

    public boolean removeMember(String groupname, String rolename) throws IOException {
        if (groupname == null) {
            throw new IOException("Group name cannot be null");
        }
        if (rolename == null) {
            throw new IOException("Role name cannot be null");
        }
        Role group = this.userAdmin.getRole(groupname);
        Role member = this.userAdmin.getRole(rolename);
        if (group == null) {
            throw new IOException("Operation fails role with provided groupname = [" + groupname + "] doesn't exist");
        }
        this.validateRoleType(group, 2);
        return ((Group)group).removeMember(member);
    }

    public void removeProperty(String key, String rolename) throws IOException {
        if (rolename == null) {
            throw new IOException("Role name cannot be null");
        }
        Role role = this.userAdmin.getRole(rolename);
        if (role == null) {
            throw new IOException("Operation fails role with provided rolename = [" + rolename + "] doesn't exist");
        }
        role.getProperties().remove(key);
    }

    public boolean removeRole(String name) throws IOException {
        if (name == null) {
            throw new IOException("Role name cannot be null");
        }
        return this.userAdmin.removeRole(name);
    }

    public boolean removeUser(String name) throws IOException {
        if (name == null) {
            throw new IOException("User name cannot be null");
        }
        return this.userAdmin.removeRole(name);
    }
}

