/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.help.Syntax;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.About;
import aQute.bnd.osgi.ActivelyClosingClassLoader;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.OSInformation;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryDonePlugin;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.url.URLConnectionHandler;
import aQute.bnd.stream.MapStream;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.collections.Iterables;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.unmodifiable.Lists;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.command.Command;
import aQute.libg.cryptography.Digester;
import aQute.libg.cryptography.SHA1;
import aQute.libg.generics.Create;
import aQute.libg.qtokens.QuotedTokenizer;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.osgi.util.promise.PromiseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Processor
extends Domain
implements Reporter,
Registry,
Constants,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Processor.class);
    public static Reporter log;
    static final int BUFFER_SIZE = 4096;
    static final ThreadLocal<Processor> current;
    private static final ScheduledThreadPoolExecutor scheduledExecutor;
    private static final ThreadPoolExecutor executor;
    private static final PromiseFactory promiseFactory;
    static Random random;
    public static final String LIST_SPLITTER = "\\s*,\\s*";
    final List<String> errors = new ArrayList<String>();
    final List<String> warnings = new ArrayList<String>();
    final Set<Object> basicPlugins = new HashSet<Object>();
    private final Set<Closeable> toBeClosed = new HashSet<Closeable>();
    private Set<Object> plugins;
    boolean pedantic;
    boolean trace;
    boolean exceptions;
    boolean fileMustExist = true;
    private File base = new File("").getAbsoluteFile();
    private URI baseURI = this.base.toURI();
    Properties properties;
    String profile;
    private Macro replacer;
    private long lastModified;
    private File propertiesFile;
    private boolean fixup = true;
    Processor parent;
    private final CopyOnWriteArrayList<File> included = new CopyOnWriteArrayList();
    CL pluginLoader;
    Collection<String> filter;
    HashSet<String> missingCommand;
    Boolean strict;
    boolean fixupMessages;
    private static final MethodType defaultConstructor;
    static final String _uriHelp = "${uri;<uri>[;<baseuri>]}, Resolve the uri against the baseuri. baseuri defaults to the processor base.";
    private static final Pattern DURATION_P;
    List<Report.Location> locations = new ArrayList<Report.Location>();
    Version upto = null;
    static final String _frangeHelp = "${frange;<version>[;true|false]}";

    public Processor() {
        this(new UTF8Properties(), false);
    }

    public Processor(Properties props) {
        this(props, true);
    }

    public Processor(Processor parent) {
        this(parent, parent.getProperties0(), true);
    }

    public Processor(Properties props, boolean wrap) {
        this.properties = wrap ? new UTF8Properties(props) : props;
    }

    public Processor(Processor parent, Properties props, boolean wrap) {
        this(props, wrap);
        this.parent = parent;
        this.updateModified(parent.lastModified(), "parent");
    }

    public void setParent(Processor parent) {
        this.parent = parent;
        UTF8Properties updated = new UTF8Properties(parent.getProperties0());
        updated.putAll((Map<?, ?>)this.getProperties0());
        this.properties = updated;
        this.propertiesChanged();
    }

    public Processor getParent() {
        return this.parent;
    }

    public Processor getTop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getTop();
    }

    public void getInfo(Reporter processor, String prefix) {
        if (prefix == null) {
            prefix = this.getBase() + " :";
        }
        if (this.isFailOk()) {
            this.addAll(this.warnings, processor.getErrors(), prefix, processor);
        } else {
            this.addAll(this.errors, processor.getErrors(), prefix, processor);
        }
        this.addAll(this.warnings, processor.getWarnings(), prefix, processor);
        processor.getErrors().clear();
        processor.getWarnings().clear();
    }

    public void getInfo(Reporter processor) {
        this.getInfo(processor, "");
    }

    private void addAll(List<String> to, List<String> from, String prefix, Reporter reporter) {
        try {
            for (String message : from) {
                String newMessage = prefix.isEmpty() ? message : prefix + message;
                to.add(newMessage);
                Report.Location location = reporter.getLocation(message);
                if (location == null) continue;
                Reporter.SetLocation newer = this.location(newMessage);
                for (Field f : newer.getClass().getFields()) {
                    if ("message".equals(f.getName())) continue;
                    f.set(newer, f.get(location));
                }
            }
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    private Processor current() {
        Processor p = current.get();
        if (p == null) {
            return this;
        }
        return p;
    }

    @Override
    public Reporter.SetLocation warning(String string, Object ... args) {
        this.fixupMessages = false;
        Processor p = this.current();
        String s = Processor.formatArrays(string, args);
        if (!p.warnings.contains(s)) {
            p.warnings.add(s);
        }
        p.signal();
        return p.location(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reporter.SetLocation error(String string, Object ... args) {
        this.fixupMessages = false;
        Processor p = this.current();
        try {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Throwable)) continue;
                args[i] = Exceptions.causes((Throwable)args[i]);
            }
            if (p.isFailOk()) {
                Reporter.SetLocation i = p.warning(string, args);
                return i;
            }
            String s = Processor.formatArrays(string, args);
            if (!p.errors.contains(s)) {
                p.errors.add(s);
            }
            Reporter.SetLocation setLocation = p.location(s);
            return setLocation;
        }
        finally {
            p.signal();
        }
    }

    @Override
    @Deprecated
    public void progress(float progress, String format, Object ... args) {
        Logger l = this.getLogger();
        if (l.isInfoEnabled()) {
            String message = Processor.formatArrays(format, args);
            if (progress > 0.0f) {
                l.info("[{}] {}", (Object)((int)progress), (Object)message);
            } else {
                l.info("{}", (Object)message);
            }
        }
    }

    public void progress(String format, Object ... args) {
        this.progress(-1.0f, format, args);
    }

    public Reporter.SetLocation error(String format, Throwable t, Object ... args) {
        return this.exception(t, format, args);
    }

    @Override
    public Reporter.SetLocation exception(Throwable t, String format, Object ... args) {
        Processor p = this.current();
        if (p.trace) {
            p.getLogger().info("Reported exception {}", (Object)Exceptions.causes(t), (Object)t);
        } else {
            p.getLogger().debug("Reported exception {}", (Object)Exceptions.causes(t), (Object)t);
        }
        if (p.exceptions) {
            this.printExceptionSummary(t, System.err);
        }
        t = Exceptions.unrollCause(t, InvocationTargetException.class);
        String s = Processor.formatArrays("Exception: %s", Exceptions.toString(t));
        if (p.isFailOk()) {
            p.warnings.add(s);
        } else {
            p.errors.add(s);
        }
        return this.error(format, args);
    }

    public int printExceptionSummary(Throwable e, PrintStream out) {
        if (e == null) {
            return 0;
        }
        int count = 10;
        int n = this.printExceptionSummary(e.getCause(), out);
        if (n == 0) {
            out.println("Root cause: " + e.getMessage() + "   :" + e.getClass().getName());
            count = Integer.MAX_VALUE;
        } else {
            out.println("Rethrown from: " + e.toString());
        }
        out.println();
        this.printStackTrace(e, count, out);
        System.err.println();
        return n + 1;
    }

    public void printStackTrace(Throwable e, int count, PrintStream out) {
        e.printStackTrace(out);
    }

    public void signal() {
    }

    @Override
    public List<String> getWarnings() {
        this.fixupMessages();
        return this.warnings;
    }

    @Override
    public List<String> getErrors() {
        this.fixupMessages();
        return this.errors;
    }

    public static Parameters parseHeader(String value, Processor logger) {
        return new Parameters(value, logger);
    }

    public Parameters parseHeader(String value) {
        return new Parameters(value, this);
    }

    public void addClose(Closeable jar) {
        assert (jar != null);
        this.toBeClosed.add(jar);
    }

    public void removeClose(Closeable jar) {
        assert (jar != null);
        this.toBeClosed.remove(jar);
    }

    @Override
    public boolean isPedantic() {
        Processor p = this.current();
        return p.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public void use(Processor reporter) {
        this.setPedantic(reporter.isPedantic());
        this.setTrace(reporter.isTrace());
        this.setExceptions(reporter.isExceptions());
        this.setFailOk(reporter.isFailOk());
    }

    public static File getFile(File base, String file) {
        return IO.getFile(base, file);
    }

    public File getFile(String file) {
        return Processor.getFile(this.base, file);
    }

    @Override
    public <T> List<T> getPlugins(Class<T> clazz) {
        List plugins = this.getPlugins().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
        return plugins;
    }

    @Override
    public <T> T getPlugin(Class<T> clazz) {
        Optional<Object> plugin = this.getPlugins().stream().filter(clazz::isInstance).map(clazz::cast).findFirst();
        return plugin.orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getPlugins() {
        Set<Object> p;
        Processor processor = this;
        synchronized (processor) {
            p = this.plugins;
            if (p != null) {
                return p;
            }
            this.plugins = p = new CopyOnWriteArraySet<Object>();
            this.missingCommand = new HashSet();
        }
        String spe = this.getProperty("-plugin");
        if ("none".equals(spe)) {
            return p;
        }
        p.add(this);
        this.setTypeSpecificPlugins(p);
        if (this.parent != null) {
            p.addAll(this.parent.getPlugins());
        }
        spe = this.mergeLocalProperties("-plugin");
        String pluginPath = this.mergeProperties("-pluginpath");
        this.loadPlugins(p, spe, pluginPath);
        this.addExtensions(p);
        for (RegistryDonePlugin rdp : this.getPlugins(RegistryDonePlugin.class)) {
            try {
                rdp.done();
            }
            catch (Exception e) {
                this.error("Calling done on %s, gives an exception %s", rdp, e);
            }
        }
        return p;
    }

    protected void addExtensions(Set<Object> p) {
    }

    protected void loadPlugins(Set<Object> instances, String pluginString, String pluginPathString) {
        Attrs attrs;
        String className;
        Parameters plugins = new Parameters(pluginString, this, true);
        CL loader = this.getLoader();
        for (Map.Entry<String, Attrs> entry : plugins.entrySet()) {
            String key = Processor.removeDuplicateMarker(entry.getKey());
            String path = entry.getValue().get("path:");
            if (path == null) continue;
            String[] parts = path.split(LIST_SPLITTER);
            try {
                for (String p : parts) {
                    File f = this.getFile(p).getAbsoluteFile();
                    loader.add(f);
                }
            }
            catch (Exception e) {
                this.error("Problem adding path %s to loader for plugin %s. Exception: (%s)", path, key, e);
            }
        }
        HashSet<String> loaded = new HashSet<String>();
        for (Map.Entry<String, Attrs> entry : plugins.entrySet()) {
            className = Processor.removeDuplicateMarker(entry.getKey());
            attrs = entry.getValue();
            logger.debug("Trying pre-plugin {}", (Object)className);
            Object plugin = this.loadPlugin(this.getClass().getClassLoader(), attrs, className, true);
            if (plugin == null) continue;
            loaded.add(entry.getKey());
            instances.add(plugin);
        }
        plugins.keySet().removeAll(loaded);
        this.loadPluginPath(instances, pluginPathString, loader);
        for (Map.Entry<String, Attrs> entry : plugins.entrySet()) {
            className = Processor.removeDuplicateMarker(entry.getKey());
            attrs = entry.getValue();
            logger.debug("Loading secondary plugin {}", (Object)className);
            String commands = attrs.get("command:");
            Object plugin = this.loadPlugin(loader, attrs, className, commands != null);
            if (plugin != null) {
                instances.add(plugin);
                continue;
            }
            if (commands == null) {
                this.error("Cannot load the plugin %s", className);
                continue;
            }
            Collection<String> cs = Processor.split(commands);
            this.missingCommand.addAll(cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginPath(Set<Object> instances, String pluginPath, CL loader) {
        Parameters pluginpath = new Parameters(pluginPath, this);
        HttpClient client = null;
        try {
            for (Map.Entry<String, Attrs> entry : pluginpath.entrySet()) {
                File f;
                block39: {
                    f = this.getFile(entry.getKey()).getAbsoluteFile();
                    if (!f.isFile()) {
                        String url = entry.getValue().get("url");
                        if (url != null) {
                            try {
                                logger.debug("downloading {} to {}", (Object)url, (Object)f.getAbsoluteFile());
                                URL u = new URL(url);
                                if (client == null) {
                                    HttpClient c = new HttpClient();
                                    c.setRegistry(this);
                                    c.readSettings(this);
                                    instances.stream().filter(URLConnectionHandler.class::isInstance).map(URLConnectionHandler.class::cast).forEach(c::addURLConnectionHandler);
                                    client = c;
                                }
                                IO.mkdirs(f.getParentFile());
                                try (Resource resource = Resource.fromURL(u, client);){
                                    try (OutputStream out = IO.outputStream(f);){
                                        resource.write(out);
                                    }
                                    long lastModified = resource.lastModified();
                                    if (lastModified > 0L) {
                                        f.setLastModified(lastModified);
                                    }
                                }
                                String digest = entry.getValue().get("sha1");
                                if (digest == null) break block39;
                                if (Hex.isHex(digest.trim())) {
                                    byte[] filesha1;
                                    byte[] sha1 = Hex.toByteArray(digest);
                                    if (!Arrays.equals(sha1, filesha1 = SHA1.digest(f).digest())) {
                                        this.error("Plugin path: %s, specified url %s and a sha1 but the file does not match the sha", entry.getKey(), url);
                                    }
                                } else {
                                    this.error("Plugin path: %s, specified url %s and a sha1 '%s' but this is not a hexadecimal", entry.getKey(), url, digest);
                                }
                                break block39;
                            }
                            catch (Exception e) {
                                this.exception(e, "Failed to download plugin %s from %s, error %s", entry.getKey(), url, e);
                                continue;
                            }
                        }
                        this.error("No such file %s from %s and no 'url' attribute on the path so it can be downloaded", entry.getKey(), this);
                        continue;
                    }
                }
                logger.debug("Adding {} to loader for plugins", (Object)f);
                loader.add(f);
            }
        }
        finally {
            IO.close(client);
        }
    }

    private Object loadPlugin(ClassLoader loader, Attrs attrs, String className, boolean ignoreError) {
        try {
            Class<?> c = loader.loadClass(className);
            Object plugin = MethodHandles.publicLookup().findConstructor(c, defaultConstructor).invoke();
            this.customize(plugin, attrs);
            if (plugin instanceof Closeable) {
                this.addClose((Closeable)plugin);
            }
            return plugin;
        }
        catch (NoClassDefFoundError e) {
            if (!ignoreError) {
                this.exception(e, "Failed to load plugin %s;%s, error: %s ", className, attrs, e);
            }
        }
        catch (ClassNotFoundException e) {
            if (!ignoreError) {
                this.exception(e, "Failed to load plugin %s;%s, error: %s ", className, attrs, e);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            this.exception(e, "Unexpected error loading plugin %s-%s: %s", className, attrs, e);
        }
        return null;
    }

    protected void setTypeSpecificPlugins(Set<Object> list) {
        list.add(Processor.getExecutor());
        list.add(Processor.getPromiseFactory());
        list.add(random);
        list.addAll(this.basicPlugins);
    }

    protected <T> T customize(T plugin, Attrs map) {
        if (plugin instanceof Plugin) {
            ((Plugin)plugin).setReporter(this);
            try {
                if (map == null) {
                    map = Attrs.EMPTY_ATTRS;
                }
                ((Plugin)plugin).setProperties(map);
            }
            catch (Exception e) {
                this.error("While setting properties %s on plugin %s, %s", map, plugin, e);
            }
        }
        if (plugin instanceof RegistryPlugin) {
            ((RegistryPlugin)plugin).setRegistry(this);
        }
        return plugin;
    }

    @Override
    public boolean isFailOk() {
        String v = this.getProperty("-failok", null);
        return v != null && v.equalsIgnoreCase("true");
    }

    public File getBase() {
        return this.base;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBase(File base) {
        if (base == null) {
            this.base = null;
            this.baseURI = null;
        } else {
            this.base = base.getAbsoluteFile();
            this.baseURI = base.toURI();
        }
    }

    public void clear() {
        this.errors.clear();
        this.warnings.clear();
        this.locations.clear();
        this.fixupMessages = false;
    }

    public Logger getLogger() {
        return logger;
    }

    @Override
    public void trace(String msg, Object ... parms) {
        Processor p = this.current();
        if (p.trace) {
            String s = Processor.formatArrays(msg, parms);
            System.out.println(s);
        }
    }

    public <T> List<T> newList() {
        return new ArrayList();
    }

    public <T> Set<T> newSet() {
        return new TreeSet();
    }

    public static <K, V> Map<K, V> newMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new LinkedHashMap();
    }

    public <T> List<T> newList(Collection<T> t) {
        return new ArrayList<T>(t);
    }

    public <T> Set<T> newSet(Collection<T> t) {
        return new TreeSet<T>(t);
    }

    public <K, V> Map<K, V> newMap(Map<K, V> t) {
        return new LinkedHashMap<K, V>(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        for (Closeable c : this.toBeClosed) {
            IO.close(c);
        }
        Processor processor = this;
        synchronized (processor) {
            this.plugins = null;
        }
        if (this.pluginLoader != null) {
            IO.close(this.pluginLoader);
            this.pluginLoader = null;
        }
        this.toBeClosed.clear();
    }

    public String _basedir(String[] args) {
        if (this.base == null) {
            throw new IllegalArgumentException("No base dir set");
        }
        return IO.absolutePath(this.base);
    }

    public String _propertiesname(String[] args) {
        if (args.length > 1) {
            this.error("propertiesname does not take arguments", new Object[0]);
            return null;
        }
        File pf = this.getPropertiesFile();
        if (pf == null) {
            return "";
        }
        return pf.getName();
    }

    public String _propertiesdir(String[] args) {
        if (args.length > 1) {
            this.error("propertiesdir does not take arguments", new Object[0]);
            return null;
        }
        File pf = this.getPropertiesFile();
        if (pf == null) {
            return "";
        }
        return IO.absolutePath(pf.getParentFile());
    }

    public String _uri(String[] args) throws Exception {
        Macro.verifyCommand(args, _uriHelp, null, 2, 3);
        URI uri = new URI(args[1]);
        if (!uri.isAbsolute() || uri.getScheme().equals("file")) {
            URI base;
            if (args.length > 2) {
                base = new URI(args[2]);
            } else {
                base = this.getBaseURI();
                if (base == null) {
                    throw new IllegalArgumentException("No base dir set");
                }
            }
            uri = base.resolve(uri.getSchemeSpecificPart());
        }
        return uri.toString();
    }

    public String _fileuri(String[] args) throws Exception {
        return this.getReplacer()._fileuri(args);
    }

    public Properties getProperties() {
        if (this.fixup) {
            this.fixup = false;
            this.begin();
        }
        this.fixupMessages = false;
        return this.getProperties0();
    }

    private Properties getProperties0() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getUnexpandedProperty(String key) {
        if (this.filter != null && this.filter.contains(key)) {
            Object raw = this.getProperties().get(key);
            return raw instanceof String ? (String)raw : null;
        }
        return this.getProperties().getProperty(key);
    }

    public void mergeProperties(File file, boolean override) {
        if (file.isFile()) {
            try {
                Properties properties = this.loadProperties(file);
                this.mergeProperties(properties, override);
            }
            catch (Exception e) {
                this.error("Error loading properties file: %s", file);
            }
        } else if (!file.exists()) {
            this.error("Properties file does not exist: %s", file);
        } else {
            this.error("Properties file must a file, not a directory: %s", file);
        }
    }

    public void mergeProperties(Properties properties, boolean override) {
        for (String key : Iterables.iterable(properties.propertyNames(), String.class::cast)) {
            String value = properties.getProperty(key);
            if (!override && this.getProperties().containsKey(key)) continue;
            this.setProperty(key, value);
        }
    }

    public void setProperties(Properties properties) {
        this.doIncludes(this.getBase(), properties);
        this.getProperties0().putAll((Map<?, ?>)properties);
        this.mergeProperties("-init");
        this.getProperties0().remove("-init");
    }

    public void setProperties(File base, Properties properties) {
        this.doIncludes(base, properties);
        this.getProperties0().putAll((Map<?, ?>)properties);
    }

    public void addProperties(File file) throws Exception {
        this.addIncluded(file);
        Properties p = this.loadProperties(file);
        this.setProperties(p);
    }

    public void addProperties(Map<?, ?> properties) {
        MapStream.of(properties).forEachOrdered((k, v) -> this.setProperty(k.toString(), String.valueOf(v)));
    }

    public void addIncluded(File file) {
        this.addIncludedIfAbsent(file);
    }

    private boolean addIncludedIfAbsent(File file) {
        return this.included.addIfAbsent(file);
    }

    private boolean removeIncluded(File file) {
        return this.included.remove(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIncludes(File ubase, Properties p) {
        String includes = p.getProperty("-include");
        if (includes != null) {
            includes = this.getReplacer().process(includes);
            p.remove("-include");
            Set<String> clauses = new Parameters(includes, this).keySet();
            for (String value : clauses) {
                boolean fileMustExist = true;
                boolean overwrite = true;
                while (true) {
                    if (value.startsWith("-")) {
                        fileMustExist = false;
                        value = value.substring(1).trim();
                        continue;
                    }
                    if (!value.startsWith("~")) break;
                    overwrite = false;
                    value = value.substring(1).trim();
                }
                try {
                    File file = Processor.getFile(ubase, value).getAbsoluteFile();
                    if (!file.isFile()) {
                        try {
                            URL url = new URL(value);
                            int n = value.lastIndexOf(46);
                            String ext = ".jar";
                            if (n >= 0) {
                                ext = value.substring(n);
                            }
                            Path tmp = Files.createTempFile("url", ext, new FileAttribute[0]);
                            try {
                                Resource resource = Resource.fromURL(url, this.getPlugin(HttpClient.class));
                                Throwable throwable = null;
                                try {
                                    try (OutputStream out = IO.outputStream(tmp);){
                                        resource.write(out);
                                    }
                                    Files.setLastModifiedTime(tmp, FileTime.fromMillis(resource.lastModified()));
                                    this.doIncludeFile(tmp.toFile(), overwrite, p);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (resource == null) continue;
                                    if (throwable != null) {
                                        try {
                                            resource.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    resource.close();
                                }
                            }
                            finally {
                                this.removeIncluded(tmp.toFile());
                                IO.delete(tmp);
                            }
                        }
                        catch (MalformedURLException mue) {
                            if (!fileMustExist) continue;
                            this.error("Included file %s %s", file, file.isDirectory() ? "is directory" : "does not exist");
                        }
                        catch (Exception e) {
                            if (!fileMustExist) continue;
                            this.exception(e, "Error in processing included URL: %s", value);
                        }
                        continue;
                    }
                    this.doIncludeFile(file, overwrite, p);
                }
                catch (Exception e) {
                    if (!fileMustExist) continue;
                    this.exception(e, "Error in processing included file: %s", value);
                }
            }
        }
    }

    public void doIncludeFile(File file, boolean overwrite, Properties target) throws Exception {
        this.doIncludeFile(file, overwrite, target, null);
    }

    public void doIncludeFile(File file, boolean overwrite, Properties target, String extensionName) throws Exception {
        Properties sub;
        if (!this.addIncludedIfAbsent(file)) {
            this.error("Cyclic or multiple include of %s", file);
        }
        this.updateModified(file.lastModified(), file.toString());
        if (file.getName().toLowerCase().endsWith(".mf")) {
            try (InputStream in = IO.stream(file);){
                sub = Processor.getManifestAsProperties(in);
            }
        } else {
            sub = this.loadProperties(file);
        }
        this.doIncludes(file.getParentFile(), sub);
        for (Map.Entry<Object, Object> entry : sub.entrySet()) {
            String extensionKey;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (overwrite || !target.containsKey(key)) {
                target.setProperty(key, value);
                continue;
            }
            if (extensionName == null || target.containsKey(extensionKey = extensionName + "." + key)) continue;
            target.setProperty(extensionKey, value);
        }
    }

    public void unsetProperty(String string) {
        this.getProperties().remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh() {
        Processor processor = this;
        synchronized (processor) {
            this.plugins = null;
        }
        if (this.pluginLoader != null) {
            IO.close(this.pluginLoader);
            this.pluginLoader = null;
        }
        if (this.propertiesFile == null) {
            return false;
        }
        boolean changed = this.updateModified(this.propertiesFile.lastModified(), "properties file");
        for (File file : this.getIncluded()) {
            changed |= !file.exists() || this.updateModified(file.lastModified(), "include file: " + file);
        }
        this.profile = null;
        if (changed) {
            this.forceRefresh();
            return true;
        }
        return false;
    }

    boolean isStrict() {
        if (this.strict == null) {
            this.strict = Processor.isTrue(this.getProperty("-strict"));
        }
        return this.strict;
    }

    public void forceRefresh() {
        this.included.clear();
        Processor p = this.getParent();
        this.properties = p != null ? new UTF8Properties(p.getProperties0()) : new UTF8Properties();
        this.setProperties(this.propertiesFile, this.base);
        this.propertiesChanged();
    }

    public void propertiesChanged() {
        Processor p = this.getParent();
        if (p != null) {
            this.updateModified(p.lastModified(), "propertiesChanged");
        }
    }

    public void setProperties(File propertiesFile) {
        if (propertiesFile == null) {
            return;
        }
        propertiesFile = propertiesFile.getAbsoluteFile();
        this.setProperties(propertiesFile, propertiesFile.getParentFile());
    }

    public void setProperties(File propertiesFile, File base) {
        this.propertiesFile = propertiesFile.getAbsoluteFile();
        this.setBase(base);
        try {
            if (propertiesFile.isFile()) {
                this.included.clear();
                Properties p = this.loadProperties(propertiesFile);
                this.setProperties(p);
            } else if (this.fileMustExist) {
                this.error("No such properties file: %s", propertiesFile);
            }
        }
        catch (IOException e) {
            this.error("Could not load properties %s", propertiesFile);
        }
    }

    protected void begin() {
        if (Processor.isTrue(this.getProperty("-pedantic"))) {
            this.setPedantic(true);
        }
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        if ((value = value.trim()).isEmpty()) {
            return false;
        }
        if (value.startsWith("!")) {
            if (value.equals("!")) {
                return false;
            }
            return !Processor.isTrue(value.substring(1));
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("off".equalsIgnoreCase(value)) {
            return false;
        }
        return !"not".equalsIgnoreCase(value);
    }

    public String getUnprocessedProperty(String key, String deflt) {
        if (this.filter != null && this.filter.contains(key)) {
            Object raw = this.getProperties().get(key);
            return raw instanceof String ? (String)raw : deflt;
        }
        return this.getProperties().getProperty(key, deflt);
    }

    public String getProperty(String key, String deflt) {
        return this.getProperty(key, deflt, ",");
    }

    public String getProperty(String key, String deflt, String separator) {
        return this.getProperty(key, deflt, separator, true);
    }

    private String getProperty(String key, String deflt, String separator, boolean inherit) {
        Instruction ins = new Instruction(key);
        if (ins.isLiteral()) {
            return this.getLiteralProperty(ins.getLiteral(), deflt, this, inherit);
        }
        return this.getWildcardProperty(deflt, separator, inherit, ins);
    }

    private String getWildcardProperty(String deflt, String separator, boolean inherit, Instruction ins) {
        String result = this.stream(inherit).filter(ins::matches).sorted().map(k -> this.getLiteralProperty((String)k, null, this, inherit)).filter(v -> v != null && !v.isEmpty()).collect(Strings.joining(separator, "", "", deflt));
        return result;
    }

    private String getLiteralProperty(String key, String deflt, Processor source, boolean inherit) {
        String value = null;
        for (Processor proc = source; proc != null; proc = proc.getParent()) {
            Collection<String> keyFilter;
            Object raw = proc.getProperties().get(key);
            if (raw != null) {
                if (raw instanceof String) {
                    value = (String)raw;
                } else if (this.isPedantic()) {
                    this.warning("Key '%s' has a non-String value: %s:%s", key, raw.getClass().getName(), raw);
                }
                source = proc;
                break;
            }
            if (!inherit || (keyFilter = proc.filter) != null && keyFilter.contains(key)) break;
        }
        if (value == null) {
            value = this.getReplacer().getMacro(key, null);
        }
        if (value != null) {
            return this.getReplacer().process(value, source);
        }
        if (deflt != null) {
            return this.getReplacer().process(deflt, this);
        }
        return null;
    }

    public Properties loadProperties(File file) throws IOException {
        this.updateModified(file.lastModified(), "Properties file: " + file);
        UTF8Properties p = this.loadProperties0(file);
        return p;
    }

    UTF8Properties loadProperties0(File file) throws IOException {
        try {
            UTF8Properties p = new UTF8Properties();
            p.load(file, this, Constants.OSGI_SYNTAX_HEADERS);
            return p.replaceHere(file.getParentFile());
        }
        catch (Exception e) {
            this.error("Error during loading properties file: %s, error: %s", file, e);
            return new UTF8Properties();
        }
    }

    public static Properties replaceAll(Properties p, String pattern, String replacement) {
        Pattern regex = Pattern.compile(pattern);
        UTF8Properties result = MapStream.of(p).mapValue(value -> regex.matcher((String)value).replaceAll(replacement)).collect(MapStream.toMap((u, v) -> v, UTF8Properties::new));
        return result;
    }

    public static String printClauses(Map<?, ? extends Map<?, ?>> exports) throws IOException {
        return Processor.printClauses(exports, false);
    }

    public static String printClauses(Map<?, ? extends Map<?, ?>> exports, boolean checkMultipleVersions) throws IOException {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Map.Entry<?, Map<?, ?>> entry : exports.entrySet()) {
            String name = entry.getKey().toString();
            Map<?, ?> clause = entry.getValue();
            String outname = Processor.removeDuplicateMarker(name);
            sb.append(del);
            sb.append(outname);
            Processor.printClause(clause, sb);
            del = ",";
        }
        return sb.toString();
    }

    public static void printClause(Map<?, ?> map, StringBuilder sb) throws IOException {
        if (map instanceof Attrs) {
            Attrs attrs = (Attrs)map;
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                String key = entry.getKey();
                if (Processor.skipPrint(key)) continue;
                sb.append(";");
                attrs.append(sb, entry);
            }
        } else {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                if (Processor.skipPrint(key)) continue;
                sb.append(";");
                sb.append(key);
                sb.append("=");
                String value = ((String)entry.getValue()).trim();
                Processor.quote(sb, value);
            }
        }
    }

    private static boolean skipPrint(String key) {
        switch (key) {
            case "-internal-exported:": 
            case "-internal-export-to-modules:": 
            case "-internal-open-to-modules:": 
            case "-internal-source:": 
            case "-noimport:": 
            case "provide:": 
            case "-split-package:": 
            case "from:": 
            case "-internal-bundlesymbolicname:": 
            case "-internal-bundleversion:": {
                return true;
            }
        }
        return false;
    }

    public static boolean quote(Appendable sb, String value) throws IOException {
        return OSGiHeader.quote(sb, value);
    }

    public Macro getReplacer() {
        if (this.replacer == null) {
            this.replacer = new Macro(this, this.getMacroDomains());
            return this.replacer;
        }
        return this.replacer;
    }

    protected Object[] getMacroDomains() {
        return new Object[0];
    }

    public Properties getFlattenedProperties() {
        return this.getReplacer().getFlattenedProperties();
    }

    public Properties getFlattenedProperties(boolean ignoreInstructions) {
        return this.getReplacer().getFlattenedProperties(ignoreInstructions);
    }

    public Set<String> getPropertyKeys(boolean inherit) {
        Set<Object> result;
        if (this.parent == null || !inherit) {
            result = new TreeSet();
        } else {
            result = this.parent.getPropertyKeys(inherit);
            if (this.filter != null) {
                result.removeAll(this.filter);
            }
        }
        for (Object o : this.getProperties0().keySet()) {
            result.add(o.toString());
        }
        return result;
    }

    public boolean updateModified(long time, String reason) {
        if (time > this.lastModified) {
            this.lastModified = time;
            return true;
        }
        return false;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setProperty(String key, String value) {
        this.getProperties().put(Processor.normalizeKey(key), value);
    }

    public static Properties getManifestAsProperties(InputStream in) throws IOException {
        UTF8Properties p = new UTF8Properties();
        Manifest manifest = new Manifest(in);
        for (Attributes.Name name : manifest.getMainAttributes().keySet()) {
            String value = manifest.getMainAttributes().getValue(name);
            p.put(name.toString(), value);
        }
        return p;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setFileMustExist(boolean mustexist) {
        this.fileMustExist = mustexist;
    }

    public static String read(InputStream in) throws Exception {
        return IO.collect(in, StandardCharsets.UTF_8);
    }

    public static String join(Collection<?> list) {
        return Processor.join(list, ",");
    }

    public static String join(Collection<?> list, String delimeter) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Object item : list) {
            sb.append(del);
            sb.append(item);
            del = delimeter;
        }
        return sb.toString();
    }

    public static String join(Collection<?> ... lists) {
        return Processor.join(",", lists);
    }

    public static String join(String delimeter, Collection<?> ... lists) {
        if (lists == null || lists.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Collection<?> list : lists) {
            for (Object item : list) {
                sb.append(del);
                sb.append(item);
                del = delimeter;
            }
        }
        return sb.toString();
    }

    public static String join(Object[] list, String delimeter) {
        if (list == null || list.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Object item : list) {
            sb.append(del);
            sb.append(item);
            del = delimeter;
        }
        return sb.toString();
    }

    public static <T> String join(T[] list) {
        return Processor.join(list, ",");
    }

    public static void split(String s, Collection<String> collection) {
        Strings.splitAsStream(s).forEachOrdered(collection::add);
    }

    public static Collection<String> split(String s) {
        return Strings.split(s);
    }

    public static Collection<String> split(String s, String splitter) {
        return Strings.split(splitter, s);
    }

    public static String merge(String ... strings) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : strings) {
            if (s == null) continue;
            Processor.split(s, result);
        }
        return Processor.join(result);
    }

    public boolean isExceptions() {
        return this.exceptions;
    }

    public void setExceptions(boolean exceptions) {
        this.exceptions = exceptions;
    }

    public String normalize(String file) {
        file = IO.normalizePath(file);
        String path = IO.absolutePath(this.base);
        int len = path.length();
        if (file.startsWith(path) && file.charAt(len) == '/') {
            return file.substring(len + 1);
        }
        return file;
    }

    public String normalize(File file) {
        return this.normalize(file.getAbsolutePath());
    }

    public static String removeDuplicateMarker(String key) {
        int i;
        for (i = key.length() - 1; i >= 0 && key.charAt(i) == '~'; --i) {
        }
        return key.substring(0, i + 1);
    }

    public static boolean isDuplicate(String key) {
        return key.indexOf(126, key.length() - 1) >= 0;
    }

    public void setTrace(boolean x) {
        this.trace = x;
    }

    protected CL getLoader() {
        if (this.pluginLoader == null) {
            this.pluginLoader = new CL(this);
            this.addClose(this.pluginLoader);
            if (IO.isWindows() && this.isInteractive()) {
                this.pluginLoader.autopurge(5000L);
            }
        }
        return this.pluginLoader;
    }

    public boolean exists() {
        return this.base != null && this.base.isDirectory() && this.propertiesFile != null && this.propertiesFile.isFile();
    }

    @Override
    public boolean isOk() {
        return this.isFailOk() || this.getErrors().isEmpty();
    }

    private void fixupMessages() {
        if (this.fixupMessages) {
            return;
        }
        this.fixupMessages = true;
        Parameters fixup = this.getMergedParameters("-fixupmessages");
        if (fixup.isEmpty()) {
            return;
        }
        Instructions instrs = new Instructions();
        fixup.forEach((? super K k, ? super V v) -> instrs.put(Instruction.legacy(k), (Attrs)v));
        this.doFixup(instrs, this.errors, this.warnings, "error");
        this.doFixup(instrs, this.warnings, this.errors, "warning");
    }

    private void doFixup(Instructions instrs, List<String> messages, List<String> other, String type) {
        for (int i = 0; i < messages.size(); ++i) {
            Attrs attrs;
            String restrict;
            String message = messages.get(i);
            Instruction matcher = instrs.finder(message);
            if (matcher == null || matcher.isNegated() || (restrict = (attrs = instrs.get(matcher)).get("restrict:")) != null && !restrict.equals(type)) continue;
            String replace = attrs.get("replace:");
            if (replace != null) {
                logger.debug("replacing {} with {}", (Object)message, (Object)replace);
                this.setProperty("@", message);
                message = this.getReplacer().process(replace);
                messages.set(i, message);
                this.unsetProperty("@");
            }
            String is = attrs.get("is:");
            if (attrs.isEmpty() || "ignore".equals(is)) {
                messages.remove(i--);
                continue;
            }
            if (is == null || type.equals(is)) continue;
            messages.remove(i--);
            other.add(message);
        }
    }

    public boolean check(String ... pattern) throws IOException {
        Set missed = Create.set();
        if (pattern != null) {
            for (String p : pattern) {
                boolean match = false;
                Pattern pat = Pattern.compile(p);
                Iterator<String> i = this.errors.iterator();
                while (i.hasNext()) {
                    if (!pat.matcher(i.next()).find()) continue;
                    i.remove();
                    match = true;
                }
                i = this.warnings.iterator();
                while (i.hasNext()) {
                    if (!pat.matcher(i.next()).find()) continue;
                    i.remove();
                    match = true;
                }
                if (match) continue;
                missed.add(p);
            }
        }
        if (missed.isEmpty() && this.isPerfect()) {
            return true;
        }
        if (!missed.isEmpty()) {
            System.err.println("Missed the following patterns in the warnings or errors: " + missed);
        }
        this.report(System.err);
        return false;
    }

    protected void report(Appendable out) throws IOException {
        int i;
        if (this.errors.size() > 0) {
            out.append(String.format("-----------------%nErrors%n", new Object[0]));
            for (i = 0; i < this.errors.size(); ++i) {
                out.append(String.format("%03d: %s%n", i, this.errors.get(i)));
            }
        }
        if (this.warnings.size() > 0) {
            out.append(String.format("-----------------%nWarnings%n", new Object[0]));
            for (i = 0; i < this.warnings.size(); ++i) {
                out.append(String.format("%03d: %s%n", i, this.warnings.get(i)));
            }
        }
    }

    public boolean isPerfect() {
        return this.getErrors().isEmpty() && this.getWarnings().isEmpty();
    }

    public void setForceLocal(Collection<String> local) {
        this.filter = local;
    }

    public boolean isMissingPlugin(String name) {
        this.getPlugins();
        return this.missingCommand != null && this.missingCommand.contains(name);
    }

    public static String appendPath(String ... parts) {
        int sblen;
        StringBuilder sb = new StringBuilder(parts.length * 16);
        boolean lastSlash = true;
        for (String part : parts) {
            int partlen = part.length();
            if (partlen == 0) continue;
            if (!lastSlash) {
                sb.append('/');
                lastSlash = true;
            }
            for (int i = 0; i < partlen; ++i) {
                char c = part.charAt(i);
                if (lastSlash) {
                    if (c == '/') continue;
                    sb.append(c);
                    lastSlash = false;
                    continue;
                }
                sb.append(c);
                if (c != '/') continue;
                lastSlash = true;
            }
        }
        if (lastSlash && (sblen = sb.length()) > 0) {
            sb.setLength(sblen - 1);
        }
        return sb.toString();
    }

    public static Attrs doAttrbutes(Object[] attrs, Clazz clazz, Macro macro) {
        Attrs map = new Attrs();
        if (attrs == null || attrs.length == 0) {
            return map;
        }
        for (Object a : attrs) {
            String attr = (String)a;
            int n = attr.indexOf(61);
            if (n <= 0) {
                throw new IllegalArgumentException(Processor.formatArrays("Invalid attribute on package-info.java in %s , %s. Must be <key>=<name> ", clazz, attr));
            }
            map.put(attr.substring(0, n), macro.process(attr.substring(n + 1)));
        }
        return map;
    }

    public static String formatArrays(String string, Object ... parms) {
        return Strings.format(string, parms);
    }

    public static Object makePrintable(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return Arrays.toString(Processor.makePrintableArray(object));
        }
        return object;
    }

    private static Object[] makePrintableArray(Object array) {
        int length = Array.getLength(array);
        Object[] output = new Object[length];
        for (int i = 0; i < length; ++i) {
            output[i] = Processor.makePrintable(Array.get(array, i));
        }
        return output;
    }

    public static String append(String ... strings) {
        List result = Create.list();
        for (String s : strings) {
            result.addAll(Processor.split(s));
        }
        return Processor.join(result);
    }

    public synchronized Class<?> getClass(String type, File jar) throws Exception {
        CL cl = this.getLoader();
        cl.add(jar);
        return cl.loadClass(type);
    }

    public boolean isTrace() {
        Processor p = this.current();
        return p.trace;
    }

    public static long getDuration(String tm, long dflt) {
        if (tm == null) {
            return dflt;
        }
        tm = tm.toUpperCase();
        TimeUnit unit = TimeUnit.MILLISECONDS;
        Matcher m = DURATION_P.matcher(tm);
        if (m.matches()) {
            long duration = Long.parseLong(tm);
            String u = m.group(2);
            if (u != null) {
                unit = TimeUnit.valueOf(u);
            }
            duration = TimeUnit.MILLISECONDS.convert(duration, unit);
            return duration;
        }
        return dflt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _random(String[] args) {
        int numchars = 8;
        if (args.length > 1) {
            try {
                numchars = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid character count parameter in ${random} macro.");
            }
        }
        Class<Processor> e = Processor.class;
        synchronized (Processor.class) {
            if (random == null) {
                random = new Random();
            }
            // ** MonitorExit[e] (shouldn't be in output)
            char[] letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
            char[] alphanums = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
            char[] array = new char[numchars];
            for (int i = 0; i < numchars; ++i) {
                char c = i == 0 ? letters[random.nextInt(letters.length)] : alphanums[random.nextInt(alphanums.length)];
                array[i] = c;
            }
            return new String(array);
        }
    }

    public String _native_capability(String ... args) throws Exception {
        return OSInformation.getNativeCapabilityClause(this, args);
    }

    protected Processor beginHandleErrors(String message) {
        logger.debug("begin {}", (Object)message);
        Processor previous = current.get();
        current.set(this);
        return previous;
    }

    protected void endHandleErrors(Processor previous) {
        logger.debug("end");
        current.set(previous);
    }

    public static Executor getExecutor() {
        return executor;
    }

    public static ScheduledExecutorService getScheduledExecutor() {
        return scheduledExecutor;
    }

    public static PromiseFactory getPromiseFactory() {
        return promiseFactory;
    }

    public synchronized void addBasicPlugin(Object plugin) {
        this.basicPlugins.add(plugin);
        Set<Object> p = this.plugins;
        if (p != null) {
            p.add(plugin);
        }
    }

    public synchronized void removeBasicPlugin(Object plugin) {
        this.basicPlugins.remove(plugin);
        Set<Object> p = this.plugins;
        if (p != null) {
            p.remove(plugin);
        }
    }

    public List<File> getIncluded() {
        return this.included;
    }

    @Override
    public String get(String key) {
        return this.getProperty(key);
    }

    @Override
    public String get(String key, String deflt) {
        return this.getProperty(key, deflt);
    }

    @Override
    public void set(String key, String value) {
        this.setProperty(key, value);
    }

    Stream<String> stream() {
        return this.stream(true);
    }

    private Stream<String> stream(boolean inherit) {
        return StreamSupport.stream(this.iterable(inherit, Objects::nonNull).spliterator(), false);
    }

    @Override
    public Iterator<String> iterator() {
        return this.iterable(true, Objects::nonNull).iterator();
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.iterable(true, Objects::nonNull).spliterator();
    }

    private Iterable<String> iterable(boolean inherit, Predicate<String> keyFilter) {
        Set<Object> first = this.getProperties0().keySet();
        Iterable<Object> second = this.parent == null || !inherit ? Collections.emptyList() : this.parent.iterable(inherit, this.filter == null ? keyFilter : keyFilter.and(key -> !this.filter.contains(key)));
        Iterable<String> iterable = Iterables.distinct(first, second, o -> o instanceof String ? (String)o : null, keyFilter);
        return iterable;
    }

    public Set<String> keySet() {
        return this.getPropertyKeys(true);
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            this.report(sb);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String replaceExtension(String s, String extension, String newExtension) {
        if (s.endsWith(extension)) {
            s = s.substring(0, s.length() - extension.length());
        }
        return s + newExtension;
    }

    public Reporter.SetLocation setLocation(String header, String clause, Reporter.SetLocation setLocation) {
        try {
            FileLine info = this.getHeader(header, clause);
            if (info != null) {
                info.set(setLocation);
            } else {
                setLocation.header(header).context(clause);
            }
        }
        catch (Exception e) {
            this.exception(e, "unexpected exception in setLocation", new Object[0]);
        }
        return setLocation;
    }

    private Reporter.SetLocation location(String s) {
        SetLocationImpl loc = new SetLocationImpl(s);
        this.locations.add(loc);
        return loc;
    }

    @Override
    public Report.Location getLocation(String msg) {
        assert (msg != null) : "Must provide message";
        for (Report.Location l : this.locations) {
            if (l.message == null || !msg.equals(l.message)) continue;
            return l;
        }
        return null;
    }

    public FileLine getHeader(String header) throws Exception {
        return this.getHeader(Pattern.compile("^[ \t]*".concat(Pattern.quote(header)), 10));
    }

    public static Pattern toFullHeaderPattern(String header) {
        StringBuilder sb = new StringBuilder();
        sb.append("^[ \t]*(").append(header).append(")(\\.[^\\s:=]*)?[ \t]*[ \t:=][ \t]*");
        sb.append("[^\\\\\n\r]*(\\\\\n[^\\\\\n\r]*)*");
        try {
            return Pattern.compile(sb.toString(), 10);
        }
        catch (Exception e) {
            return Pattern.compile("^[ \t]*".concat(Pattern.quote(header)), 10);
        }
    }

    public FileLine getHeader(Pattern header) throws Exception {
        return this.getHeader(header, null);
    }

    public FileLine getHeader(String header, String clause) throws Exception {
        return this.getHeader(Processor.toFullHeaderPattern(header), clause == null ? null : Pattern.compile(clause, 16));
    }

    public FileLine getHeader(Pattern header, Pattern clause) throws Exception {
        FileLine fl = this.getHeader0(header, clause);
        if (fl != null) {
            return fl;
        }
        Processor rover = this;
        while (rover.getPropertiesFile() == null) {
            if (rover.parent == null) {
                return new FileLine(new File("ANONYMOUS"), 0, 0);
            }
            rover = rover.parent;
        }
        return new FileLine(rover.getPropertiesFile(), 0, 0);
    }

    private FileLine getHeader0(Pattern header, Pattern clause) throws Exception {
        FileLine fl;
        File f = this.getPropertiesFile();
        if (f != null) {
            fl = Processor.findHeader(f, header, clause);
            if (fl != null) {
                return fl;
            }
            Iterator<File> iter = new ArrayDeque<File>(this.getIncluded()).descendingIterator();
            while (iter.hasNext()) {
                File file = iter.next();
                fl = Processor.findHeader(file, header);
                if (fl == null) continue;
                return fl;
            }
        }
        if (this.getParent() != null && (fl = this.getParent().getHeader(header, clause)) != null) {
            return fl;
        }
        if (f == null && this.parent != null) {
            f = this.parent.getPropertiesFile();
        }
        if (f == null) {
            return null;
        }
        return new FileLine(f, 0, 0);
    }

    public static FileLine findHeader(File f, String header) throws IOException {
        return Processor.findHeader(f, Pattern.compile("^[ \t]*".concat(Pattern.quote(header)), 10));
    }

    public static FileLine findHeader(File f, Pattern header) throws IOException {
        return Processor.findHeader(f, header, null);
    }

    public static FileLine findHeader(File f, Pattern header, Pattern clause) throws IOException {
        if (f.isFile()) {
            String s = IO.collect(f);
            Matcher matcher = header.matcher(s);
            while (matcher.find()) {
                FileLine fl = new FileLine();
                fl.file = f;
                fl.start = matcher.start();
                fl.end = matcher.end();
                fl.length = fl.end - fl.start;
                fl.line = Processor.getLine(s, fl.start);
                if (clause != null) {
                    Matcher mclause = clause.matcher(s);
                    mclause.region(fl.start, fl.end);
                    if (!mclause.find()) continue;
                    fl.start = mclause.start();
                    fl.end = mclause.end();
                }
                return fl;
            }
        }
        return null;
    }

    public static int getLine(String s, int index) {
        int n = 0;
        while (--index > 0) {
            char c = s.charAt(index);
            if (c != '\n') continue;
            ++n;
        }
        return n;
    }

    public boolean since(Version introduced) {
        if (this.upto == null) {
            String uptov = this.getProperty("-upto");
            if (uptov == null) {
                this.upto = Version.HIGHEST;
                return true;
            }
            if (!Version.VERSION.matcher(uptov).matches()) {
                this.error("The %s given version is not a version: %s", "-upto", uptov);
                this.upto = Version.HIGHEST;
                return true;
            }
            this.upto = new Version(uptov);
        }
        return this.upto.compareTo(introduced) >= 0;
    }

    public void report(Map<String, Object> table) throws Exception {
        table.put("Included Files", this.getIncluded());
        table.put("Base", this.getBase());
        table.put("Properties", this.getProperties0().entrySet());
    }

    public boolean is(String propertyName) {
        return Processor.isTrue(this.getProperty(propertyName));
    }

    public String mergeProperties(String key) {
        return this.mergeProperties(key, ",");
    }

    public String mergeLocalProperties(String key) {
        if (this.since(About._3_3)) {
            return this.getProperty(this.makeWildcard(key), null, ",", false);
        }
        return this.mergeProperties(key);
    }

    public String mergeProperties(String key, String separator) {
        if (this.since(About._2_4)) {
            return this.getProperty(this.makeWildcard(key), null, separator, true);
        }
        return this.getProperty(key);
    }

    private String makeWildcard(String key) {
        return key + ".*";
    }

    public Parameters getMergedParameters(String key) {
        return new Parameters(this.mergeProperties(key), this);
    }

    public <T> T[] concat(Class<T> type, T[] prefix, T suffix) {
        Object[] result = (Object[])Array.newInstance(type, (prefix != null ? prefix.length : 0) + 1);
        if (result.length > 1) {
            System.arraycopy(prefix, 0, result, 0, result.length - 1);
        }
        result[result.length - 1] = suffix;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Jar getJarFromName(String name, String from) {
        File file = new File(name);
        if (!file.isAbsolute()) {
            file = new File(this.getBase(), name);
        }
        if (file.exists()) {
            try {
                Jar jar2 = new Jar(file);
                this.addClose(jar2);
                return jar2;
            }
            catch (Exception e) {
                this.error("Exception in parsing jar file for %s: %s %s", from, name, e);
            }
        }
        try {
            URL url = new URL(name);
            try (Resource resource = Resource.fromURL(url, this.getPlugin(HttpClient.class));){
                Jar jar3 = Jar.fromResource(this.fileName(url.getPath()), resource);
                if (jar3.lastModified() <= 0L) {
                    jar3.updateModified(System.currentTimeMillis(), "use current time");
                }
                this.addClose(jar3);
                Jar jar = jar3;
                return jar;
            }
        }
        catch (IOException url) {
            return null;
        }
        catch (Exception ee) {
            throw Exceptions.duck(ee);
        }
    }

    private String fileName(String path) {
        int n = path.lastIndexOf(47);
        if (n > 0) {
            return path.substring(n + 1);
        }
        return path;
    }

    public String _thisfile(String[] args) {
        if (this.propertiesFile == null) {
            this.error("${thisfile} executed on a processor without a properties file", new Object[0]);
            return null;
        }
        return IO.absolutePath(this.propertiesFile);
    }

    public void getSettings(Processor p) {
        this.trace = p.isTrace();
        this.pedantic = p.isPedantic();
        this.exceptions = p.isExceptions();
    }

    public String _frange(String[] args) {
        VersionRange vr;
        boolean isProvider;
        if (args.length < 2 || args.length > 3) {
            this.error("Invalid filter range, 2 or 3 args${frange;<version>[;true|false]}", new Object[0]);
            return null;
        }
        String v = args[1];
        boolean bl = isProvider = args.length == 3 && Processor.isTrue(args[2]);
        if (Verifier.isVersion(v)) {
            Version l = new Version(v);
            Version h = isProvider ? l.bumpMinor() : l.bumpMajor();
            vr = new VersionRange(true, l, h, false);
        } else if (Verifier.isVersionRange(v)) {
            vr = new VersionRange(v);
        } else {
            this.error("The _frange parameter %s is neither a version nor a version range", v);
            return null;
        }
        return vr.toFilter();
    }

    public String _findfile(String[] args) {
        File f = this.getFile(args[1]);
        ArrayList<String> files = new ArrayList<String>();
        this.tree(files, f, "", new Instruction(args[2]));
        return Processor.join(files);
    }

    void tree(List<String> list, File current, String path, Instruction instr) {
        String[] subs;
        if (path.length() > 0) {
            path = path.concat("/");
        }
        if ((subs = current.list()) != null) {
            for (String sub : subs) {
                File f = new File(current, sub);
                if (f.isFile()) {
                    if (!(instr.matches(sub) ^ instr.isNegated())) continue;
                    list.add(path + sub);
                    continue;
                }
                this.tree(list, f, path + sub, instr);
            }
        }
    }

    public <T> T getInstructions(Class<T> type) {
        return Syntax.getInstructions(this, type);
    }

    public boolean isInteractive() {
        if (this.parent != null) {
            return this.parent.isInteractive();
        }
        return false;
    }

    @Override
    public Parameters getParameters(String key, boolean allowDuplicates) {
        return new Parameters(this.get(key), this, allowDuplicates);
    }

    public String system(boolean allowFail, String command, String input) throws IOException, InterruptedException {
        List<String> args = IO.isWindows() ? Lists.of("cmd", "/c", Command.windowsQuote(command)) : new QuotedTokenizer(command, " \t", false, true).stream().filter(token -> !token.isEmpty()).collect(Collectors.toList());
        Process process = new ProcessBuilder(args).directory(this.getBase()).start();
        try (OutputStream stdin = process.getOutputStream();){
            if (input != null) {
                IO.store((Object)input, stdin, StandardCharsets.UTF_8);
            }
        }
        String out = IO.collect(process.getInputStream(), StandardCharsets.UTF_8);
        String err = IO.collect(process.getErrorStream(), StandardCharsets.UTF_8);
        int exitValue = process.waitFor();
        if (exitValue == 0) {
            return out.trim();
        }
        if (allowFail) {
            this.warning("System command %s failed with exit code %d (allowed)", command, exitValue);
        } else {
            this.error("System command %s failed with exit code %d: %s%n---%n%s", command, exitValue, out, err);
        }
        return null;
    }

    public String system(String command, String input) throws IOException, InterruptedException {
        boolean allowFail = false;
        if ((command = command.trim()).startsWith("-")) {
            command = command.substring(1);
            allowFail = true;
        }
        return this.system(allowFail, command, input);
    }

    public String getJavaExecutable(String java) {
        String path = this.getProperty(Objects.requireNonNull(java));
        if (path == null || path.equals(java)) {
            return IO.getJavaExecutablePath(java);
        }
        return path;
    }

    public Parameters decorated(String key, boolean literalsIncluded) {
        Parameters parameters = new Parameters(this.mergeProperties(key), this);
        Instructions decorator = new Instructions(this.mergeProperties(key + "+"));
        decorator.decorate(parameters, literalsIncluded);
        return parameters;
    }

    public Parameters decorated(String key) {
        return this.decorated(key, false);
    }

    public synchronized String getProfile() {
        if (this.profile == null) {
            this.profile = "cycle";
            this.profile = this.getProperty("-profile");
        }
        return this.profile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getChecksum() {
        try (Processor p = new Processor(this);){
            String checksum;
            p.setProperty("_@tstamp", "0");
            Properties flattenedProperties = p.getFlattenedProperties();
            Digester<SHA1> digester = SHA1.getDigester(new OutputStream[0]);
            TreeSet<Object> keySet = new TreeSet<Object>(flattenedProperties.keySet());
            keySet.forEach(k -> {
                try {
                    byte[] bytes = k.getBytes(StandardCharsets.UTF_8);
                    digester.write(bytes);
                    String s = flattenedProperties.getProperty((String)k);
                    if (s == null) {
                        return;
                    }
                    bytes = s.getBytes(StandardCharsets.UTF_8);
                    digester.write(bytes);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            });
            String string = checksum = digester.digest().asHex();
            return string;
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    public List<File> getSelfAndAncestors() {
        ArrayList<File> l = new ArrayList<File>();
        return this.getSelfAndAncestors(l);
    }

    private List<File> getSelfAndAncestors(List<File> l) {
        if (this.parent != null) {
            this.parent.getSelfAndAncestors(l);
        }
        l.addAll(this.getIncluded());
        File f = this.getPropertiesFile();
        if (f != null) {
            l.add(f);
        }
        return l;
    }

    static {
        ReporterAdapter reporterAdapter = new ReporterAdapter(System.out);
        reporterAdapter.setTrace(true);
        reporterAdapter.setExceptions(true);
        reporterAdapter.setPedantic(true);
        log = reporterAdapter;
        current = new ThreadLocal();
        Function<String, ThreadFactory> threadFactoryFactory = prefix -> {
            ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
            return r -> {
                Thread t = defaultThreadFactory.newThread(r);
                t.setName(prefix + t.getName());
                t.setDaemon(true);
                return t;
            };
        };
        ThreadFactory executorThreadFactory = threadFactoryFactory.apply("Bnd-Executor,");
        ThreadFactory scheduledExecutorThreadFactory = threadFactoryFactory.apply("Bnd-ScheduledExecutor,");
        RejectedExecutionHandler rejectedExecutionHandler = (r, e) -> {
            if (e.isShutdown()) {
                return;
            }
            try {
                r.run();
            }
            catch (Throwable t) {
                try {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        int corePoolSize = 2;
        int maximumPoolSize = Integer.getInteger("bnd.executor.maximumPoolSize", 256);
        executor = new ThreadPoolExecutor(2, maximumPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), executorThreadFactory, rejectedExecutionHandler);
        scheduledExecutor = new ScheduledThreadPoolExecutor(2, scheduledExecutorThreadFactory, rejectedExecutionHandler);
        scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduledExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        AtomicBoolean shutdownHookInstalled = new AtomicBoolean();
        Function<ThreadFactory, ThreadFactory> shutdownHookInstaller = threadFactory -> r -> {
            if (shutdownHookInstalled.compareAndSet(false, true)) {
                executor.setThreadFactory(executorThreadFactory);
                scheduledExecutor.setThreadFactory(scheduledExecutorThreadFactory);
                Thread shutdownThread = new Thread(() -> {
                    executor.setMaximumPoolSize(Math.max(2, executor.getPoolSize()));
                    scheduledExecutor.shutdown();
                    try {
                        scheduledExecutor.awaitTermination(20L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    executor.shutdown();
                    try {
                        executor.awaitTermination(20L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }, "Bnd-ExecutorShutdownHook");
                try {
                    Runtime.getRuntime().addShutdownHook(shutdownThread);
                }
                catch (IllegalStateException e) {
                    executor.shutdown();
                    scheduledExecutor.shutdown();
                }
            }
            return threadFactory.newThread(r);
        };
        executor.setThreadFactory(shutdownHookInstaller.apply(executorThreadFactory));
        scheduledExecutor.setThreadFactory(shutdownHookInstaller.apply(scheduledExecutorThreadFactory));
        promiseFactory = new PromiseFactory((Executor)executor, (ScheduledExecutorService)scheduledExecutor);
        random = new Random();
        defaultConstructor = MethodType.methodType(Void.TYPE);
        DURATION_P = Pattern.compile("\\s*(\\d+)\\s*(NANOSECONDS|MICROSECONDS|MILLISECONDS|SECONDS|MINUTES|HOURS|DAYS)?");
    }

    static class SetLocationImpl
    extends Report.Location
    implements Reporter.SetLocation {
        public SetLocationImpl(String s) {
            this.message = s;
        }

        @Override
        public Reporter.SetLocation file(String file) {
            this.file = file != null ? IO.normalizePath(file) : null;
            return this;
        }

        @Override
        public Reporter.SetLocation header(String header) {
            this.header = header;
            return this;
        }

        @Override
        public Reporter.SetLocation context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public Reporter.SetLocation method(String methodName) {
            this.methodName = methodName;
            return this;
        }

        @Override
        public Reporter.SetLocation line(int n) {
            this.line = n;
            return this;
        }

        @Override
        public Reporter.SetLocation reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public Reporter.SetLocation details(Object details) {
            this.details = details;
            return this;
        }

        @Override
        public Report.Location location() {
            return this;
        }

        @Override
        public Reporter.SetLocation length(int length) {
            this.length = length;
            return this;
        }
    }

    public static class CL
    extends ActivelyClosingClassLoader {
        public CL(Processor p) {
            super(p, p.getClass().getClassLoader());
        }

        @Override
        @Deprecated
        public URL[] getURLs() {
            return new URL[0];
        }
    }

    public static class FileLine {
        public static final FileLine DUMMY = new FileLine(null, 0, 0);
        public File file;
        public int line;
        public int length;
        public int start;
        public int end;

        public FileLine() {
        }

        public FileLine(File file, int line, int length) {
            this.file = file;
            this.line = line;
            this.length = length;
        }

        public void set(Reporter.SetLocation sl) {
            sl.file(IO.absolutePath(this.file));
            sl.line(this.line);
            sl.length(this.length);
        }
    }
}

