/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.shell.api.action;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The @Completion annotation can be used on a field annotated with
 * {@link Option} or {@link Argument} to specify the completion
 * method to use for this field.
 *
 * @see org.apache.karaf.shell.api.console.Completer
 * @see org.apache.karaf.shell.support.completers.StringsCompleter
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
public @interface Completion {

    /**
     * The completer class to use for this field.
     * The console registry will be used to look for
     * a completer of this class.
     *
     * A special case for simple static completions is to use
     * {@link org.apache.karaf.shell.support.completers.StringsCompleter},
     * in which case, the <code>values</code> property will be used
     * as the list of possible completions.
     */
    Class<?> value();

    /**
     * When using a static completer, returns the possible values.
     */
    String[] values() default { };

    /**
     * When using a static completer, indicates if completion
     * should be done case sensitive or not.
     */
    boolean caseSensitive() default false;

}
