/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;

public final class UnlimitedWindows
extends Windows<UnlimitedWindow> {
    private static final long DEFAULT_START_TIMESTAMP_MS = 0L;
    public final long startMs;

    private UnlimitedWindows(long startMs) {
        this.startMs = startMs;
    }

    public static UnlimitedWindows of() {
        return new UnlimitedWindows(0L);
    }

    public UnlimitedWindows startOn(Instant start) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(start, "start");
        long startMs = ApiUtils.validateMillisecondInstant(start, msgPrefix);
        if (startMs < 0L) {
            throw new IllegalArgumentException("Window start time (startMs) cannot be negative.");
        }
        return new UnlimitedWindows(startMs);
    }

    @Override
    public Map<Long, UnlimitedWindow> windowsFor(long timestamp) {
        HashMap<Long, UnlimitedWindow> windows = new HashMap<Long, UnlimitedWindow>();
        if (timestamp >= this.startMs) {
            windows.put(this.startMs, new UnlimitedWindow(this.startMs));
        }
        return windows;
    }

    @Override
    public long size() {
        return Long.MAX_VALUE;
    }

    @Override
    public long gracePeriodMs() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnlimitedWindows that = (UnlimitedWindows)o;
        return this.startMs == that.startMs;
    }

    public int hashCode() {
        return Objects.hash(this.startMs);
    }

    public String toString() {
        return "UnlimitedWindows{startMs=" + this.startMs + "}";
    }
}

