/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.NamedOperation;

public class Grouped<K, V>
implements NamedOperation<Grouped<K, V>> {
    protected final Serde<K> keySerde;
    protected final Serde<V> valueSerde;
    protected final String name;

    private Grouped(String name, Serde<K> keySerde, Serde<V> valueSerde) {
        this.name = name;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    protected Grouped(Grouped<K, V> grouped) {
        this(grouped.name, grouped.keySerde, grouped.valueSerde);
    }

    public static <K, V> Grouped<K, V> as(String name) {
        return new Grouped<K, V>(name, null, null);
    }

    public static <K, V> Grouped<K, V> keySerde(Serde<K> keySerde) {
        return new Grouped<K, V>(null, keySerde, null);
    }

    public static <K, V> Grouped<K, V> valueSerde(Serde<V> valueSerde) {
        return new Grouped<K, V>(null, null, valueSerde);
    }

    public static <K, V> Grouped<K, V> with(String name, Serde<K> keySerde, Serde<V> valueSerde) {
        return new Grouped<K, V>(name, keySerde, valueSerde);
    }

    public static <K, V> Grouped<K, V> with(Serde<K> keySerde, Serde<V> valueSerde) {
        return new Grouped<K, V>(null, keySerde, valueSerde);
    }

    @Override
    public Grouped<K, V> withName(String name) {
        return new Grouped<K, V>(name, this.keySerde, this.valueSerde);
    }

    public Grouped<K, V> withKeySerde(Serde<K> keySerde) {
        return new Grouped<K, V>(this.name, keySerde, this.valueSerde);
    }

    public Grouped<K, V> withValueSerde(Serde<V> valueSerde) {
        return new Grouped<K, V>(this.name, this.keySerde, valueSerde);
    }
}

