/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.transaction.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;

public class TransactionLogValueJsonConverter {
    public static TransactionLogValue read(JsonNode _node, short _version) {
        TransactionLogValue _object = new TransactionLogValue();
        JsonNode _producerIdNode = _node.get("producerId");
        if (_producerIdNode == null) {
            throw new RuntimeException("TransactionLogValue: unable to locate field 'producerId', which is mandatory in version " + _version);
        }
        _object.producerId = MessageUtil.jsonNodeToLong((JsonNode)_producerIdNode, (String)"TransactionLogValue");
        JsonNode _producerEpochNode = _node.get("producerEpoch");
        if (_producerEpochNode == null) {
            throw new RuntimeException("TransactionLogValue: unable to locate field 'producerEpoch', which is mandatory in version " + _version);
        }
        _object.producerEpoch = MessageUtil.jsonNodeToShort((JsonNode)_producerEpochNode, (String)"TransactionLogValue");
        JsonNode _transactionTimeoutMsNode = _node.get("transactionTimeoutMs");
        if (_transactionTimeoutMsNode == null) {
            throw new RuntimeException("TransactionLogValue: unable to locate field 'transactionTimeoutMs', which is mandatory in version " + _version);
        }
        _object.transactionTimeoutMs = MessageUtil.jsonNodeToInt((JsonNode)_transactionTimeoutMsNode, (String)"TransactionLogValue");
        JsonNode _transactionStatusNode = _node.get("transactionStatus");
        if (_transactionStatusNode == null) {
            throw new RuntimeException("TransactionLogValue: unable to locate field 'transactionStatus', which is mandatory in version " + _version);
        }
        _object.transactionStatus = MessageUtil.jsonNodeToByte((JsonNode)_transactionStatusNode, (String)"TransactionLogValue");
        JsonNode _transactionPartitionsNode = _node.get("transactionPartitions");
        if (_transactionPartitionsNode == null) {
            throw new RuntimeException("TransactionLogValue: unable to locate field 'transactionPartitions', which is mandatory in version " + _version);
        }
        if (_transactionPartitionsNode.isNull()) {
            _object.transactionPartitions = null;
        } else {
            if (!_transactionPartitionsNode.isArray()) {
                throw new RuntimeException("TransactionLogValue expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<TransactionLogValue.PartitionsSchema> _collection = new ArrayList<TransactionLogValue.PartitionsSchema>(_transactionPartitionsNode.size());
            _object.transactionPartitions = _collection;
            for (JsonNode _element : _transactionPartitionsNode) {
                _collection.add(PartitionsSchemaJsonConverter.read(_element, _version));
            }
        }
        JsonNode _transactionLastUpdateTimestampMsNode = _node.get("transactionLastUpdateTimestampMs");
        if (_transactionLastUpdateTimestampMsNode == null) {
            throw new RuntimeException("TransactionLogValue: unable to locate field 'transactionLastUpdateTimestampMs', which is mandatory in version " + _version);
        }
        _object.transactionLastUpdateTimestampMs = MessageUtil.jsonNodeToLong((JsonNode)_transactionLastUpdateTimestampMsNode, (String)"TransactionLogValue");
        JsonNode _transactionStartTimestampMsNode = _node.get("transactionStartTimestampMs");
        if (_transactionStartTimestampMsNode == null) {
            throw new RuntimeException("TransactionLogValue: unable to locate field 'transactionStartTimestampMs', which is mandatory in version " + _version);
        }
        _object.transactionStartTimestampMs = MessageUtil.jsonNodeToLong((JsonNode)_transactionStartTimestampMsNode, (String)"TransactionLogValue");
        return _object;
    }

    public static JsonNode write(TransactionLogValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("producerId", (JsonNode)new LongNode(_object.producerId));
        _node.set("producerEpoch", (JsonNode)new ShortNode(_object.producerEpoch));
        _node.set("transactionTimeoutMs", (JsonNode)new IntNode(_object.transactionTimeoutMs));
        _node.set("transactionStatus", (JsonNode)new ShortNode((short)_object.transactionStatus));
        if (_object.transactionPartitions == null) {
            _node.set("transactionPartitions", (JsonNode)NullNode.instance);
        } else {
            ArrayNode _transactionPartitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (TransactionLogValue.PartitionsSchema _element : _object.transactionPartitions) {
                _transactionPartitionsArray.add(PartitionsSchemaJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("transactionPartitions", (JsonNode)_transactionPartitionsArray);
        }
        _node.set("transactionLastUpdateTimestampMs", (JsonNode)new LongNode(_object.transactionLastUpdateTimestampMs));
        _node.set("transactionStartTimestampMs", (JsonNode)new LongNode(_object.transactionStartTimestampMs));
        return _node;
    }

    public static JsonNode write(TransactionLogValue _object, short _version) {
        return TransactionLogValueJsonConverter.write(_object, _version, true);
    }

    public static class PartitionsSchemaJsonConverter {
        public static TransactionLogValue.PartitionsSchema read(JsonNode _node, short _version) {
            TransactionLogValue.PartitionsSchema _object = new TransactionLogValue.PartitionsSchema();
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("PartitionsSchema: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("PartitionsSchema expected a string type, but got " + _node.getNodeType());
            }
            _object.topic = _topicNode.asText();
            JsonNode _partitionIdsNode = _node.get("partitionIds");
            if (_partitionIdsNode == null) {
                throw new RuntimeException("PartitionsSchema: unable to locate field 'partitionIds', which is mandatory in version " + _version);
            }
            if (!_partitionIdsNode.isArray()) {
                throw new RuntimeException("PartitionsSchema expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionIdsNode.size());
            _object.partitionIds = _collection;
            for (JsonNode _element : _partitionIdsNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionsSchema element"));
            }
            return _object;
        }

        public static JsonNode write(TransactionLogValue.PartitionsSchema _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            ArrayNode _partitionIdsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitionIds) {
                _partitionIdsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("partitionIds", (JsonNode)_partitionIdsArray);
            return _node;
        }

        public static JsonNode write(TransactionLogValue.PartitionsSchema _object, short _version) {
            return PartitionsSchemaJsonConverter.write(_object, _version, true);
        }
    }
}

