/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterClosedException;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class ImageReWriter
implements ImageWriter {
    private final MetadataDelta delta;
    private boolean closed = false;
    private MetadataImage image = null;

    public ImageReWriter(MetadataDelta delta) {
        this.delta = delta;
    }

    @Override
    public void write(ApiMessageAndVersion record) {
        if (this.closed) {
            throw new ImageWriterClosedException();
        }
        this.delta.replay(record.message());
    }

    @Override
    public void close(boolean complete) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (complete) {
            this.delta.finishSnapshot();
            this.image = this.delta.apply(this.delta.image().provenance());
        }
    }

    public MetadataImage image() {
        return this.image;
    }
}

