/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigException;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.runtime.BoxesRunTime;

public final class DynamicThreadPool$ {
    public static DynamicThreadPool$ MODULE$;
    private final Set<String> ReconfigurableConfigs;

    static {
        new DynamicThreadPool$();
    }

    public Set<String> ReconfigurableConfigs() {
        return this.ReconfigurableConfigs;
    }

    public void validateReconfiguration(KafkaConfig currentConfig, KafkaConfig newConfig) {
        newConfig.values().forEach((k, v) -> {
            if (MODULE$.ReconfigurableConfigs().contains(k)) {
                int oldValue;
                int newValue = BoxesRunTime.unboxToInt((Object)v);
                if (newValue != (oldValue = MODULE$.getValue(currentConfig, (String)k))) {
                    String errorMsg = new StringBuilder(51).append("Dynamic thread count update validation failed for ").append((String)k).append("=").append(v).toString();
                    if (newValue <= 0) {
                        throw new ConfigException(new StringBuilder(28).append(errorMsg).append(", value should be at least 1").toString());
                    }
                    if (newValue < oldValue / 2) {
                        throw new ConfigException(new StringBuilder(50).append(errorMsg).append(", value should be at least half the current value ").append(oldValue).toString());
                    }
                    if (newValue > oldValue * 2) {
                        throw new ConfigException(new StringBuilder(60).append(errorMsg).append(", value should not be greater than double the current value ").append(oldValue).toString());
                    }
                    return;
                }
                return;
            }
        });
    }

    public int getValue(KafkaConfig config, String name) {
        if ("num.io.threads".equals(name)) {
            return Predef$.MODULE$.Integer2int(config.numIoThreads());
        }
        if ("num.replica.fetchers".equals(name)) {
            return Predef$.MODULE$.Integer2int(config.numReplicaFetchers());
        }
        if ("num.recovery.threads.per.data.dir".equals(name)) {
            return Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir());
        }
        if ("background.threads".equals(name)) {
            return Predef$.MODULE$.Integer2int(config.backgroundThreads());
        }
        throw new IllegalStateException(new StringBuilder(18).append("Unexpected config ").append(name).toString());
    }

    private DynamicThreadPool$() {
        MODULE$ = this;
        this.ReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"num.io.threads", "num.replica.fetchers", "num.recovery.threads.per.data.dir", "background.threads"}));
    }
}

