/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;

public class EndQuorumEpochRequest
extends AbstractRequest {
    private final EndQuorumEpochRequestData data;

    private EndQuorumEpochRequest(EndQuorumEpochRequestData data, short version) {
        super(ApiKeys.END_QUORUM_EPOCH, version);
        this.data = data;
    }

    @Override
    public EndQuorumEpochRequestData data() {
        return this.data;
    }

    @Override
    public EndQuorumEpochResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new EndQuorumEpochResponse(new EndQuorumEpochResponseData().setErrorCode(Errors.forException(e).code()));
    }

    public static EndQuorumEpochRequest parse(ByteBuffer buffer, short version) {
        return new EndQuorumEpochRequest(new EndQuorumEpochRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static EndQuorumEpochRequestData singletonRequest(TopicPartition topicPartition, int leaderEpoch, int leaderId, List<Integer> preferredSuccessors) {
        return EndQuorumEpochRequest.singletonRequest(topicPartition, null, leaderEpoch, leaderId, preferredSuccessors);
    }

    public static EndQuorumEpochRequestData singletonRequest(TopicPartition topicPartition, String clusterId, int leaderEpoch, int leaderId, List<Integer> preferredSuccessors) {
        return new EndQuorumEpochRequestData().setClusterId(clusterId).setTopics(Collections.singletonList(new EndQuorumEpochRequestData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new EndQuorumEpochRequestData.PartitionData().setPartitionIndex(topicPartition.partition()).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setPreferredSuccessors(preferredSuccessors)))));
    }

    public static class Builder
    extends AbstractRequest.Builder<EndQuorumEpochRequest> {
        private final EndQuorumEpochRequestData data;

        public Builder(EndQuorumEpochRequestData data) {
            super(ApiKeys.END_QUORUM_EPOCH);
            this.data = data;
        }

        @Override
        public EndQuorumEpochRequest build(short version) {
            return new EndQuorumEpochRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

