/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\u000b\u0017\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011!!\u0006\u00011A\u0005\u0002Y)\u0006\u0002C4\u0001\u0001\u0004%\tA\u00065\t\r9\u0004\u0001\u0015)\u0003W\u0011\u001dy\u0007A1A\u0005\nUCa\u0001\u001d\u0001!\u0002\u00131\u0006bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007m\u0002\u0001\u000b\u0011B:\t\u000f]\u0004!\u0019!C\u0005q\"1A\u0010\u0001Q\u0001\neDQ! \u0001\u0005ByDq!!\u0002\u0001\t\u0003\n9\u0001\u0003\u0005\u0002\u0014\u0001!\tAFA\u000b\u0011!\t9\u0002\u0001C\u0001-\u0005U\u0001\u0002CA\r\u0001\u0011\u0005a#a\u0007\t\u000f\u00055\u0002\u0001\"\u0003\u0002\u0016\t!\"\u000bU\"Qe>$WoY3s\u0013\u0012l\u0015M\\1hKJT!a\u0006\r\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u00033i\t1bY8pe\u0012Lg.\u0019;pe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001qB\u0005\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\f\n\u0005\u001d2\"!\u0005)s_\u0012,8-\u001a:JI6\u000bg.Y4feB\u0011\u0011\u0006L\u0007\u0002U)\u00111FG\u0001\u0006kRLGn]\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e!\ty\u0002'\u0003\u00022A\t\u0019\u0011J\u001c;\u0002\tQLW.\u001a\t\u0003iuj\u0011!\u000e\u0006\u0003WYR!a\u000e\u001d\u0002\r\r|W.\\8o\u0015\tY\u0012H\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 6\u0005\u0011!\u0016.\\3\u0002'\t\u0014xn[3s\u000bB|7\r[*vaBd\u0017.\u001a:\u0011\u0007}\t5)\u0003\u0002CA\tIa)\u001e8di&|g\u000e\r\t\u0003?\u0011K!!\u0012\u0011\u0003\t1{gnZ\u0001\u0012G>tGO]8mY\u0016\u00148\t[1o]\u0016d\u0007C\u0001%L\u001b\u0005I%B\u0001&9\u0003\u0019\u0019XM\u001d<fe&\u0011A*\u0013\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\fa\u0001P5oSRtD#B(Q#J\u001b\u0006CA\u0013\u0001\u0011\u0015qS\u00011\u00010\u0011\u0015\u0011T\u00011\u00014\u0011\u0015yT\u00011\u0001A\u0011\u00151U\u00011\u0001H\u0003MqW\r\u001f;Qe>$WoY3s\u0013\u0012\u0014En\\2l+\u00051\u0006cA,aE6\t\u0001L\u0003\u0002Z5\u00061\u0011\r^8nS\u000eT!a\u0017/\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002^=\u0006!Q\u000f^5m\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019-\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"aY3\u000e\u0003\u0011T!aN%\n\u0005\u0019$'\u0001\u0005)s_\u0012,8-\u001a:JIN\u0014En\\2l\u0003]qW\r\u001f;Qe>$WoY3s\u0013\u0012\u0014En\\2l?\u0012*\u0017\u000f\u0006\u0002jYB\u0011qD[\u0005\u0003W\u0002\u0012A!\u00168ji\"9QnBA\u0001\u0002\u00041\u0016a\u0001=%c\u0005!b.\u001a=u!J|G-^2fe&#'\t\\8dW\u0002\nacY;se\u0016tG\u000f\u0015:pIV\u001cWM]%e\u00052|7m[\u0001\u0018GV\u0014(/\u001a8u!J|G-^2fe&#'\t\\8dW\u0002\nqB]3rk\u0016\u001cH/\u00138GY&<\u0007\u000e^\u000b\u0002gB\u0011q\u000b^\u0005\u0003kb\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001\u0005:fcV,7\u000f^%o\r2Lw\r\u001b;!\u0003E\u0011\u0017mY6pM\u001a$U-\u00193mS:,Wj]\u000b\u0002sB\u0011qK_\u0005\u0003wb\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0003I\u0011\u0017mY6pM\u001a$U-\u00193mS:,Wj\u001d\u0011\u0002\u001b!\f7OV1mS\u0012\u0014En\\2l+\u0005y\bcA\u0010\u0002\u0002%\u0019\u00111\u0001\u0011\u0003\u000f\t{w\u000e\\3b]\u0006\u0011r-\u001a8fe\u0006$X\r\u0015:pIV\u001cWM]%e)\t\tI\u0001E\u0003\u0002\f\u0005=1)\u0004\u0002\u0002\u000e)\u0011Q\fI\u0005\u0005\u0003#\tiAA\u0002Uef\fQ#\\1zE\u0016\u0014V-];fgRtU\r\u001f;CY>\u001c7\u000eF\u0001j\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0002C!\fg\u000e\u001a7f\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d*fgB|gn]3\u0015\u0007%\fi\u0002C\u0004\u0002 M\u0001\r!!\t\u0002\u0011I,7\u000f]8og\u0016\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0014\u0001\u0003:fcV,7\u000f^:\n\t\u0005-\u0012Q\u0005\u0002\u001c\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d*fgB|gn]3\u0002\u001b!\fg\u000e\u001a7f)&lWm\\;u\u0001")
public class RPCProducerIdManager
implements ProducerIdManager,
Logging {
    private final int brokerId;
    private final Time time;
    private final Function0<Object> brokerEpochSupplier;
    private final NodeToControllerChannelManager controllerChannel;
    private AtomicReference<ProducerIdsBlock> nextProducerIdBlock;
    private final AtomicReference<ProducerIdsBlock> currentProducerIdBlock;
    private final AtomicBoolean requestInFlight;
    private final AtomicLong backoffDeadlineMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        ProducerIdManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicReference<ProducerIdsBlock> nextProducerIdBlock() {
        return this.nextProducerIdBlock;
    }

    public void nextProducerIdBlock_$eq(AtomicReference<ProducerIdsBlock> x$1) {
        this.nextProducerIdBlock = x$1;
    }

    private AtomicReference<ProducerIdsBlock> currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private AtomicBoolean requestInFlight() {
        return this.requestInFlight;
    }

    private AtomicLong backoffDeadlineMs() {
        return this.backoffDeadlineMs;
    }

    @Override
    public boolean hasValidBlock() {
        return this.nextProducerIdBlock().get() != null;
    }

    @Override
    public Try<Object> generateProducerId() {
        Failure result = null;
        int iteration = 0;
        while (result == null) {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.currentProducerIdBlock().get().claimNextId()));
            if (None$.MODULE$.equals(option)) {
                ProducerIdsBlock block = this.nextProducerIdBlock().getAndSet(null);
                if (block == null) {
                    this.maybeRequestNextBlock();
                    result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
                } else {
                    this.currentProducerIdBlock().set(block);
                    this.requestInFlight().set(false);
                    ++iteration;
                }
            } else if (option instanceof Some) {
                long prefetchTarget;
                Long nextProducerId = (Long)((Some)option).value();
                if (BoxesRunTime.equalsNumObject((Number)nextProducerId, (Object)BoxesRunTime.boxToLong((long)(prefetchTarget = this.currentProducerIdBlock().get().firstProducerId() + (long)((double)this.currentProducerIdBlock().get().size() * ProducerIdManager$.MODULE$.PidPrefetchThreshold()))))) {
                    this.maybeRequestNextBlock();
                }
                result = new Success((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(nextProducerId)));
            } else {
                throw new MatchError((Object)option);
            }
            if (iteration != ProducerIdManager$.MODULE$.IterationLimit()) continue;
            result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
        }
        return result;
    }

    public void maybeRequestNextBlock() {
        long retryTimestamp = this.backoffDeadlineMs().get();
        if (retryTimestamp == ProducerIdManager$.MODULE$.NoRetry() || this.time.milliseconds() >= retryTimestamp) {
            if (this.nextProducerIdBlock().get() == null && this.requestInFlight().compareAndSet(false, true)) {
                this.sendRequest();
                this.backoffDeadlineMs().set(ProducerIdManager$.MODULE$.NoRetry());
                return;
            }
            return;
        }
    }

    public void sendRequest() {
        AllocateProducerIdsRequestData message = new AllocateProducerIdsRequestData().setBrokerEpoch(this.brokerEpochSupplier.apply$mcJ$sp()).setBrokerId(this.brokerId);
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(message);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Requesting next Producer ID block");
        this.controllerChannel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(this){
            private final /* synthetic */ RPCProducerIdManager $outer;

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse message = (AllocateProducerIdsResponse)response.responseBody();
                this.$outer.handleAllocateProducerIdsResponse(message);
            }

            public void onTimeout() {
                this.$outer.kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
        AllocateProducerIdsResponseData data = response.data();
        boolean successfulResponse = false;
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.NONE.equals(errors)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Got next producer ID block from controller ").append(data).toString());
            if (data.producerIdStart() < this.currentProducerIdBlock().get().lastProducerId()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Producer ID block is not monotonic with current block: current=").append(this.currentProducerIdBlock()).append(" response=").append(data).toString());
            } else if (data.producerIdStart() < 0L || data.producerIdLen() < 0 || data.producerIdStart() > Long.MAX_VALUE - (long)data.producerIdLen()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Producer ID block includes invalid ID range: ").append(data).toString());
            } else {
                this.nextProducerIdBlock().set(new ProducerIdsBlock(this.brokerId, data.producerIdStart(), data.producerIdLen()));
                successfulResponse = true;
            }
        } else if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker currentBlockCount was stale, trying again.");
        } else if (Errors.BROKER_ID_NOT_REGISTERED.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker ID is not yet known by the controller, trying again.");
        } else if (errors != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Received an unexpected error code from the controller: ").append(errors).toString());
        } else {
            throw new MatchError(null);
        }
        if (!successfulResponse) {
            this.backoffDeadlineMs().set(this.time.milliseconds() + (long)ProducerIdManager$.MODULE$.RetryBackoffMs());
            this.requestInFlight().set(false);
            return;
        }
    }

    public void kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout() {
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Timed out when requesting AllocateProducerIds from the controller.");
        this.requestInFlight().set(false);
    }

    public RPCProducerIdManager(int brokerId, Time time, Function0<Object> brokerEpochSupplier, NodeToControllerChannelManager controllerChannel) {
        this.brokerId = brokerId;
        this.time = time;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.controllerChannel = controllerChannel;
        this.logIdent_$eq(new StringBuilder(27).append("[RPC ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.nextProducerIdBlock = new AtomicReference<Object>(null);
        this.currentProducerIdBlock = new AtomicReference<ProducerIdsBlock>(ProducerIdsBlock.EMPTY);
        this.requestInFlight = new AtomicBoolean(false);
        this.backoffDeadlineMs = new AtomicLong(ProducerIdManager$.MODULE$.NoRetry());
    }
}

