/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.loader;

import java.util.Objects;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LoaderManifestType;
import org.apache.kafka.raft.LeaderAndEpoch;

public class LogDeltaManifest
implements LoaderManifest {
    private final MetadataProvenance provenance;
    private final LeaderAndEpoch leaderAndEpoch;
    private final int numBatches;
    private final long elapsedNs;
    private final long numBytes;

    LogDeltaManifest(MetadataProvenance provenance, LeaderAndEpoch leaderAndEpoch, int numBatches, long elapsedNs, long numBytes) {
        this.provenance = provenance;
        this.leaderAndEpoch = leaderAndEpoch;
        this.numBatches = numBatches;
        this.elapsedNs = elapsedNs;
        this.numBytes = numBytes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public LoaderManifestType type() {
        return LoaderManifestType.LOG_DELTA;
    }

    @Override
    public MetadataProvenance provenance() {
        return this.provenance;
    }

    public LeaderAndEpoch leaderAndEpoch() {
        return this.leaderAndEpoch;
    }

    public int numBatches() {
        return this.numBatches;
    }

    public long elapsedNs() {
        return this.elapsedNs;
    }

    public long numBytes() {
        return this.numBytes;
    }

    public int hashCode() {
        return Objects.hash(this.provenance, this.leaderAndEpoch, this.numBatches, this.elapsedNs, this.numBytes);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        LogDeltaManifest other = (LogDeltaManifest)o;
        return this.provenance.equals(other.provenance) && this.leaderAndEpoch == other.leaderAndEpoch && this.numBatches == other.numBatches && this.elapsedNs == other.elapsedNs && this.numBytes == other.numBytes;
    }

    public String toString() {
        return "LogDeltaManifest(provenance=" + this.provenance + ", leaderAndEpoch=" + this.leaderAndEpoch + ", numBatches=" + this.numBatches + ", elapsedNs=" + this.elapsedNs + ", numBytes=" + this.numBytes + ")";
    }

    public static class Builder {
        private MetadataProvenance provenance;
        private LeaderAndEpoch leaderAndEpoch;
        private int numBatches = -1;
        private long elapsedNs = -1L;
        private long numBytes = -1L;

        public Builder provenance(MetadataProvenance provenance) {
            this.provenance = provenance;
            return this;
        }

        public Builder leaderAndEpoch(LeaderAndEpoch leaderAndEpoch) {
            this.leaderAndEpoch = leaderAndEpoch;
            return this;
        }

        public Builder numBatches(int numBatches) {
            this.numBatches = numBatches;
            return this;
        }

        public Builder elapsedNs(long elapsedNs) {
            this.elapsedNs = elapsedNs;
            return this;
        }

        public Builder numBytes(long numBytes) {
            this.numBytes = numBytes;
            return this;
        }

        public LogDeltaManifest build() {
            if (this.provenance == null) {
                throw new RuntimeException("provenance must not be null");
            }
            if (this.leaderAndEpoch == null) {
                throw new RuntimeException("leaderAndEpoch must not be null");
            }
            if (this.numBatches == -1) {
                throw new RuntimeException("numBatches must not be null");
            }
            if (this.elapsedNs == -1L) {
                throw new RuntimeException("elapsedNs must not be null");
            }
            if (this.numBytes == -1L) {
                throw new RuntimeException("numBytes must not be null");
            }
            return new LogDeltaManifest(this.provenance, this.leaderAndEpoch, this.numBatches, this.elapsedNs, this.numBytes);
        }
    }
}

