/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.KStreamKTableJoin;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.TimeOrderedKeyValueBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KStreamKTableJoinProcessor<K1, K2, V1, V2, VOut>
extends ContextualProcessor<K1, V1, K1, VOut> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamKTableJoin.class);
    private final KTableValueGetter<K2, V2> valueGetter;
    private final KeyValueMapper<? super K1, ? super V1, ? extends K2> keyMapper;
    private final ValueJoinerWithKey<? super K1, ? super V1, ? super V2, ? extends VOut> joiner;
    private final boolean leftJoin;
    private Sensor droppedRecordsSensor;
    private final Optional<Duration> gracePeriod;
    private TimeOrderedKeyValueBuffer<K1, V1, V1> buffer;
    protected long observedStreamTime = -1L;
    private InternalProcessorContext internalProcessorContext;
    private final boolean useBuffer;
    private final String storeName;

    KStreamKTableJoinProcessor(KTableValueGetter<K2, V2> valueGetter, KeyValueMapper<? super K1, ? super V1, ? extends K2> keyMapper, ValueJoinerWithKey<? super K1, ? super V1, ? super V2, ? extends VOut> joiner, boolean leftJoin, Optional<Duration> gracePeriod, Optional<String> storeName) {
        this.valueGetter = valueGetter;
        this.keyMapper = keyMapper;
        this.joiner = joiner;
        this.leftJoin = leftJoin;
        this.useBuffer = gracePeriod.isPresent();
        this.gracePeriod = gracePeriod;
        this.storeName = storeName.orElse("");
    }

    @Override
    public void init(ProcessorContext<K1, VOut> context) {
        super.init(context);
        StreamsMetricsImpl metrics = (StreamsMetricsImpl)context.metrics();
        this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), metrics);
        this.valueGetter.init(context);
        this.internalProcessorContext = ProcessorContextUtils.asInternalProcessorContext((org.apache.kafka.streams.processor.ProcessorContext)((Object)context));
        if (this.useBuffer) {
            if (!this.valueGetter.isVersioned() && this.gracePeriod.isPresent()) {
                throw new IllegalArgumentException("KTable must be versioned to use a grace period in a stream table join.");
            }
            this.buffer = (TimeOrderedKeyValueBuffer)Objects.requireNonNull(context.getStateStore(this.storeName));
            this.buffer.setSerdesIfNull(new SerdeGetter(context));
        }
    }

    @Override
    public void process(Record<K1, V1> record) {
        this.internalProcessorContext = ProcessorContextUtils.asInternalProcessorContext((org.apache.kafka.streams.processor.ProcessorContext)((Object)this.context()));
        this.updateObservedStreamTime(record.timestamp());
        if (this.maybeDropRecord(record)) {
            return;
        }
        if (!this.useBuffer) {
            this.doJoin(record);
        } else if (!this.buffer.put(this.observedStreamTime, record, this.internalProcessorContext.recordContext())) {
            this.doJoin(record);
        } else {
            this.buffer.evictWhile(() -> true, this::emit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(TimeOrderedKeyValueBuffer.Eviction<K1, V1> toEmit) {
        Record<K1, V1> record = new Record<K1, V1>(toEmit.key(), toEmit.value(), toEmit.recordContext().timestamp()).withHeaders(toEmit.recordContext().headers());
        ProcessorRecordContext prevRecordContext = this.internalProcessorContext.recordContext();
        try {
            this.internalProcessorContext.setRecordContext(toEmit.recordContext());
            this.doJoin(record);
        }
        finally {
            this.internalProcessorContext.setRecordContext(prevRecordContext);
        }
    }

    protected void updateObservedStreamTime(long timestamp) {
        this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
    }

    private void doJoin(Record<K1, V1> record) {
        K2 mappedKey = this.keyMapper.apply(record.key(), record.value());
        ValueAndTimestamp<V2> valueAndTimestamp2 = this.valueGetter.isVersioned() ? this.valueGetter.get(mappedKey, record.timestamp()) : this.valueGetter.get(mappedKey);
        V2 value2 = ValueAndTimestamp.getValueOrNull(valueAndTimestamp2);
        if (this.leftJoin || value2 != null) {
            this.internalProcessorContext.forward(record.withValue(this.joiner.apply(record.key(), record.value(), value2)));
        }
    }

    private boolean maybeDropRecord(Record<K1, V1> record) {
        K2 mappedKey = this.keyMapper.apply(record.key(), record.value());
        if (mappedKey == null || record.value() == null) {
            if (this.context().recordMetadata().isPresent()) {
                RecordMetadata recordMetadata = this.context().recordMetadata().get();
                LOG.warn("Skipping record due to null join key or value. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
            } else {
                LOG.warn("Skipping record due to null join key or value. Topic, partition, and offset not known.");
            }
            this.droppedRecordsSensor.record();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.valueGetter.close();
    }
}

