/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.serialization;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.BytesApiMessageSerde;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogSegmentMetadataSnapshot;
import org.apache.kafka.server.log.remote.metadata.storage.generated.MetadataRecordType;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataRecord;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataSnapshotRecord;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataUpdateRecord;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemotePartitionDeleteMetadataRecord;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataSnapshotTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataUpdateTransform;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemotePartitionDeleteMetadataTransform;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;

public class RemoteLogMetadataSerde {
    private static final short REMOTE_LOG_SEGMENT_METADATA_API_KEY = new RemoteLogSegmentMetadataRecord().apiKey();
    private static final short REMOTE_LOG_SEGMENT_METADATA_UPDATE_API_KEY = new RemoteLogSegmentMetadataUpdateRecord().apiKey();
    private static final short REMOTE_PARTITION_DELETE_API_KEY = new RemotePartitionDeleteMetadataRecord().apiKey();
    private static final short REMOTE_LOG_SEGMENT_METADATA_SNAPSHOT_API_KEY = new RemoteLogSegmentMetadataSnapshotRecord().apiKey();
    private final Map<String, Short> remoteLogStorageClassToApiKey = this.createRemoteLogStorageClassToApiKeyMap();
    private final Map<Short, RemoteLogMetadataTransform> keyToTransform = this.createRemoteLogMetadataTransforms();
    private final BytesApiMessageSerde bytesApiMessageSerde = new BytesApiMessageSerde(){

        public ApiMessage apiMessageFor(short apiKey) {
            return RemoteLogMetadataSerde.this.newApiMessage(apiKey);
        }
    };

    protected ApiMessage newApiMessage(short apiKey) {
        return MetadataRecordType.fromId(apiKey).newMetadataRecord();
    }

    protected Map<Short, RemoteLogMetadataTransform> createRemoteLogMetadataTransforms() {
        HashMap<Short, RemoteLogMetadataTransform> map = new HashMap<Short, RemoteLogMetadataTransform>();
        map.put(REMOTE_LOG_SEGMENT_METADATA_API_KEY, new RemoteLogSegmentMetadataTransform());
        map.put(REMOTE_LOG_SEGMENT_METADATA_UPDATE_API_KEY, new RemoteLogSegmentMetadataUpdateTransform());
        map.put(REMOTE_PARTITION_DELETE_API_KEY, new RemotePartitionDeleteMetadataTransform());
        map.put(REMOTE_LOG_SEGMENT_METADATA_SNAPSHOT_API_KEY, new RemoteLogSegmentMetadataSnapshotTransform());
        return map;
    }

    protected Map<String, Short> createRemoteLogStorageClassToApiKeyMap() {
        HashMap<String, Short> map = new HashMap<String, Short>();
        map.put(RemoteLogSegmentMetadata.class.getName(), REMOTE_LOG_SEGMENT_METADATA_API_KEY);
        map.put(RemoteLogSegmentMetadataUpdate.class.getName(), REMOTE_LOG_SEGMENT_METADATA_UPDATE_API_KEY);
        map.put(RemotePartitionDeleteMetadata.class.getName(), REMOTE_PARTITION_DELETE_API_KEY);
        map.put(RemoteLogSegmentMetadataSnapshot.class.getName(), REMOTE_LOG_SEGMENT_METADATA_SNAPSHOT_API_KEY);
        return map;
    }

    public byte[] serialize(RemoteLogMetadata remoteLogMetadata) {
        Short apiKey = this.remoteLogStorageClassToApiKey.get(remoteLogMetadata.getClass().getName());
        if (apiKey == null) {
            throw new IllegalArgumentException("ApiKey for given RemoteStorageMetadata class: " + remoteLogMetadata.getClass() + " does not exist.");
        }
        ApiMessageAndVersion apiMessageAndVersion = this.remoteLogMetadataTransform(apiKey).toApiMessageAndVersion(remoteLogMetadata);
        return this.bytesApiMessageSerde.serialize(apiMessageAndVersion);
    }

    public RemoteLogMetadata deserialize(byte[] data) {
        ApiMessageAndVersion apiMessageAndVersion = this.bytesApiMessageSerde.deserialize(data);
        return this.remoteLogMetadataTransform(apiMessageAndVersion.message().apiKey()).fromApiMessageAndVersion(apiMessageAndVersion);
    }

    private RemoteLogMetadataTransform remoteLogMetadataTransform(short apiKey) {
        RemoteLogMetadataTransform metadataTransform = this.keyToTransform.get(apiKey);
        if (metadataTransform == null) {
            throw new IllegalArgumentException("RemoteLogMetadataTransform for apikey: " + apiKey + " does not exist.");
        }
        return metadataTransform;
    }

    public static class RemoteLogMetadataFormatter
    implements MessageFormatter {
        private final RemoteLogMetadataSerde remoteLogMetadataSerde = new RemoteLogMetadataSerde();

        public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
            output.printf("partition: %d, offset: %d, value: %s%n", consumerRecord.partition(), consumerRecord.offset(), this.remoteLogMetadataSerde.deserialize((byte[])consumerRecord.value()).toString());
        }
    }
}

