/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.runtime.rest.RestServerConfig;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorPluginsResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;
import org.apache.kafka.connect.runtime.rest.resources.InternalConnectResource;
import org.apache.kafka.connect.runtime.rest.resources.LoggingResource;
import org.apache.kafka.connect.runtime.rest.resources.RootResource;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;

public class ConnectRestServer
extends RestServer {
    private final RestClient restClient;
    private Herder herder;

    public ConnectRestServer(Integer rebalanceTimeoutMs, RestClient restClient, Map<?, ?> props) {
        super(RestServerConfig.forPublic(rebalanceTimeoutMs, props));
        this.restClient = restClient;
    }

    public void initializeResources(Herder herder) {
        this.herder = herder;
        super.initializeResources();
    }

    @Override
    protected Collection<Class<?>> regularResources() {
        return Arrays.asList(RootResource.class, ConnectorsResource.class, InternalConnectResource.class, ConnectorPluginsResource.class);
    }

    @Override
    protected Collection<Class<?>> adminResources() {
        return Arrays.asList(LoggingResource.class);
    }

    @Override
    protected void configureRegularResources(ResourceConfig resourceConfig) {
        this.registerRestExtensions(this.herder, resourceConfig);
        resourceConfig.register((Object)new Binder());
    }

    private class Binder
    extends AbstractBinder {
        private Binder() {
        }

        protected void configure() {
            this.bind(ConnectRestServer.this.herder).to(Herder.class);
            this.bind(ConnectRestServer.this.restClient).to(RestClient.class);
            this.bind((Object)ConnectRestServer.this.config).to(RestServerConfig.class);
        }
    }
}

