/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.SubscribedTopicMetadata;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;

public class TargetAssignmentBuilder {
    private final String groupId;
    private final int groupEpoch;
    private final PartitionAssignor assignor;
    private Map<String, ConsumerGroupMember> members = Collections.emptyMap();
    private Map<String, TopicMetadata> subscriptionMetadata = Collections.emptyMap();
    private Map<String, Assignment> targetAssignment = Collections.emptyMap();
    private final Map<String, ConsumerGroupMember> updatedMembers = new HashMap<String, ConsumerGroupMember>();

    public TargetAssignmentBuilder(String groupId, int groupEpoch, PartitionAssignor assignor) {
        this.groupId = Objects.requireNonNull(groupId);
        this.groupEpoch = groupEpoch;
        this.assignor = Objects.requireNonNull(assignor);
    }

    public TargetAssignmentBuilder withMembers(Map<String, ConsumerGroupMember> members) {
        this.members = members;
        return this;
    }

    public TargetAssignmentBuilder withSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscriptionMetadata = subscriptionMetadata;
        return this;
    }

    public TargetAssignmentBuilder withTargetAssignment(Map<String, Assignment> targetAssignment) {
        this.targetAssignment = targetAssignment;
        return this;
    }

    public TargetAssignmentBuilder addOrUpdateMember(String memberId, ConsumerGroupMember member) {
        this.updatedMembers.put(memberId, member);
        return this;
    }

    public TargetAssignmentBuilder removeMember(String memberId) {
        return this.addOrUpdateMember(memberId, null);
    }

    public TargetAssignmentResult build() throws PartitionAssignorException {
        HashMap memberSpecs = new HashMap();
        this.members.forEach((memberId, member) -> memberSpecs.put(memberId, TargetAssignmentBuilder.createAssignmentMemberSpec(member, this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY), this.subscriptionMetadata)));
        this.updatedMembers.forEach((memberId, updatedMemberOrNull) -> {
            if (updatedMemberOrNull == null) {
                memberSpecs.remove(memberId);
            } else {
                memberSpecs.put(memberId, TargetAssignmentBuilder.createAssignmentMemberSpec(updatedMemberOrNull, this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY), this.subscriptionMetadata));
            }
        });
        HashMap<Uuid, TopicMetadata> topicMetadataMap = new HashMap<Uuid, TopicMetadata>();
        this.subscriptionMetadata.forEach((topicName, topicMetadata) -> topicMetadataMap.put(topicMetadata.id(), (TopicMetadata)topicMetadata));
        GroupAssignment newGroupAssignment = this.assignor.assign(new AssignmentSpec(Collections.unmodifiableMap(memberSpecs)), new SubscribedTopicMetadata(topicMetadataMap));
        ArrayList<Record> records = new ArrayList<Record>();
        HashMap<String, Assignment> newTargetAssignment = new HashMap<String, Assignment>();
        memberSpecs.keySet().forEach(memberId -> {
            Assignment oldMemberAssignment = this.targetAssignment.get(memberId);
            Assignment newMemberAssignment = this.newMemberAssignment(newGroupAssignment, (String)memberId);
            newTargetAssignment.put((String)memberId, newMemberAssignment);
            if (oldMemberAssignment == null) {
                records.add(RecordHelpers.newTargetAssignmentRecord(this.groupId, memberId, newMemberAssignment.partitions()));
            } else if (!newMemberAssignment.equals(oldMemberAssignment)) {
                records.add(RecordHelpers.newTargetAssignmentRecord(this.groupId, memberId, newMemberAssignment.partitions()));
            }
        });
        records.add(RecordHelpers.newTargetAssignmentEpochRecord(this.groupId, this.groupEpoch));
        return new TargetAssignmentResult(records, newTargetAssignment);
    }

    private Assignment newMemberAssignment(GroupAssignment newGroupAssignment, String memberId) {
        MemberAssignment newMemberAssignment = newGroupAssignment.members().get(memberId);
        if (newMemberAssignment != null) {
            return new Assignment(newMemberAssignment.targetPartitions());
        }
        return Assignment.EMPTY;
    }

    public static AssignmentMemberSpec createAssignmentMemberSpec(ConsumerGroupMember member, Assignment targetAssignment, Map<String, TopicMetadata> subscriptionMetadata) {
        HashSet<Uuid> subscribedTopics = new HashSet<Uuid>();
        member.subscribedTopicNames().forEach(topicName -> {
            TopicMetadata topicMetadata = (TopicMetadata)subscriptionMetadata.get(topicName);
            if (topicMetadata != null) {
                subscribedTopics.add(topicMetadata.id());
            }
        });
        return new AssignmentMemberSpec(Optional.ofNullable(member.instanceId()), Optional.ofNullable(member.rackId()), subscribedTopics, targetAssignment.partitions());
    }

    public static class TargetAssignmentResult {
        private final List<Record> records;
        private final Map<String, Assignment> targetAssignment;

        TargetAssignmentResult(List<Record> records, Map<String, Assignment> targetAssignment) {
            Objects.requireNonNull(records);
            Objects.requireNonNull(targetAssignment);
            this.records = records;
            this.targetAssignment = targetAssignment;
        }

        public List<Record> records() {
            return this.records;
        }

        public Map<String, Assignment> targetAssignment() {
            return this.targetAssignment;
        }
    }
}

