/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint$;
import kafka.coordinator.group.OffsetConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ReplicationQuotaManagerConfig$;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.BrokerSecurityConfigs;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.coordinator.group.assignor.RangeAssignor;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;

public final class Defaults$ {
    public static Defaults$ MODULE$;
    private final int ZkSessionTimeoutMs;
    private final boolean ZkEnableSecureAcls;
    private final int ZkMaxInFlightRequests;
    private final boolean ZkSslClientEnable;
    private final String ZkSslProtocol;
    private final String ZkSslEndpointIdentificationAlgorithm;
    private final boolean ZkSslCrlEnable;
    private final boolean ZkSslOcspEnable;
    private final boolean BrokerIdGenerationEnable;
    private final int MaxReservedBrokerId;
    private final int BrokerId;
    private final int NumNetworkThreads;
    private final int NumIoThreads;
    private final int BackgroundThreads;
    private final int QueuedMaxRequests;
    private final int QueuedMaxRequestBytes;
    private final int InitialBrokerRegistrationTimeoutMs;
    private final int BrokerHeartbeatIntervalMs;
    private final int BrokerSessionTimeoutMs;
    private final int MetadataSnapshotMaxNewRecordBytes;
    private final long MetadataSnapshotMaxIntervalMs;
    private final int MetadataMaxIdleIntervalMs;
    private final int MetadataMaxRetentionBytes;
    private final boolean DeleteTopicEnable;
    private final int EmptyNodeId;
    private final long ServerMaxStartupTimeMs;
    private final String AuthorizerClassName;
    private final String Listeners;
    private final String ListenerSecurityProtocolMap;
    private final int SocketSendBufferBytes;
    private final int SocketReceiveBufferBytes;
    private final int SocketRequestMaxBytes;
    private final int SocketListenBacklogSize;
    private final int MaxConnectionsPerIp;
    private final String MaxConnectionsPerIpOverrides;
    private final int MaxConnections;
    private final int MaxConnectionCreationRate;
    private final long ConnectionsMaxIdleMs;
    private final int RequestTimeoutMs;
    private final Long ConnectionSetupTimeoutMs;
    private final Long ConnectionSetupTimeoutMaxMs;
    private final int FailedAuthenticationDelayMs;
    private final int NumPartitions;
    private final String LogDir;
    private final long LogCleanupIntervalMs;
    private final int LogCleanerThreads;
    private final double LogCleanerIoMaxBytesPerSecond;
    private final long LogCleanerDedupeBufferSize;
    private final int LogCleanerIoBufferSize;
    private final double LogCleanerDedupeBufferLoadFactor;
    private final int LogCleanerBackoffMs;
    private final boolean LogCleanerEnable;
    private final int LogFlushOffsetCheckpointIntervalMs;
    private final int LogFlushStartOffsetCheckpointIntervalMs;
    private final int NumRecoveryThreadsPerDataDir;
    private final boolean AutoCreateTopicsEnable;
    private final int ControllerSocketTimeoutMs;
    private final int DefaultReplicationFactor;
    private final long ReplicaLagTimeMaxMs;
    private final int ReplicaSocketTimeoutMs;
    private final int ReplicaSocketReceiveBufferBytes;
    private final int ReplicaFetchMaxBytes;
    private final int ReplicaFetchWaitMaxMs;
    private final int ReplicaFetchMinBytes;
    private final int ReplicaFetchResponseMaxBytes;
    private final int NumReplicaFetchers;
    private final int ReplicaFetchBackoffMs;
    private final long ReplicaHighWatermarkCheckpointIntervalMs;
    private final int FetchPurgatoryPurgeIntervalRequests;
    private final int ProducerPurgatoryPurgeIntervalRequests;
    private final int DeleteRecordsPurgatoryPurgeIntervalRequests;
    private final boolean AutoLeaderRebalanceEnable;
    private final int LeaderImbalancePerBrokerPercentage;
    private final int LeaderImbalanceCheckIntervalSeconds;
    private final String InterBrokerSecurityProtocol;
    private final String InterBrokerProtocolVersion;
    private final int ControlledShutdownMaxRetries;
    private final int ControlledShutdownRetryBackoffMs;
    private final boolean ControlledShutdownEnable;
    private final int GroupMinSessionTimeoutMs;
    private final int GroupMaxSessionTimeoutMs;
    private final int GroupInitialRebalanceDelayMs;
    private final int GroupMaxSize;
    private final boolean NewGroupCoordinatorEnable;
    private final int GroupCoordinatorNumThreads;
    private final int ConsumerGroupSessionTimeoutMs;
    private final int ConsumerGroupMinSessionTimeoutMs;
    private final int ConsumerGroupMaxSessionTimeoutMs;
    private final int ConsumerGroupHeartbeatIntervalMs;
    private final int ConsumerGroupMinHeartbeatIntervalMs;
    private final int ConsumerGroupMaxHeartbeatIntervalMs;
    private final int ConsumerGroupMaxSize;
    private final java.util.List<String> ConsumerGroupAssignors;
    private final int OffsetMetadataMaxSize;
    private final int OffsetsLoadBufferSize;
    private final short OffsetsTopicReplicationFactor;
    private final int OffsetsTopicPartitions;
    private final int OffsetsTopicSegmentBytes;
    private final int OffsetsTopicCompressionCodec;
    private final int OffsetsRetentionMinutes;
    private final long OffsetsRetentionCheckIntervalMs;
    private final int OffsetCommitTimeoutMs;
    private final short OffsetCommitRequiredAcks;
    private final int TransactionalIdExpirationMs;
    private final int TransactionsMaxTimeoutMs;
    private final int TransactionsTopicMinISR;
    private final int TransactionsLoadBufferSize;
    private final short TransactionsTopicReplicationFactor;
    private final int TransactionsTopicPartitions;
    private final int TransactionsTopicSegmentBytes;
    private final int TransactionsAbortTimedOutTransactionsCleanupIntervalMS;
    private final int TransactionsRemoveExpiredTransactionsCleanupIntervalMS;
    private final boolean TransactionPartitionVerificationEnable;
    private final int ProducerIdExpirationMs;
    private final int ProducerIdExpirationCheckIntervalMs;
    private final int MaxIncrementalFetchSessionCacheSlots;
    private final int FetchMaxBytes;
    private final int NumQuotaSamples;
    private final int QuotaWindowSizeSeconds;
    private final int NumReplicationQuotaSamples;
    private final int ReplicationQuotaWindowSizeSeconds;
    private final int NumAlterLogDirsReplicationQuotaSamples;
    private final int AlterLogDirsReplicationQuotaWindowSizeSeconds;
    private final int NumControllerQuotaSamples;
    private final int ControllerQuotaWindowSizeSeconds;
    private final int MetricNumSamples;
    private final int MetricSampleWindowMs;
    private final String MetricReporterClasses;
    private final String MetricRecordingLevel;
    private final boolean AutoIncludeJmxReporter;
    private final String KafkaMetricReporterClasses;
    private final int KafkaMetricsPollingIntervalSeconds;
    private final String SslProtocol;
    private final String SslEnabledProtocols;
    private final String SslKeystoreType;
    private final String SslTruststoreType;
    private final String SslKeyManagerAlgorithm;
    private final String SslTrustManagerAlgorithm;
    private final String SslEndpointIdentificationAlgorithm;
    private final String SslClientAuthentication;
    private final String[] SslClientAuthenticationValidValues;
    private final String SslPrincipalMappingRules;
    private final long ConnectionsMaxReauthMsDefault;
    private final int DefaultServerMaxMaxReceiveSize;
    private final Class<DefaultKafkaPrincipalBuilder> DefaultPrincipalBuilder;
    private final String SaslMechanismInterBrokerProtocol;
    private final java.util.List<String> SaslEnabledMechanisms;
    private final String SaslKerberosKinitCmd;
    private final double SaslKerberosTicketRenewWindowFactor;
    private final double SaslKerberosTicketRenewJitter;
    private final long SaslKerberosMinTimeBeforeRelogin;
    private final java.util.List<String> SaslKerberosPrincipalToLocalRules;
    private final double SaslLoginRefreshWindowFactor;
    private final double SaslLoginRefreshWindowJitter;
    private final short SaslLoginRefreshMinPeriodSeconds;
    private final short SaslLoginRefreshBufferSeconds;
    private final long SaslLoginRetryBackoffMaxMs;
    private final long SaslLoginRetryBackoffMs;
    private final String SaslOAuthBearerScopeClaimName;
    private final String SaslOAuthBearerSubClaimName;
    private final long SaslOAuthBearerJwksEndpointRefreshMs;
    private final long SaslOAuthBearerJwksEndpointRetryBackoffMaxMs;
    private final long SaslOAuthBearerJwksEndpointRetryBackoffMs;
    private final int SaslOAuthBearerClockSkewSeconds;
    private final long DelegationTokenMaxLifeTimeMsDefault;
    private final long DelegationTokenExpiryTimeMsDefault;
    private final long DelegationTokenExpiryCheckIntervalMsDefault;
    private final String PasswordEncoderCipherAlgorithm;
    private final int PasswordEncoderKeyLength;
    private final int PasswordEncoderIterations;
    private final java.util.List<String> QuorumVoters;
    private final int QuorumElectionTimeoutMs;
    private final int QuorumFetchTimeoutMs;
    private final int QuorumElectionBackoffMs;
    private final int QuorumLingerMs;
    private final int QuorumRequestTimeoutMs;
    private final int QuorumRetryBackoffMs;

    static {
        new Defaults$();
    }

    public int ZkSessionTimeoutMs() {
        return this.ZkSessionTimeoutMs;
    }

    public boolean ZkEnableSecureAcls() {
        return this.ZkEnableSecureAcls;
    }

    public int ZkMaxInFlightRequests() {
        return this.ZkMaxInFlightRequests;
    }

    public boolean ZkSslClientEnable() {
        return this.ZkSslClientEnable;
    }

    public String ZkSslProtocol() {
        return this.ZkSslProtocol;
    }

    public String ZkSslEndpointIdentificationAlgorithm() {
        return this.ZkSslEndpointIdentificationAlgorithm;
    }

    public boolean ZkSslCrlEnable() {
        return this.ZkSslCrlEnable;
    }

    public boolean ZkSslOcspEnable() {
        return this.ZkSslOcspEnable;
    }

    public boolean BrokerIdGenerationEnable() {
        return this.BrokerIdGenerationEnable;
    }

    public int MaxReservedBrokerId() {
        return this.MaxReservedBrokerId;
    }

    public int BrokerId() {
        return this.BrokerId;
    }

    public int NumNetworkThreads() {
        return this.NumNetworkThreads;
    }

    public int NumIoThreads() {
        return this.NumIoThreads;
    }

    public int BackgroundThreads() {
        return this.BackgroundThreads;
    }

    public int QueuedMaxRequests() {
        return this.QueuedMaxRequests;
    }

    public int QueuedMaxRequestBytes() {
        return this.QueuedMaxRequestBytes;
    }

    public int InitialBrokerRegistrationTimeoutMs() {
        return this.InitialBrokerRegistrationTimeoutMs;
    }

    public int BrokerHeartbeatIntervalMs() {
        return this.BrokerHeartbeatIntervalMs;
    }

    public int BrokerSessionTimeoutMs() {
        return this.BrokerSessionTimeoutMs;
    }

    public int MetadataSnapshotMaxNewRecordBytes() {
        return this.MetadataSnapshotMaxNewRecordBytes;
    }

    public long MetadataSnapshotMaxIntervalMs() {
        return this.MetadataSnapshotMaxIntervalMs;
    }

    public int MetadataMaxIdleIntervalMs() {
        return this.MetadataMaxIdleIntervalMs;
    }

    public int MetadataMaxRetentionBytes() {
        return this.MetadataMaxRetentionBytes;
    }

    public boolean DeleteTopicEnable() {
        return this.DeleteTopicEnable;
    }

    public int EmptyNodeId() {
        return this.EmptyNodeId;
    }

    public long ServerMaxStartupTimeMs() {
        return this.ServerMaxStartupTimeMs;
    }

    public String AuthorizerClassName() {
        return this.AuthorizerClassName;
    }

    public String Listeners() {
        return this.Listeners;
    }

    public String ListenerSecurityProtocolMap() {
        return this.ListenerSecurityProtocolMap;
    }

    public int SocketSendBufferBytes() {
        return this.SocketSendBufferBytes;
    }

    public int SocketReceiveBufferBytes() {
        return this.SocketReceiveBufferBytes;
    }

    public int SocketRequestMaxBytes() {
        return this.SocketRequestMaxBytes;
    }

    public int SocketListenBacklogSize() {
        return this.SocketListenBacklogSize;
    }

    public int MaxConnectionsPerIp() {
        return this.MaxConnectionsPerIp;
    }

    public String MaxConnectionsPerIpOverrides() {
        return this.MaxConnectionsPerIpOverrides;
    }

    public int MaxConnections() {
        return this.MaxConnections;
    }

    public int MaxConnectionCreationRate() {
        return this.MaxConnectionCreationRate;
    }

    public long ConnectionsMaxIdleMs() {
        return this.ConnectionsMaxIdleMs;
    }

    public int RequestTimeoutMs() {
        return this.RequestTimeoutMs;
    }

    public Long ConnectionSetupTimeoutMs() {
        return this.ConnectionSetupTimeoutMs;
    }

    public Long ConnectionSetupTimeoutMaxMs() {
        return this.ConnectionSetupTimeoutMaxMs;
    }

    public int FailedAuthenticationDelayMs() {
        return this.FailedAuthenticationDelayMs;
    }

    public int NumPartitions() {
        return this.NumPartitions;
    }

    public String LogDir() {
        return this.LogDir;
    }

    public long LogCleanupIntervalMs() {
        return this.LogCleanupIntervalMs;
    }

    public int LogCleanerThreads() {
        return this.LogCleanerThreads;
    }

    public double LogCleanerIoMaxBytesPerSecond() {
        return this.LogCleanerIoMaxBytesPerSecond;
    }

    public long LogCleanerDedupeBufferSize() {
        return this.LogCleanerDedupeBufferSize;
    }

    public int LogCleanerIoBufferSize() {
        return this.LogCleanerIoBufferSize;
    }

    public double LogCleanerDedupeBufferLoadFactor() {
        return this.LogCleanerDedupeBufferLoadFactor;
    }

    public int LogCleanerBackoffMs() {
        return this.LogCleanerBackoffMs;
    }

    public boolean LogCleanerEnable() {
        return this.LogCleanerEnable;
    }

    public int LogFlushOffsetCheckpointIntervalMs() {
        return this.LogFlushOffsetCheckpointIntervalMs;
    }

    public int LogFlushStartOffsetCheckpointIntervalMs() {
        return this.LogFlushStartOffsetCheckpointIntervalMs;
    }

    public int NumRecoveryThreadsPerDataDir() {
        return this.NumRecoveryThreadsPerDataDir;
    }

    public boolean AutoCreateTopicsEnable() {
        return this.AutoCreateTopicsEnable;
    }

    public int ControllerSocketTimeoutMs() {
        return this.ControllerSocketTimeoutMs;
    }

    public int DefaultReplicationFactor() {
        return this.DefaultReplicationFactor;
    }

    public long ReplicaLagTimeMaxMs() {
        return this.ReplicaLagTimeMaxMs;
    }

    public int ReplicaSocketTimeoutMs() {
        return this.ReplicaSocketTimeoutMs;
    }

    public int ReplicaSocketReceiveBufferBytes() {
        return this.ReplicaSocketReceiveBufferBytes;
    }

    public int ReplicaFetchMaxBytes() {
        return this.ReplicaFetchMaxBytes;
    }

    public int ReplicaFetchWaitMaxMs() {
        return this.ReplicaFetchWaitMaxMs;
    }

    public int ReplicaFetchMinBytes() {
        return this.ReplicaFetchMinBytes;
    }

    public int ReplicaFetchResponseMaxBytes() {
        return this.ReplicaFetchResponseMaxBytes;
    }

    public int NumReplicaFetchers() {
        return this.NumReplicaFetchers;
    }

    public int ReplicaFetchBackoffMs() {
        return this.ReplicaFetchBackoffMs;
    }

    public long ReplicaHighWatermarkCheckpointIntervalMs() {
        return this.ReplicaHighWatermarkCheckpointIntervalMs;
    }

    public int FetchPurgatoryPurgeIntervalRequests() {
        return this.FetchPurgatoryPurgeIntervalRequests;
    }

    public int ProducerPurgatoryPurgeIntervalRequests() {
        return this.ProducerPurgatoryPurgeIntervalRequests;
    }

    public int DeleteRecordsPurgatoryPurgeIntervalRequests() {
        return this.DeleteRecordsPurgatoryPurgeIntervalRequests;
    }

    public boolean AutoLeaderRebalanceEnable() {
        return this.AutoLeaderRebalanceEnable;
    }

    public int LeaderImbalancePerBrokerPercentage() {
        return this.LeaderImbalancePerBrokerPercentage;
    }

    public int LeaderImbalanceCheckIntervalSeconds() {
        return this.LeaderImbalanceCheckIntervalSeconds;
    }

    public String InterBrokerSecurityProtocol() {
        return this.InterBrokerSecurityProtocol;
    }

    public String InterBrokerProtocolVersion() {
        return this.InterBrokerProtocolVersion;
    }

    public int ControlledShutdownMaxRetries() {
        return this.ControlledShutdownMaxRetries;
    }

    public int ControlledShutdownRetryBackoffMs() {
        return this.ControlledShutdownRetryBackoffMs;
    }

    public boolean ControlledShutdownEnable() {
        return this.ControlledShutdownEnable;
    }

    public int GroupMinSessionTimeoutMs() {
        return this.GroupMinSessionTimeoutMs;
    }

    public int GroupMaxSessionTimeoutMs() {
        return this.GroupMaxSessionTimeoutMs;
    }

    public int GroupInitialRebalanceDelayMs() {
        return this.GroupInitialRebalanceDelayMs;
    }

    public int GroupMaxSize() {
        return this.GroupMaxSize;
    }

    public boolean NewGroupCoordinatorEnable() {
        return this.NewGroupCoordinatorEnable;
    }

    public int GroupCoordinatorNumThreads() {
        return this.GroupCoordinatorNumThreads;
    }

    public int ConsumerGroupSessionTimeoutMs() {
        return this.ConsumerGroupSessionTimeoutMs;
    }

    public int ConsumerGroupMinSessionTimeoutMs() {
        return this.ConsumerGroupMinSessionTimeoutMs;
    }

    public int ConsumerGroupMaxSessionTimeoutMs() {
        return this.ConsumerGroupMaxSessionTimeoutMs;
    }

    public int ConsumerGroupHeartbeatIntervalMs() {
        return this.ConsumerGroupHeartbeatIntervalMs;
    }

    public int ConsumerGroupMinHeartbeatIntervalMs() {
        return this.ConsumerGroupMinHeartbeatIntervalMs;
    }

    public int ConsumerGroupMaxHeartbeatIntervalMs() {
        return this.ConsumerGroupMaxHeartbeatIntervalMs;
    }

    public int ConsumerGroupMaxSize() {
        return this.ConsumerGroupMaxSize;
    }

    public java.util.List<String> ConsumerGroupAssignors() {
        return this.ConsumerGroupAssignors;
    }

    public int OffsetMetadataMaxSize() {
        return this.OffsetMetadataMaxSize;
    }

    public int OffsetsLoadBufferSize() {
        return this.OffsetsLoadBufferSize;
    }

    public short OffsetsTopicReplicationFactor() {
        return this.OffsetsTopicReplicationFactor;
    }

    public int OffsetsTopicPartitions() {
        return this.OffsetsTopicPartitions;
    }

    public int OffsetsTopicSegmentBytes() {
        return this.OffsetsTopicSegmentBytes;
    }

    public int OffsetsTopicCompressionCodec() {
        return this.OffsetsTopicCompressionCodec;
    }

    public int OffsetsRetentionMinutes() {
        return this.OffsetsRetentionMinutes;
    }

    public long OffsetsRetentionCheckIntervalMs() {
        return this.OffsetsRetentionCheckIntervalMs;
    }

    public int OffsetCommitTimeoutMs() {
        return this.OffsetCommitTimeoutMs;
    }

    public short OffsetCommitRequiredAcks() {
        return this.OffsetCommitRequiredAcks;
    }

    public int TransactionalIdExpirationMs() {
        return this.TransactionalIdExpirationMs;
    }

    public int TransactionsMaxTimeoutMs() {
        return this.TransactionsMaxTimeoutMs;
    }

    public int TransactionsTopicMinISR() {
        return this.TransactionsTopicMinISR;
    }

    public int TransactionsLoadBufferSize() {
        return this.TransactionsLoadBufferSize;
    }

    public short TransactionsTopicReplicationFactor() {
        return this.TransactionsTopicReplicationFactor;
    }

    public int TransactionsTopicPartitions() {
        return this.TransactionsTopicPartitions;
    }

    public int TransactionsTopicSegmentBytes() {
        return this.TransactionsTopicSegmentBytes;
    }

    public int TransactionsAbortTimedOutTransactionsCleanupIntervalMS() {
        return this.TransactionsAbortTimedOutTransactionsCleanupIntervalMS;
    }

    public int TransactionsRemoveExpiredTransactionsCleanupIntervalMS() {
        return this.TransactionsRemoveExpiredTransactionsCleanupIntervalMS;
    }

    public boolean TransactionPartitionVerificationEnable() {
        return this.TransactionPartitionVerificationEnable;
    }

    public int ProducerIdExpirationMs() {
        return this.ProducerIdExpirationMs;
    }

    public int ProducerIdExpirationCheckIntervalMs() {
        return this.ProducerIdExpirationCheckIntervalMs;
    }

    public int MaxIncrementalFetchSessionCacheSlots() {
        return this.MaxIncrementalFetchSessionCacheSlots;
    }

    public int FetchMaxBytes() {
        return this.FetchMaxBytes;
    }

    public int NumQuotaSamples() {
        return this.NumQuotaSamples;
    }

    public int QuotaWindowSizeSeconds() {
        return this.QuotaWindowSizeSeconds;
    }

    public int NumReplicationQuotaSamples() {
        return this.NumReplicationQuotaSamples;
    }

    public int ReplicationQuotaWindowSizeSeconds() {
        return this.ReplicationQuotaWindowSizeSeconds;
    }

    public int NumAlterLogDirsReplicationQuotaSamples() {
        return this.NumAlterLogDirsReplicationQuotaSamples;
    }

    public int AlterLogDirsReplicationQuotaWindowSizeSeconds() {
        return this.AlterLogDirsReplicationQuotaWindowSizeSeconds;
    }

    public int NumControllerQuotaSamples() {
        return this.NumControllerQuotaSamples;
    }

    public int ControllerQuotaWindowSizeSeconds() {
        return this.ControllerQuotaWindowSizeSeconds;
    }

    public int MetricNumSamples() {
        return this.MetricNumSamples;
    }

    public int MetricSampleWindowMs() {
        return this.MetricSampleWindowMs;
    }

    public String MetricReporterClasses() {
        return this.MetricReporterClasses;
    }

    public String MetricRecordingLevel() {
        return this.MetricRecordingLevel;
    }

    public boolean AutoIncludeJmxReporter() {
        return this.AutoIncludeJmxReporter;
    }

    public String KafkaMetricReporterClasses() {
        return this.KafkaMetricReporterClasses;
    }

    public int KafkaMetricsPollingIntervalSeconds() {
        return this.KafkaMetricsPollingIntervalSeconds;
    }

    public String SslProtocol() {
        return this.SslProtocol;
    }

    public String SslEnabledProtocols() {
        return this.SslEnabledProtocols;
    }

    public String SslKeystoreType() {
        return this.SslKeystoreType;
    }

    public String SslTruststoreType() {
        return this.SslTruststoreType;
    }

    public String SslKeyManagerAlgorithm() {
        return this.SslKeyManagerAlgorithm;
    }

    public String SslTrustManagerAlgorithm() {
        return this.SslTrustManagerAlgorithm;
    }

    public String SslEndpointIdentificationAlgorithm() {
        return this.SslEndpointIdentificationAlgorithm;
    }

    public String SslClientAuthentication() {
        return this.SslClientAuthentication;
    }

    public String[] SslClientAuthenticationValidValues() {
        return this.SslClientAuthenticationValidValues;
    }

    public String SslPrincipalMappingRules() {
        return this.SslPrincipalMappingRules;
    }

    public long ConnectionsMaxReauthMsDefault() {
        return this.ConnectionsMaxReauthMsDefault;
    }

    public int DefaultServerMaxMaxReceiveSize() {
        return this.DefaultServerMaxMaxReceiveSize;
    }

    public Class<DefaultKafkaPrincipalBuilder> DefaultPrincipalBuilder() {
        return this.DefaultPrincipalBuilder;
    }

    public String SaslMechanismInterBrokerProtocol() {
        return this.SaslMechanismInterBrokerProtocol;
    }

    public java.util.List<String> SaslEnabledMechanisms() {
        return this.SaslEnabledMechanisms;
    }

    public String SaslKerberosKinitCmd() {
        return this.SaslKerberosKinitCmd;
    }

    public double SaslKerberosTicketRenewWindowFactor() {
        return this.SaslKerberosTicketRenewWindowFactor;
    }

    public double SaslKerberosTicketRenewJitter() {
        return this.SaslKerberosTicketRenewJitter;
    }

    public long SaslKerberosMinTimeBeforeRelogin() {
        return this.SaslKerberosMinTimeBeforeRelogin;
    }

    public java.util.List<String> SaslKerberosPrincipalToLocalRules() {
        return this.SaslKerberosPrincipalToLocalRules;
    }

    public double SaslLoginRefreshWindowFactor() {
        return this.SaslLoginRefreshWindowFactor;
    }

    public double SaslLoginRefreshWindowJitter() {
        return this.SaslLoginRefreshWindowJitter;
    }

    public short SaslLoginRefreshMinPeriodSeconds() {
        return this.SaslLoginRefreshMinPeriodSeconds;
    }

    public short SaslLoginRefreshBufferSeconds() {
        return this.SaslLoginRefreshBufferSeconds;
    }

    public long SaslLoginRetryBackoffMaxMs() {
        return this.SaslLoginRetryBackoffMaxMs;
    }

    public long SaslLoginRetryBackoffMs() {
        return this.SaslLoginRetryBackoffMs;
    }

    public String SaslOAuthBearerScopeClaimName() {
        return this.SaslOAuthBearerScopeClaimName;
    }

    public String SaslOAuthBearerSubClaimName() {
        return this.SaslOAuthBearerSubClaimName;
    }

    public long SaslOAuthBearerJwksEndpointRefreshMs() {
        return this.SaslOAuthBearerJwksEndpointRefreshMs;
    }

    public long SaslOAuthBearerJwksEndpointRetryBackoffMaxMs() {
        return this.SaslOAuthBearerJwksEndpointRetryBackoffMaxMs;
    }

    public long SaslOAuthBearerJwksEndpointRetryBackoffMs() {
        return this.SaslOAuthBearerJwksEndpointRetryBackoffMs;
    }

    public int SaslOAuthBearerClockSkewSeconds() {
        return this.SaslOAuthBearerClockSkewSeconds;
    }

    public long DelegationTokenMaxLifeTimeMsDefault() {
        return this.DelegationTokenMaxLifeTimeMsDefault;
    }

    public long DelegationTokenExpiryTimeMsDefault() {
        return this.DelegationTokenExpiryTimeMsDefault;
    }

    public long DelegationTokenExpiryCheckIntervalMsDefault() {
        return this.DelegationTokenExpiryCheckIntervalMsDefault;
    }

    public String PasswordEncoderCipherAlgorithm() {
        return this.PasswordEncoderCipherAlgorithm;
    }

    public int PasswordEncoderKeyLength() {
        return this.PasswordEncoderKeyLength;
    }

    public int PasswordEncoderIterations() {
        return this.PasswordEncoderIterations;
    }

    public java.util.List<String> QuorumVoters() {
        return this.QuorumVoters;
    }

    public int QuorumElectionTimeoutMs() {
        return this.QuorumElectionTimeoutMs;
    }

    public int QuorumFetchTimeoutMs() {
        return this.QuorumFetchTimeoutMs;
    }

    public int QuorumElectionBackoffMs() {
        return this.QuorumElectionBackoffMs;
    }

    public int QuorumLingerMs() {
        return this.QuorumLingerMs;
    }

    public int QuorumRequestTimeoutMs() {
        return this.QuorumRequestTimeoutMs;
    }

    public int QuorumRetryBackoffMs() {
        return this.QuorumRetryBackoffMs;
    }

    private Defaults$() {
        MODULE$ = this;
        this.ZkSessionTimeoutMs = 18000;
        this.ZkEnableSecureAcls = false;
        this.ZkMaxInFlightRequests = 10;
        this.ZkSslClientEnable = false;
        this.ZkSslProtocol = "TLSv1.2";
        this.ZkSslEndpointIdentificationAlgorithm = "HTTPS";
        this.ZkSslCrlEnable = false;
        this.ZkSslOcspEnable = false;
        this.BrokerIdGenerationEnable = true;
        this.MaxReservedBrokerId = 1000;
        this.BrokerId = -1;
        this.NumNetworkThreads = 3;
        this.NumIoThreads = 8;
        this.BackgroundThreads = 10;
        this.QueuedMaxRequests = 500;
        this.QueuedMaxRequestBytes = -1;
        this.InitialBrokerRegistrationTimeoutMs = 60000;
        this.BrokerHeartbeatIntervalMs = 2000;
        this.BrokerSessionTimeoutMs = 9000;
        this.MetadataSnapshotMaxNewRecordBytes = 0x1400000;
        this.MetadataSnapshotMaxIntervalMs = TimeUnit.HOURS.toMillis(1L);
        this.MetadataMaxIdleIntervalMs = 500;
        this.MetadataMaxRetentionBytes = 0x6400000;
        this.DeleteTopicEnable = true;
        this.EmptyNodeId = -1;
        this.ServerMaxStartupTimeMs = Long.MAX_VALUE;
        this.AuthorizerClassName = "";
        this.Listeners = "PLAINTEXT://:9092";
        this.ListenerSecurityProtocolMap = ((TraversableOnce)EndPoint$.MODULE$.DefaultSecurityProtocolMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                ListenerName listenerName = (ListenerName)x0$1._1();
                SecurityProtocol securityProtocol = (SecurityProtocol)x0$1._2();
                return new StringBuilder(1).append(listenerName.value()).append(":").append(securityProtocol.name).toString();
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        this.SocketSendBufferBytes = 102400;
        this.SocketReceiveBufferBytes = 102400;
        this.SocketRequestMaxBytes = 0x6400000;
        this.SocketListenBacklogSize = 50;
        this.MaxConnectionsPerIp = Integer.MAX_VALUE;
        this.MaxConnectionsPerIpOverrides = "";
        this.MaxConnections = Integer.MAX_VALUE;
        this.MaxConnectionCreationRate = Integer.MAX_VALUE;
        this.ConnectionsMaxIdleMs = 600000L;
        this.RequestTimeoutMs = 30000;
        this.ConnectionSetupTimeoutMs = CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS;
        this.ConnectionSetupTimeoutMaxMs = CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS;
        this.FailedAuthenticationDelayMs = 100;
        this.NumPartitions = 1;
        this.LogDir = "/tmp/kafka-logs";
        this.LogCleanupIntervalMs = 300000L;
        this.LogCleanerThreads = 1;
        this.LogCleanerIoMaxBytesPerSecond = Double.MAX_VALUE;
        this.LogCleanerDedupeBufferSize = 0x8000000L;
        this.LogCleanerIoBufferSize = 524288;
        this.LogCleanerDedupeBufferLoadFactor = 0.9;
        this.LogCleanerBackoffMs = 15000;
        this.LogCleanerEnable = true;
        this.LogFlushOffsetCheckpointIntervalMs = 60000;
        this.LogFlushStartOffsetCheckpointIntervalMs = 60000;
        this.NumRecoveryThreadsPerDataDir = 1;
        this.AutoCreateTopicsEnable = true;
        this.ControllerSocketTimeoutMs = this.RequestTimeoutMs();
        this.DefaultReplicationFactor = 1;
        this.ReplicaLagTimeMaxMs = 30000L;
        this.ReplicaSocketTimeoutMs = 30000;
        this.ReplicaSocketReceiveBufferBytes = 65536;
        this.ReplicaFetchMaxBytes = 0x100000;
        this.ReplicaFetchWaitMaxMs = 500;
        this.ReplicaFetchMinBytes = 1;
        this.ReplicaFetchResponseMaxBytes = 0xA00000;
        this.NumReplicaFetchers = 1;
        this.ReplicaFetchBackoffMs = 1000;
        this.ReplicaHighWatermarkCheckpointIntervalMs = 5000L;
        this.FetchPurgatoryPurgeIntervalRequests = 1000;
        this.ProducerPurgatoryPurgeIntervalRequests = 1000;
        this.DeleteRecordsPurgatoryPurgeIntervalRequests = 1;
        this.AutoLeaderRebalanceEnable = true;
        this.LeaderImbalancePerBrokerPercentage = 10;
        this.LeaderImbalanceCheckIntervalSeconds = 300;
        this.InterBrokerSecurityProtocol = SecurityProtocol.PLAINTEXT.toString();
        this.InterBrokerProtocolVersion = MetadataVersion.latest().version();
        this.ControlledShutdownMaxRetries = 3;
        this.ControlledShutdownRetryBackoffMs = 5000;
        this.ControlledShutdownEnable = true;
        this.GroupMinSessionTimeoutMs = 6000;
        this.GroupMaxSessionTimeoutMs = 1800000;
        this.GroupInitialRebalanceDelayMs = 3000;
        this.GroupMaxSize = Integer.MAX_VALUE;
        this.NewGroupCoordinatorEnable = false;
        this.GroupCoordinatorNumThreads = 1;
        this.ConsumerGroupSessionTimeoutMs = 45000;
        this.ConsumerGroupMinSessionTimeoutMs = 45000;
        this.ConsumerGroupMaxSessionTimeoutMs = 60000;
        this.ConsumerGroupHeartbeatIntervalMs = 5000;
        this.ConsumerGroupMinHeartbeatIntervalMs = 5000;
        this.ConsumerGroupMaxHeartbeatIntervalMs = 15000;
        this.ConsumerGroupMaxSize = Integer.MAX_VALUE;
        this.ConsumerGroupAssignors = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)RangeAssignor.class.getName(), (List)Nil$.MODULE$)).asJava();
        this.OffsetMetadataMaxSize = OffsetConfig$.MODULE$.DefaultMaxMetadataSize();
        this.OffsetsLoadBufferSize = OffsetConfig$.MODULE$.DefaultLoadBufferSize();
        this.OffsetsTopicReplicationFactor = OffsetConfig$.MODULE$.DefaultOffsetsTopicReplicationFactor();
        this.OffsetsTopicPartitions = OffsetConfig$.MODULE$.DefaultOffsetsTopicNumPartitions();
        this.OffsetsTopicSegmentBytes = OffsetConfig$.MODULE$.DefaultOffsetsTopicSegmentBytes();
        this.OffsetsTopicCompressionCodec = OffsetConfig$.MODULE$.DefaultOffsetsTopicCompressionType().id;
        this.OffsetsRetentionMinutes = 10080;
        this.OffsetsRetentionCheckIntervalMs = OffsetConfig$.MODULE$.DefaultOffsetsRetentionCheckIntervalMs();
        this.OffsetCommitTimeoutMs = OffsetConfig$.MODULE$.DefaultOffsetCommitTimeoutMs();
        this.OffsetCommitRequiredAcks = OffsetConfig$.MODULE$.DefaultOffsetCommitRequiredAcks();
        this.TransactionalIdExpirationMs = TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
        this.TransactionsMaxTimeoutMs = TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
        this.TransactionsTopicMinISR = TransactionLog$.MODULE$.DefaultMinInSyncReplicas();
        this.TransactionsLoadBufferSize = TransactionLog$.MODULE$.DefaultLoadBufferSize();
        this.TransactionsTopicReplicationFactor = TransactionLog$.MODULE$.DefaultReplicationFactor();
        this.TransactionsTopicPartitions = TransactionLog$.MODULE$.DefaultNumPartitions();
        this.TransactionsTopicSegmentBytes = TransactionLog$.MODULE$.DefaultSegmentBytes();
        this.TransactionsAbortTimedOutTransactionsCleanupIntervalMS = TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
        this.TransactionsRemoveExpiredTransactionsCleanupIntervalMS = TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
        this.TransactionPartitionVerificationEnable = true;
        this.ProducerIdExpirationMs = 86400000;
        this.ProducerIdExpirationCheckIntervalMs = 600000;
        this.MaxIncrementalFetchSessionCacheSlots = 1000;
        this.FetchMaxBytes = 0x3700000;
        this.NumQuotaSamples = ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        this.QuotaWindowSizeSeconds = ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        this.NumReplicationQuotaSamples = ReplicationQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        this.ReplicationQuotaWindowSizeSeconds = ReplicationQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        this.NumAlterLogDirsReplicationQuotaSamples = ReplicationQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        this.AlterLogDirsReplicationQuotaWindowSizeSeconds = ReplicationQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        this.NumControllerQuotaSamples = ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        this.ControllerQuotaWindowSizeSeconds = ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        this.MetricNumSamples = 2;
        this.MetricSampleWindowMs = 30000;
        this.MetricReporterClasses = "";
        this.MetricRecordingLevel = Sensor.RecordingLevel.INFO.toString();
        this.AutoIncludeJmxReporter = true;
        this.KafkaMetricReporterClasses = "";
        this.KafkaMetricsPollingIntervalSeconds = 10;
        this.SslProtocol = SslConfigs.DEFAULT_SSL_PROTOCOL;
        this.SslEnabledProtocols = SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS;
        this.SslKeystoreType = "JKS";
        this.SslTruststoreType = "JKS";
        this.SslKeyManagerAlgorithm = SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM;
        this.SslTrustManagerAlgorithm = SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM;
        this.SslEndpointIdentificationAlgorithm = "https";
        this.SslClientAuthentication = SslClientAuth.NONE.name().toLowerCase(Locale.ROOT);
        this.SslClientAuthenticationValidValues = (String[])((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(SslClientAuth.VALUES).asScala()).map((Function1 & Serializable & scala.Serializable)v -> v.toString().toLowerCase(Locale.ROOT), Buffer$.MODULE$.canBuildFrom())).asJava()).toArray((Object[])new String[0]);
        this.SslPrincipalMappingRules = "DEFAULT";
        this.ConnectionsMaxReauthMsDefault = 0L;
        this.DefaultServerMaxMaxReceiveSize = 524288;
        this.DefaultPrincipalBuilder = DefaultKafkaPrincipalBuilder.class;
        this.SaslMechanismInterBrokerProtocol = "GSSAPI";
        this.SaslEnabledMechanisms = BrokerSecurityConfigs.DEFAULT_SASL_ENABLED_MECHANISMS;
        this.SaslKerberosKinitCmd = "/usr/bin/kinit";
        this.SaslKerberosTicketRenewWindowFactor = 0.8;
        this.SaslKerberosTicketRenewJitter = 0.05;
        this.SaslKerberosMinTimeBeforeRelogin = 60000L;
        this.SaslKerberosPrincipalToLocalRules = BrokerSecurityConfigs.DEFAULT_SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES;
        this.SaslLoginRefreshWindowFactor = 0.8;
        this.SaslLoginRefreshWindowJitter = 0.05;
        this.SaslLoginRefreshMinPeriodSeconds = (short)60;
        this.SaslLoginRefreshBufferSeconds = (short)300;
        this.SaslLoginRetryBackoffMaxMs = 10000L;
        this.SaslLoginRetryBackoffMs = 100L;
        this.SaslOAuthBearerScopeClaimName = "scope";
        this.SaslOAuthBearerSubClaimName = "sub";
        this.SaslOAuthBearerJwksEndpointRefreshMs = 3600000L;
        this.SaslOAuthBearerJwksEndpointRetryBackoffMaxMs = 10000L;
        this.SaslOAuthBearerJwksEndpointRetryBackoffMs = 100L;
        this.SaslOAuthBearerClockSkewSeconds = 30;
        this.DelegationTokenMaxLifeTimeMsDefault = 604800000L;
        this.DelegationTokenExpiryTimeMsDefault = 86400000L;
        this.DelegationTokenExpiryCheckIntervalMsDefault = 3600000L;
        this.PasswordEncoderCipherAlgorithm = "AES/CBC/PKCS5Padding";
        this.PasswordEncoderKeyLength = 128;
        this.PasswordEncoderIterations = 4096;
        this.QuorumVoters = RaftConfig.DEFAULT_QUORUM_VOTERS;
        this.QuorumElectionTimeoutMs = 1000;
        this.QuorumFetchTimeoutMs = 2000;
        this.QuorumElectionBackoffMs = 1000;
        this.QuorumLingerMs = 25;
        this.QuorumRequestTimeoutMs = 2000;
        this.QuorumRetryBackoffMs = 20;
    }
}

