/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.FlattenedIterator;
import org.apache.kafka.common.utils.Utils;

public class UpdateMetadataRequest
extends AbstractControlRequest {
    private final UpdateMetadataRequestData data;

    UpdateMetadataRequest(UpdateMetadataRequestData data, short version) {
        super(ApiKeys.UPDATE_METADATA, version);
        this.data = data;
        this.normalize();
    }

    private void normalize() {
        if (this.version() < 3) {
            for (UpdateMetadataRequestData.UpdateMetadataBroker liveBroker : this.data.liveBrokers()) {
                if (this.version() == 0 && liveBroker.endpoints().isEmpty()) {
                    SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                    liveBroker.setEndpoints(Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(liveBroker.v0Host()).setPort(liveBroker.v0Port()).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol(securityProtocol).value())));
                    continue;
                }
                for (UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint : liveBroker.endpoints()) {
                    if (!endpoint.listener().isEmpty()) continue;
                    endpoint.setListener(UpdateMetadataRequest.listenerNameFromSecurityProtocol(endpoint));
                }
            }
        }
        if (this.version() >= 5) {
            for (UpdateMetadataRequestData.UpdateMetadataTopicState topicState : this.data.topicStates()) {
                for (UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState : topicState.partitionStates()) {
                    partitionState.setTopicName(topicState.topicName());
                }
            }
        }
    }

    private static String listenerNameFromSecurityProtocol(UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint) {
        SecurityProtocol securityProtocol = SecurityProtocol.forId(endpoint.securityProtocol());
        return ListenerName.forSecurityProtocol(securityProtocol).value();
    }

    @Override
    public int controllerId() {
        return this.data.controllerId();
    }

    @Override
    public boolean isKRaftController() {
        return this.data.isKRaftController();
    }

    public AbstractControlRequest.Type updateType() {
        return AbstractControlRequest.Type.fromByte(this.data.type());
    }

    @Override
    public int controllerEpoch() {
        return this.data.controllerEpoch();
    }

    @Override
    public long brokerEpoch() {
        return this.data.brokerEpoch();
    }

    @Override
    public UpdateMetadataResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        UpdateMetadataResponseData data = new UpdateMetadataResponseData().setErrorCode(Errors.forException(e).code());
        return new UpdateMetadataResponse(data);
    }

    public Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        if (this.version() >= 5) {
            return () -> new FlattenedIterator(this.data.topicStates().iterator(), topicState -> topicState.partitionStates().iterator());
        }
        return this.data.ungroupedPartitionStates();
    }

    public List<UpdateMetadataRequestData.UpdateMetadataTopicState> topicStates() {
        if (this.version() >= 5) {
            return this.data.topicStates();
        }
        return Collections.emptyList();
    }

    public List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers() {
        return this.data.liveBrokers();
    }

    @Override
    public UpdateMetadataRequestData data() {
        return this.data;
    }

    public static UpdateMetadataRequest parse(ByteBuffer buffer, short version) {
        return new UpdateMetadataRequest(new UpdateMetadataRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractControlRequest.Builder<UpdateMetadataRequest> {
        private final List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates;
        private final List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers;
        private final Map<String, Uuid> topicIds;
        private final AbstractControlRequest.Type updateType;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates, List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers, Map<String, Uuid> topicIds) {
            this(version, controllerId, controllerEpoch, brokerEpoch, partitionStates, liveBrokers, topicIds, false, AbstractControlRequest.Type.UNKNOWN);
        }

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates, List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers, Map<String, Uuid> topicIds, boolean kraftController, AbstractControlRequest.Type updateType) {
            super(ApiKeys.UPDATE_METADATA, version, controllerId, controllerEpoch, brokerEpoch, kraftController);
            this.partitionStates = partitionStates;
            this.liveBrokers = liveBrokers;
            this.topicIds = topicIds;
            this.updateType = version >= 8 ? updateType : AbstractControlRequest.Type.UNKNOWN;
        }

        @Override
        public UpdateMetadataRequest build(short version) {
            if (version < 3) {
                for (UpdateMetadataRequestData.UpdateMetadataBroker broker : this.liveBrokers) {
                    if (version == 0) {
                        if (broker.endpoints().size() != 1) {
                            throw new UnsupportedVersionException("UpdateMetadataRequest v0 requires a single endpoint");
                        }
                        if (broker.endpoints().get(0).securityProtocol() != SecurityProtocol.PLAINTEXT.id) {
                            throw new UnsupportedVersionException("UpdateMetadataRequest v0 only handles PLAINTEXT endpoints");
                        }
                        UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint2 = broker.endpoints().get(0);
                        broker.setV0Host(endpoint2.host());
                        broker.setV0Port(endpoint2.port());
                        continue;
                    }
                    if (!broker.endpoints().stream().anyMatch(endpoint -> !endpoint.listener().isEmpty() && !endpoint.listener().equals(UpdateMetadataRequest.listenerNameFromSecurityProtocol(endpoint)))) continue;
                    throw new UnsupportedVersionException("UpdateMetadataRequest v0-v3 does not support custom listeners, request version: " + version + ", endpoints: " + broker.endpoints());
                }
            }
            UpdateMetadataRequestData data = new UpdateMetadataRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch).setLiveBrokers(this.liveBrokers);
            if (version >= 8) {
                data.setIsKRaftController(this.kraftController);
                data.setType(this.updateType.toByte());
            }
            if (version >= 5) {
                Map<String, UpdateMetadataRequestData.UpdateMetadataTopicState> topicStatesMap = Builder.groupByTopic(this.topicIds, this.partitionStates);
                data.setTopicStates(new ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState>(topicStatesMap.values()));
            } else {
                data.setUngroupedPartitionStates(this.partitionStates);
            }
            return new UpdateMetadataRequest(data, version);
        }

        private static Map<String, UpdateMetadataRequestData.UpdateMetadataTopicState> groupByTopic(Map<String, Uuid> topicIds, List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates) {
            HashMap<String, UpdateMetadataRequestData.UpdateMetadataTopicState> topicStates = new HashMap<String, UpdateMetadataRequestData.UpdateMetadataTopicState>();
            for (UpdateMetadataRequestData.UpdateMetadataPartitionState partition : partitionStates) {
                UpdateMetadataRequestData.UpdateMetadataTopicState topicState = topicStates.computeIfAbsent(partition.topicName(), t -> new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(partition.topicName()).setTopicId(topicIds.getOrDefault(partition.topicName(), Uuid.ZERO_UUID)));
                topicState.partitionStates().add(partition);
            }
            return topicStates;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: UpdateMetadataRequest=").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", kraftController=").append(this.kraftController).append(", type=").append((Object)this.updateType).append(", brokerEpoch=").append(this.brokerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveBrokers=").append(Utils.join(this.liveBrokers, ", ")).append(")");
            return bld.toString();
        }
    }
}

