/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generic;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.utils.Bytes;

public class GenericGroupMember {
    public static final byte[] EMPTY_ASSIGNMENT = Bytes.EMPTY;
    private final String memberId;
    private final Optional<String> groupInstanceId;
    private final String clientId;
    private final String clientHost;
    private int rebalanceTimeoutMs;
    private int sessionTimeoutMs;
    private final String protocolType;
    private JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedProtocols;
    private byte[] assignment;
    private CompletableFuture<JoinGroupResponseData> awaitingJoinFuture = null;
    private CompletableFuture<SyncGroupResponseData> awaitingSyncFuture = null;
    private boolean isNew = false;

    public GenericGroupMember(String memberId, Optional<String> groupInstanceId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, String protocolType, JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedProtocols) {
        this(memberId, groupInstanceId, clientId, clientHost, rebalanceTimeoutMs, sessionTimeoutMs, protocolType, supportedProtocols, EMPTY_ASSIGNMENT);
    }

    public GenericGroupMember(String memberId, Optional<String> groupInstanceId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, String protocolType, JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedProtocols, byte[] assignment) {
        this.memberId = memberId;
        this.groupInstanceId = groupInstanceId;
        this.clientId = clientId;
        this.clientHost = clientHost;
        this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.protocolType = protocolType;
        this.supportedProtocols = supportedProtocols;
        this.assignment = assignment;
    }

    public boolean isStaticMember() {
        return this.groupInstanceId.isPresent();
    }

    public boolean isAwaitingJoin() {
        return this.awaitingJoinFuture != null;
    }

    public boolean isAwaitingSync() {
        return this.awaitingSyncFuture != null;
    }

    public byte[] metadata(String protocolName) {
        for (JoinGroupRequestData.JoinGroupRequestProtocol protocol : this.supportedProtocols) {
            if (!protocol.name().equals(protocolName)) continue;
            return protocol.metadata();
        }
        throw new IllegalArgumentException("Member does not support protocol " + protocolName);
    }

    public boolean hasSatisfiedHeartbeat() {
        if (this.isNew) {
            return false;
        }
        return this.isAwaitingJoin() || this.isAwaitingSync();
    }

    public boolean matches(JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols) {
        return protocols.equals((Object)this.supportedProtocols);
    }

    public String vote(Set<String> candidates) {
        for (JoinGroupRequestData.JoinGroupRequestProtocol protocol : this.supportedProtocols) {
            if (!candidates.contains(protocol.name())) continue;
            return protocol.name();
        }
        throw new IllegalArgumentException("Member does not support any of the candidate protocols");
    }

    public static Set<String> plainProtocolSet(JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedProtocols) {
        HashSet<String> protocolNames = new HashSet<String>();
        for (JoinGroupRequestData.JoinGroupRequestProtocol protocol : supportedProtocols) {
            protocolNames.add(protocol.name());
        }
        return protocolNames;
    }

    public boolean hasAssignment() {
        return this.assignment != null && this.assignment.length > 0;
    }

    public String memberId() {
        return this.memberId;
    }

    public Optional<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedProtocols() {
        return this.supportedProtocols;
    }

    public byte[] assignment() {
        return this.assignment;
    }

    public CompletableFuture<JoinGroupResponseData> awaitingJoinFuture() {
        return this.awaitingJoinFuture;
    }

    public CompletableFuture<SyncGroupResponseData> awaitingSyncFuture() {
        return this.awaitingSyncFuture;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setRebalanceTimeoutMs(int value) {
        this.rebalanceTimeoutMs = value;
    }

    public void setSessionTimeoutMs(int value) {
        this.sessionTimeoutMs = value;
    }

    public void setSupportedProtocols(JoinGroupRequestData.JoinGroupRequestProtocolCollection value) {
        this.supportedProtocols = value;
    }

    public void setAssignment(byte[] value) {
        this.assignment = value;
    }

    public void setAwaitingJoinFuture(CompletableFuture<JoinGroupResponseData> value) {
        this.awaitingJoinFuture = value;
    }

    public void setAwaitingSyncFuture(CompletableFuture<SyncGroupResponseData> value) {
        this.awaitingSyncFuture = value;
    }

    public void setIsNew(boolean value) {
        this.isNew = value;
    }

    public String toString() {
        return "GenericGroupMember(memberId='" + this.memberId + '\'' + ", groupInstanceId='" + this.groupInstanceId.orElse("") + '\'' + ", clientId='" + this.clientId + '\'' + ", clientHost='" + this.clientHost + '\'' + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", sessionTimeoutMs=" + this.sessionTimeoutMs + ", protocolType='" + this.protocolType + '\'' + ", supportedProtocols=" + this.supportedProtocols.stream().map(JoinGroupRequestData.JoinGroupRequestProtocol::name).collect(Collectors.toList()) + ')';
    }
}

