/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerMetadataException;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.MetaProperties$;
import kafka.server.RawMetaProperties;
import kafka.server.RawMetaProperties$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BrokerMetadataCheckpoint$
implements Logging {
    public static BrokerMetadataCheckpoint$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new BrokerMetadataCheckpoint$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Tuple2<RawMetaProperties, Seq<String>> getBrokerMetadataAndOfflineDirs(Seq<String> logDirs, boolean ignoreMissing, boolean kraftMode) {
        Predef$.MODULE$.require(logDirs.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Must have at least one log dir to read meta.properties");
        HashMap brokerMetadataMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer offlineDirs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            BoxedUnit boxedUnit;
            block7: {
                File brokerCheckpointFile = new File((String)logDir, "meta.properties");
                try {
                    Option<Properties> option = new BrokerMetadataCheckpoint(brokerCheckpointFile).read();
                    if (option instanceof Some) {
                        Properties properties = (Properties)((Some)option).value();
                        boxedUnit = brokerMetadataMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(logDir), (Object)properties));
                        break block7;
                    }
                    if (None$.MODULE$.equals(option)) {
                        if (!ignoreMissing) {
                            throw new KafkaException(new StringBuilder(89).append("No `meta.properties` found in ").append((String)logDir).append(" ").append("(have you run `kafka-storage.sh` to format the directory?)").toString());
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    throw new MatchError(option);
                }
                catch (IOException e) {
                    offlineDirs.$plus$eq(logDir);
                    BrokerMetadataCheckpoint$ brokerMetadataCheckpoint$ = MODULE$;
                    if (brokerMetadataCheckpoint$ == null) {
                        throw null;
                    }
                    BrokerMetadataCheckpoint$ error_this = brokerMetadataCheckpoint$;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent(BrokerMetadataCheckpoint$.$anonfun$getBrokerMetadataAndOfflineDirs$3(brokerCheckpointFile)), (Throwable)e);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
        if (brokerMetadataMap.isEmpty()) {
            return new Tuple2((Object)new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1()), (Object)offlineDirs);
        }
        if ((kraftMode ? ((TraversableOnce)brokerMetadataMap.values().map((Function1 & Serializable & scala.Serializable)props -> MetaProperties$.MODULE$.parse(new RawMetaProperties((Properties)props)), Iterable$.MODULE$.canBuildFrom())).toSet().size() : brokerMetadataMap.values().toSet().size()) > 1) {
            scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
            brokerMetadataMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerMetadataCheckpoint$.$anonfun$getBrokerMetadataAndOfflineDirs$6(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                if (x$1 != null) {
                    String logDir = (String)x$1._1();
                    Properties brokerMetadata = (Properties)x$1._2();
                    return builder.$plus$plus$eq(new StringBuilder(7).append("- ").append(logDir).append(" -> ").append(brokerMetadata).append("\n").toString());
                }
                throw new MatchError(null);
            });
            throw new InconsistentBrokerMetadataException(new StringBuilder(186).append("BrokerMetadata is not consistent across log.dirs. This could happen if multiple brokers shared a log directory (log.dirs) ").append("or partial data was manually copied from another broker. Found:\n").append(builder.toString()).toString());
        }
        RawMetaProperties rawProps = new RawMetaProperties((Properties)((Tuple2)brokerMetadataMap.head())._2());
        return new Tuple2((Object)rawProps, (Object)offlineDirs);
    }

    public static final /* synthetic */ String $anonfun$getBrokerMetadataAndOfflineDirs$3(File brokerCheckpointFile$1) {
        return new StringBuilder(15).append("Failed to read ").append(brokerCheckpointFile$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadataAndOfflineDirs$6(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    private BrokerMetadataCheckpoint$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

