/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kafka.coordinator.group.ListenerAdapter;
import kafka.server.ActionQueue;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.PartitionWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0006\r\u0001MA\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007\"B6\u0001\t\u0003b\u0007\"B>\u0001\t\u0003b\bBB@\u0001\t\u0003\n\tA\u0001\u000eD_>\u0014H-\u001b8bi>\u0014\b+\u0019:uSRLwN\\,sSR,'O\u0003\u0002\u000e\u001d\u0005)qM]8va*\u0011q\u0002E\u0001\fG>|'\u000fZ5oCR|'OC\u0001\u0012\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"\u0001\u0006\u0017\u0014\u0007\u0001)R\u0004\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005!A.\u00198h\u0015\u0005Q\u0012\u0001\u00026bm\u0006L!\u0001H\f\u0003\r=\u0013'.Z2u!\rq\u0002FK\u0007\u0002?)\u0011\u0001%I\u0001\beVtG/[7f\u0015\ti!E\u0003\u0002\u0010G)\u0011\u0011\u0003\n\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014x-\u0003\u0002*?\ty\u0001+\u0019:uSRLwN\\,sSR,'\u000f\u0005\u0002,Y1\u0001A!B\u0017\u0001\u0005\u0004q#!\u0001+\u0012\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$a\u0002(pi\"Lgn\u001a\t\u0003aYJ!aN\u0019\u0003\u0007\u0005s\u00170\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0002\u0012AB:feZ,'/\u0003\u0002?w\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018AC:fe&\fG.\u001b>feB\u0019\u0011\t\u0012\u0016\u000f\u0005y\u0011\u0015BA\" \u0003=\u0001\u0016M\u001d;ji&|gn\u0016:ji\u0016\u0014\u0018BA#G\u0005)\u0019VM]5bY&TXM\u001d\u0006\u0003\u0007~\tqbY8naJ,7o]5p]RK\b/\u001a\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000baA]3d_J$'BA'$\u0003\u0019\u0019w.\\7p]&\u0011qJ\u0013\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\u0006!A/[7f!\t\u0011V+D\u0001T\u0015\t!F*A\u0003vi&d7/\u0003\u0002W'\n!A+[7f\u0003\u0019a\u0014N\\5u}Q)\u0011l\u0017/^=B\u0019!\f\u0001\u0016\u000e\u00031AQ\u0001O\u0003A\u0002eBQaP\u0003A\u0002\u0001CQaR\u0003A\u0002!CQ\u0001U\u0003A\u0002E\u000b\u0011\u0003Z5sK\u000e$\u0018i\u0019;j_:\fV/Z;f+\u0005\t'c\u00012fQ\u001a!1m\u0002\u0001b\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003I!\u0017N]3di\u0006\u001bG/[8o#V,W/\u001a\u0011\u0011\u0005A2\u0017BA42\u0005\u0019\te.\u001f*fMB\u0011!([\u0005\u0003Un\u00121\"Q2uS>t\u0017+^3vK\u0006\u0001\"/Z4jgR,'\u000fT5ti\u0016tWM\u001d\u000b\u0004[B4\bC\u0001\u0019o\u0013\ty\u0017G\u0001\u0003V]&$\b\"B9\t\u0001\u0004\u0011\u0018A\u0001;q!\t\u0019H/D\u0001M\u0013\t)HJ\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b]D\u0001\u0019\u0001=\u0002\u00111L7\u000f^3oKJ\u0004\"!Q=\n\u0005i4%\u0001\u0003'jgR,g.\u001a:\u0002%\u0011,'/Z4jgR,'\u000fT5ti\u0016tWM\u001d\u000b\u0004[vt\b\"B9\n\u0001\u0004\u0011\b\"B<\n\u0001\u0004A\u0018AB1qa\u0016tG\r\u0006\u0004\u0002\u0004\u0005%\u00111\u0002\t\u0004a\u0005\u0015\u0011bAA\u0004c\t!Aj\u001c8h\u0011\u0015\t(\u00021\u0001s\u0011\u001d\tiA\u0003a\u0001\u0003\u001f\tqA]3d_J$7\u000fE\u0003\u0002\u0012\u0005]!&\u0004\u0002\u0002\u0014)\u0019\u0011QC\r\u0002\tU$\u0018\u000e\\\u0005\u0005\u00033\t\u0019B\u0001\u0003MSN$\b")
public class CoordinatorPartitionWriter<T>
implements PartitionWriter<T> {
    private final ReplicaManager replicaManager;
    private final PartitionWriter.Serializer<T> serializer;
    private final CompressionType compressionType;
    private final Time time;
    private final ActionQueue directActionQueue;

    private ActionQueue directActionQueue() {
        return this.directActionQueue;
    }

    public void registerListener(TopicPartition tp, PartitionWriter.Listener listener) {
        this.replicaManager.maybeAddListener(tp, new ListenerAdapter(listener));
    }

    public void deregisterListener(TopicPartition tp, PartitionWriter.Listener listener) {
        this.replicaManager.removeListener(tp, new ListenerAdapter(listener));
    }

    public long append(TopicPartition tp, List<T> records) {
        if (records.isEmpty()) {
            throw new IllegalStateException("records must be non-empty.");
        }
        Option<LogConfig> option = this.replicaManager.getLogConfig(tp);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            byte magic = logConfig.recordVersion().value;
            int maxBatchSize = logConfig.maxMessageSize();
            long currentTimeMs = this.time.milliseconds();
            MemoryRecordsBuilder recordsBuilder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, maxBatchSize)), (byte)magic, (CompressionType)this.compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)maxBatchSize);
            records.forEach(record -> {
                byte[] valueBytes;
                byte[] keyBytes = $this.serializer.serializeKey(record);
                if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, valueBytes = $this.serializer.serializeValue(record), Record.EMPTY_HEADERS)) {
                    recordsBuilder.append(currentTimeMs, keyBytes, valueBytes, Record.EMPTY_HEADERS);
                    return;
                }
                throw new RecordTooLargeException(new StringBuilder(99).append("Message batch size is ").append(recordsBuilder.estimatedSizeInBytes()).append(" bytes ").append("in append to partition ").append(tp).append(" which exceeds the maximum configured size of ").append(maxBatchSize).append(".").toString());
            });
            ObjectRef appendResults = ObjectRef.create((Object)Map$.MODULE$.empty());
            long x$1 = 0L;
            short x$2 = 1;
            boolean x$3 = true;
            AppendOrigin x$4 = AppendOrigin.COORDINATOR;
            Map x$5 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)recordsBuilder.build())}));
            Function1 & Serializable & scala.Serializable x$6 = (Function1 & Serializable & scala.Serializable)results -> {
                appendResults.elem = results;
                return BoxedUnit.UNIT;
            };
            ActionQueue x$7 = this.directActionQueue();
            Option<Lock> x$8 = this.replicaManager.appendRecords$default$7();
            Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = this.replicaManager.appendRecords$default$8();
            RequestLocal x$10 = this.replicaManager.appendRecords$default$9();
            String x$11 = this.replicaManager.appendRecords$default$10();
            Option<Object> x$12 = this.replicaManager.appendRecords$default$11();
            this.replicaManager.appendRecords(x$1, x$2, x$3, x$4, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$10, x$11, x$12, x$7);
            ProduceResponse.PartitionResponse partitionResult = (ProduceResponse.PartitionResponse)((Map)appendResults.elem).getOrElse((Object)tp, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(38).append("Append status ").append((Map)appendResults$1.elem).append(" should have partition ").append(tp).append(".").toString());
            });
            Errors errors = partitionResult.error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                throw partitionResult.error.exception();
            }
            return partitionResult.lastOffset + 1L;
        }
        if (None$.MODULE$.equals(option)) {
            throw Errors.NOT_LEADER_OR_FOLLOWER.exception();
        }
        throw new MatchError(option);
    }

    public CoordinatorPartitionWriter(ReplicaManager replicaManager, PartitionWriter.Serializer<T> serializer, CompressionType compressionType, Time time) {
        this.replicaManager = replicaManager;
        this.serializer = serializer;
        this.compressionType = compressionType;
        this.time = time;
        this.directActionQueue = new ActionQueue(null){

            public void add(Function0<BoxedUnit> action) {
                action.apply$mcV$sp();
            }

            public void tryCompleteActions() {
            }
        };
    }
}

