/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import kafka.api.LeaderAndIsr$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.server.ConfigType$;
import kafka.utils.Logging;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.TopicPartitionsZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001B\t\u0013\u0001eA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\u0006}\u0001!\te\u0010\u0005\u0006Q\u0002!\t%\u001b\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u0010\u0001\t\u0013\t)\u0006C\u0004\u0002\\\u0001!\t%!\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002H\u0002!I!!3\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\n1\"l\u001b+pa&\u001cW*[4sCRLwN\\\"mS\u0016tGO\u0003\u0002\u0014)\u0005IQ.[4sCRLwN\u001c\u0006\u0003+Y\t!A_6\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u00015\tr\u0003CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011a\u0017M\\4\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\rbS\"\u0001\u0013\u000b\u0005M)#B\u0001\u0014(\u0003!iW\r^1eCR\f'BA\f)\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\n\u00055\"#\u0001\u0006+pa&\u001cW*[4sCRLwN\\\"mS\u0016tG\u000f\u0005\u00020e5\t\u0001G\u0003\u00022-\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003!Q8n\u00117jK:$\bC\u0001\u001c8\u001b\u0005!\u0012B\u0001\u001d\u0015\u00055Y\u0015MZ6b5.\u001cE.[3oi\u00061A(\u001b8jiz\"\"aO\u001f\u0011\u0005q\u0002Q\"\u0001\n\t\u000bQ\u0012\u0001\u0019A\u001b\u0002\u001b%$XM]1uKR{\u0007/[2t)\r\u0001eI\u0019\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0005+:LG\u000fC\u0003H\u0007\u0001\u0007\u0001*A\u0005j]R,'/Z:ugB\u0019\u0011\n\u0014(\u000e\u0003)S!a\u0013\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003\u001b*\u0013q!\u00128v[N+G\u000f\u0005\u0002P?:\u0011\u0001+\u0018\b\u0003#rs!AU.\u000f\u0005MSfB\u0001+Z\u001d\t)\u0006,D\u0001W\u0015\t9\u0006$\u0001\u0004=e>|GOP\u0005\u0002W%\u0011\u0011FK\u0005\u0003/!J!AJ\u0014\n\u0005M)\u0013B\u00010%\u0003Q!v\u000e]5d\u001b&<'/\u0019;j_:\u001cE.[3oi&\u0011\u0001-\u0019\u0002\u0015)>\u0004\u0018n\u0019,jg&$xN]%oi\u0016\u0014Xm\u001d;\u000b\u0005y#\u0003\"B2\u0004\u0001\u0004!\u0017a\u0002<jg&$xN\u001d\t\u0003K\u001at!aI/\n\u0005\u001d\f'\u0001\u0004+pa&\u001cg+[:ji>\u0014\u0018aC2sK\u0006$X\rV8qS\u000e$bA[7x\u007f\u0006]\u0001CA\u0012l\u0013\taGE\u0001\u000e[W6KwM]1uS>tG*Z1eKJ\u001c\b.\u001b9Ti\u0006$X\rC\u0003o\t\u0001\u0007q.A\u0005u_BL7MT1nKB\u0011\u0001\u000f\u001e\b\u0003cJ\u0004\"!\u0016\"\n\u0005M\u0014\u0015A\u0002)sK\u0012,g-\u0003\u0002vm\n11\u000b\u001e:j]\u001eT!a\u001d\"\t\u000ba$\u0001\u0019A=\u0002\u000fQ|\u0007/[2JIB\u0011!0`\u0007\u0002w*\u0011ApJ\u0001\u0007G>lWn\u001c8\n\u0005y\\(\u0001B+vS\u0012Dq!!\u0001\u0005\u0001\u0004\t\u0019!\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004r!SA\u0003\u0003\u0013\ty!C\u0002\u0002\b)\u00131!T1q!\rY\u00121B\u0005\u0004\u0003\u001ba\"aB%oi\u0016<WM\u001d\t\u0005\u0003#\t\u0019\"D\u0001&\u0013\r\t)\"\n\u0002\u0016!\u0006\u0014H/\u001b;j_:\u0014VmZ5tiJ\fG/[8o\u0011\u0019\tI\u0002\u0002a\u0001U\u0006)1\u000f^1uK\u0006\u00113M]3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:Tfj\u001c3fgJ+\u0017/^3tiN$\u0002\"a\b\u00028\u0005e\u00121\b\t\u0007\u0003C\t9#a\u000b\u000e\u0005\u0005\r\"bAA\u0013\u0005\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00121\u0005\u0002\u0004'\u0016\f\b\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005Eb#A\u0005{_>\\W-\u001a9fe&!\u0011QGA\u0018\u00055\u0019%/Z1uKJ+\u0017/^3ti\")a.\u0002a\u0001_\"9\u0011\u0011A\u0003A\u0002\u0005\r\u0001BBA\r\u000b\u0001\u0007!.A\tsK\u000e,(o]5wK\u000eC\u0017\u000e\u001c3sK:$R\u0001QA!\u0003\u000bBa!a\u0011\u0007\u0001\u0004y\u0017\u0001\u00029bi\"Dq!a\u0012\u0007\u0001\u0004\tI%A\u0002bG\u000e\u0004R!a\u0013\u0002R=l!!!\u0014\u000b\t\u0005=\u00131E\u0001\b[V$\u0018M\u00197f\u0013\u0011\t\u0019&!\u0014\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u000b\u0005\u0003/\nI\u0006E\u0003\u0002\"\u0005\u001dr\u000e\u0003\u0004\u0002D\u001d\u0001\ra\\\u0001\fkB$\u0017\r^3U_BL7\rF\u0005k\u0003?\n\t'a\u0019\u0002f!)a\u000e\u0003a\u0001_\")\u0001\u0010\u0003a\u0001s\"9\u0011\u0011\u0001\u0005A\u0002\u0005\r\u0001BBA\r\u0011\u0001\u0007!.A\u0006eK2,G/\u001a+pa&\u001cG#\u00026\u0002l\u00055\u0004\"\u00028\n\u0001\u0004y\u0007BBA\r\u0013\u0001\u0007!.A\u000bde\u0016\fG/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\u000b)\f\u0019(!\u001f\t\u000f\u0005U$\u00021\u0001\u0002x\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004J\u0003\u000by\u00171\u0001\u0005\u0007\u00033Q\u0001\u0019\u00016\u0002+U\u0004H-\u0019;f)>\u0004\u0018n\u0019)beRLG/[8ogR)!.a \u0002\u0002\"9\u0011QO\u0006A\u0002\u0005]\u0004BBA\r\u0017\u0001\u0007!.A\u000beK2,G/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\u000b)\f9)!%\t\u000f\u0005UD\u00021\u0001\u0002\nB1\u0011*!\u0002p\u0003\u0017\u0003R!SAG\u0003\u0013I1!a$K\u0005\r\u0019V\r\u001e\u0005\u0007\u00033a\u0001\u0019\u00016\u0002)\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)beRLG/[8o)\u0011\tY#a&\t\u000f\u0005eU\u00021\u0001\u0002\u001c\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007c\u0001>\u0002\u001e&\u0019\u0011qT>\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006I\u0002/\u0019:uSRLwN\\*uCR,\u0007+\u0019;i\u0003:$G)\u0019;b)!\t)+a.\u0002:\u0006u\u0006CB!\u0002(>\fY+C\u0002\u0002*\n\u0013a\u0001V;qY\u0016\u0014\u0004#B!\u0002.\u0006E\u0016bAAX\u0005\n)\u0011I\u001d:bsB\u0019\u0011)a-\n\u0007\u0005U&I\u0001\u0003CsR,\u0007bBAM\u001d\u0001\u0007\u00111\u0014\u0005\b\u0003ws\u0001\u0019AA\b\u0003U\u0001\u0018M\u001d;ji&|gNU3hSN$(/\u0019;j_:Dq!a0\u000f\u0001\u0004\t\t-A\bd_:$(o\u001c7mKJ,\u0005o\\2i!\r\t\u00151Y\u0005\u0004\u0003\u000b\u0014%aA%oi\u0006I2M]3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)!\tY#a3\u0002N\u0006=\u0007bBAM\u001f\u0001\u0007\u00111\u0014\u0005\b\u0003w{\u0001\u0019AA\b\u0011\u001d\tyl\u0004a\u0001\u0003\u0003\f\u0011$\u001e9eCR,Gk\u001c9jGB\u000b'\u000f^5uS>t7\u000b^1uKRA\u0011Q[An\u0003;\fy\u000e\u0005\u0003\u0002.\u0005]\u0017\u0002BAm\u0003_\u0011abU3u\t\u0006$\u0018MU3rk\u0016\u001cH\u000fC\u0004\u0002\u001aB\u0001\r!a'\t\u000f\u0005m\u0006\u00031\u0001\u0002\u0010!9\u0011q\u0018\tA\u0002\u0005\u0005\u0007")
public class ZkTopicMigrationClient
implements TopicMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
        try {
            ZkTopicMigrationClient.$anonfun$iterateTopics$1(this, interests, visitor);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopic$1(this, partitions, topicName, topicId, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    private Seq<CreateRequest> createTopicPartitionZNodesRequests(String topicName, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        String path = TopicPartitionsZNode$.MODULE$.path(topicName);
        CreateRequest createPartitionsZNode = new CreateRequest(path, null, this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        scala.collection.immutable.Seq createPartitionZNodeReqs = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                return new .colon.colon((Object)this.createTopicPartition(topicPartition), (List)new .colon.colon((Object)this.createTopicPartitionState(topicPartition, partition, state.kraftControllerEpoch()), (List)Nil$.MODULE$));
            }
            throw new MatchError(null);
        });
        return (Seq)new .colon.colon((Object)createPartitionsZNode, (List)Nil$.MODULE$).$plus$plus((IterableOnce)createPartitionZNodeReqs);
    }

    private void recursiveChildren(String path, ArrayBuffer<String> acc) {
        ((GetChildrenResponse)this.zkClient.retryRequestUntilConnected(new GetChildrenRequest(path, false, (Option<Object>)None$.MODULE$), this.zkClient.retryRequestUntilConnected$default$2())).children().foreach((Function1 & Serializable)child -> {
            this.recursiveChildren(new StringBuilder(1).append(path).append("/").append((String)child).toString(), acc);
            return (ArrayBuffer)acc.append((Object)new StringBuilder(1).append(path).append("/").append((String)child).toString());
        });
    }

    private Seq<String> recursiveChildren(String path) {
        ArrayBuffer buffer = new ArrayBuffer();
        this.recursiveChildren(path, (ArrayBuffer<String>)buffer);
        return buffer.toSeq();
    }

    public ZkMigrationLeadershipState updateTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$updateTopic$1(this, partitions, topicName, topicId, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteTopic(String topicName, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$deleteTopic$1(this, topicName, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopicPartitions$1(this, topicPartitions, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState updateTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$updateTopicPartitions$1(this, topicPartitions, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState deleteTopicPartitions(java.util.Map<String, Set<Integer>> topicPartitions, ZkMigrationLeadershipState state) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                Set partitionIds = (Set)x0$1._2();
                return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(partitionIds).asScala().map((Function1 & Serializable)partitionId -> {
                    TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                    String path = TopicPartitionZNode$.MODULE$.path(topicPartition);
                    return new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$deleteTopicPartitions$4(x0$2)))) {
            void var5_5;
            return state.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to delete partition states: ").append(topicPartitions).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    private CreateRequest createTopicPartition(TopicPartition topicPartition) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopicPartition$1(this, topicPartition);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    private Tuple2<String, byte[]> partitionStatePathAndData(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        String path = TopicPartitionStateZNode$.MODULE$.path(topicPartition);
        byte[] data = TopicPartitionStateZNode$.MODULE$.encode(new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(partitionRegistration.leader, partitionRegistration.leaderEpoch, (List<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration.isr).toList(), partitionRegistration.leaderRecoveryState, partitionRegistration.partitionEpoch), controllerEpoch));
        return new Tuple2((Object)path, (Object)data);
    }

    /*
     * WARNING - void declaration
     */
    private CreateRequest createTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new CreateRequest((String)var5_5, (byte[])var6_6, this.zkClient.defaultAcls((String)var5_5), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition));
    }

    /*
     * WARNING - void declaration
     */
    private SetDataRequest updateTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new SetDataRequest((String)var5_5, (byte[])var6_6, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)new Some((Object)topicPartition));
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$6(ZkTopicMigrationClient $this, Option topicIdOpt$1, Map leaderIsrAndControllerEpochs$1, TopicMigrationClient.TopicVisitor visitor$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            ReplicaAssignment replicaAssignment = (ReplicaAssignment)x0$3._2();
            java.util.List replicaList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava();
            PartitionRecord record = new PartitionRecord().setTopicId((Uuid)topicIdOpt$1.get()).setPartitionId(topicPartition.partition()).setReplicas(replicaList).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.addingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.removingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
            Option option = leaderIsrAndControllerEpochs$1.get((Object)topicPartition);
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                record.setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaderIsrAndEpoch.leaderAndIsr().isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setLeader(leaderIsrAndEpoch.leaderAndIsr().leader()).setLeaderEpoch(leaderIsrAndEpoch.leaderAndIsr().leaderEpoch()).setPartitionEpoch(leaderIsrAndEpoch.leaderAndIsr().partitionEpoch()).setLeaderRecoveryState(leaderIsrAndEpoch.leaderAndIsr().leaderRecoveryState().value());
            } else if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Could not find partition state in ZK for ").append(topicPartition).append(". Initializing this partition ").append("with ISR={").append(replicaList).append("} and leaderEpoch=0.").toString());
                record.setIsr(replicaList).setLeader(Predef$.MODULE$.Integer2int((Integer)replicaList.get(0))).setLeaderEpoch(0).setPartitionEpoch(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value());
            } else {
                throw new MatchError((Object)option);
            }
            String logAndRethrow_msg = new StringBuilder(49).append("Error in partition consumer. TopicPartition was ").append(topicPartition).append(".").toString();
            try {
                visitor$1.visitPartition(new TopicIdPartition((Uuid)topicIdOpt$1.get(), topicPartition), new PartitionRegistration(record));
                return;
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$2(ZkTopicMigrationClient $this, TopicMigrationClient.TopicVisitor visitor$1, EnumSet interests$1, TopicZNode.TopicIdReplicaAssignment x0$1) {
        if (x0$1 != null) {
            String topic = x0$1.topic();
            Option<Uuid> topicIdOpt = x0$1.topicId();
            Map<TopicPartition, ReplicaAssignment> partitionAssignments = x0$1.assignment();
            java.util.Map topicAssignment = CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionAssignments.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition partition = (TopicPartition)x0$2._1();
                    ReplicaAssignment assignment = (ReplicaAssignment)x0$2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition.partition())), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            String logAndRethrow_msg = new StringBuilder(36).append("Error in topic consumer. Topic was ").append(topic).append(".").toString();
            try {
                visitor$1.visitTopic(topic, (Uuid)topicIdOpt.get(), topicAssignment);
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
            Object var10_8 = null;
            if (interests$1.contains(TopicMigrationClient.TopicVisitorInterest.PARTITIONS)) {
                scala.collection.immutable.Seq partitions = partitionAssignments.keys().toSeq();
                Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs = $this.zkClient.getTopicPartitionStates((Seq<TopicPartition>)partitions);
                partitionAssignments.foreach((Function1 & Serializable)x0$3 -> {
                    ZkTopicMigrationClient.$anonfun$iterateTopics$6($this, topicIdOpt, leaderIsrAndControllerEpochs, visitor$1, x0$3);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$1(ZkTopicMigrationClient $this, EnumSet interests$1, TopicMigrationClient.TopicVisitor visitor$1) {
        if (!interests$1.contains(TopicMigrationClient.TopicVisitorInterest.TOPICS)) {
            throw new IllegalArgumentException("Must specify at least TOPICS in topic visitor interests.");
        }
        scala.collection.immutable.Set<String> topics = $this.zkClient.getAllTopicsInCluster($this.zkClient.getAllTopicsInCluster$default$1());
        $this.zkClient.getReplicaAssignmentAndTopicIdForTopics(topics).foreach((Function1 & Serializable)x0$1 -> {
            ZkTopicMigrationClient.$anonfun$iterateTopics$2($this, visitor$1, interests$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$createTopic$1(ZkTopicMigrationClient $this, java.util.Map partitions$1, String topicName$1, Uuid topicId$1, ZkMigrationLeadershipState state$1) {
        void var12_12;
        Seq<CreateRequest> createPartitionZNodeReqs;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions$1).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                void apply_addingReplicas;
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray(partition.removingReplicas);
                ArraySeq.ofInt ofInt3 = Predef$.MODULE$.wrapIntArray(partition.addingReplicas);
                ArraySeq.ofInt apply_replicas = Predef$.MODULE$.wrapIntArray(partition.replicas);
                Object var4_6 = null;
                ofInt3 = null;
                ofInt2 = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName$1, Predef$.MODULE$.Integer2int(partitionId))), (Object)new ReplicaAssignment((Seq<Object>)apply_replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
        String path = TopicZNode$.MODULE$.path(topicName$1);
        CreateRequest createTopicZNode = new CreateRequest(path, TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId$1), (Map<TopicPartition, ReplicaAssignment>)assignments), $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        Seq requests = (Seq)new .colon.colon((Object)createTopicZNode, (List)Nil$.MODULE$).$plus$plus(createPartitionZNodeReqs = $this.createTopicPartitionZNodesRequests(topicName$1, partitions$1, state$1));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var12_12.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((Enum)resultCodes.apply((Object)TopicZNode$.MODULE$.path(topicName$1))).equals(KeeperException.Code.NODEEXISTS)) {
            return state$1;
        }
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$createTopic$4(x0$2)))) {
            void var11_11;
            return state$1.withMigrationZkVersion((int)var11_11);
        }
        throw new MigrationClientException(new StringBuilder(61).append("Failed to create or update topic ").append(topicName$1).append(". ZK operations had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateTopic$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$updateTopic$1(ZkTopicMigrationClient $this, java.util.Map partitions$2, String topicName$3, Uuid topicId$2, ZkMigrationLeadershipState state$3) {
        void var9_9;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions$2).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                void apply_addingReplicas;
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray(partition.removingReplicas);
                ArraySeq.ofInt ofInt3 = Predef$.MODULE$.wrapIntArray(partition.addingReplicas);
                ArraySeq.ofInt apply_replicas = Predef$.MODULE$.wrapIntArray(partition.replicas);
                Object var4_6 = null;
                ofInt3 = null;
                ofInt2 = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName$3, Predef$.MODULE$.Integer2int(partitionId))), (Object)new ReplicaAssignment((Seq<Object>)apply_replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
        SetDataRequest request = new SetDataRequest(TopicZNode$.MODULE$.path(topicName$3), TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId$2), (Map<TopicPartition, ReplicaAssignment>)assignments), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state$3);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var9_9.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$updateTopic$4(x0$2)))) {
            void var8_8;
            return state$3.withMigrationZkVersion((int)var8_8);
        }
        throw new MigrationClientException(new StringBuilder(62).append("Failed to update topic metadata: ").append(topicName$3).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteTopic$1(ZkTopicMigrationClient $this, String topicName$4, ZkMigrationLeadershipState state$4) {
        void var7_7;
        String topicPath = TopicZNode$.MODULE$.path(topicName$4);
        Seq deleteRequests = (Seq)((IterableOps)$this.recursiveChildren(topicPath).map((Function1 & Serializable)childPath -> new DeleteRequest((String)childPath, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)new DeleteRequest(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), topicName$4), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)new .colon.colon((Object)new DeleteRequest(TopicZNode$.MODULE$.path(topicName$4), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$)));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(deleteRequests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var7_7.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((DeleteResponse)var7_7.last()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var6_6;
            return state$4.withMigrationZkVersion((int)var6_6);
        }
        throw new MigrationClientException(new StringBuilder(51).append("Failed to delete topic ").append(topicName$4).append(". ZK operations had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$createTopicPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            KeeperException.Code code = (KeeperException.Code)x0$2._2();
            return code.equals((Object)KeeperException.Code.OK) || code.equals((Object)KeeperException.Code.NODEEXISTS);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$createTopicPartitions$1(ZkTopicMigrationClient $this, java.util.Map topicPartitions$1, ZkMigrationLeadershipState state$5) {
        void var6_6;
        scala.collection.immutable.Seq requests = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions$1).asScala().toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitions = (java.util.Map)x0$1._2();
                return $this.createTopicPartitionZNodesRequests(topicName, partitions, state$5);
            }
            throw new MatchError(null);
        });
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$5);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$createTopicPartitions$4(x0$2)))) {
            void var5_5;
            return state$5.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to create partition states: ").append(topicPartitions$1).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateTopicPartitions$5(Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((KeeperException.Code)x0$3._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$updateTopicPartitions$1(ZkTopicMigrationClient $this, java.util.Map topicPartitions$2, ZkMigrationLeadershipState state$6) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions$2).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitionRegistrations = (java.util.Map)x0$1._2();
                return (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitionRegistrations).asScala().flatMap((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        Integer partitionId = (Integer)x0$2._1();
                        PartitionRegistration partitionRegistration = (PartitionRegistration)x0$2._2();
                        TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                        return new .colon.colon((Object)$this.updateTopicPartitionState(topicPartition, partitionRegistration, state$6.kraftControllerEpoch()), (List)Nil$.MODULE$);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state$6;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state$6);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$updateTopicPartitions$5(x0$3)))) {
            void var5_5;
            return state$6.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to update partition states: ").append(topicPartitions$2).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopicPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ CreateRequest $anonfun$createTopicPartition$1(ZkTopicMigrationClient $this, TopicPartition topicPartition$2) {
        String path = TopicPartitionZNode$.MODULE$.path(topicPartition$2);
        return new CreateRequest(path, null, $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition$2));
    }

    public ZkTopicMigrationClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }
}

