/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.mirror.GroupFilter;
import org.apache.kafka.connect.mirror.MirrorCheckpointConfig;
import org.apache.kafka.connect.mirror.MirrorCheckpointTask;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.Scheduler;
import org.apache.kafka.connect.mirror.SourceAndTarget;
import org.apache.kafka.connect.mirror.TopicFilter;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.util.ConnectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorCheckpointConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(MirrorCheckpointConnector.class);
    private Scheduler scheduler;
    private MirrorCheckpointConfig config;
    private TopicFilter topicFilter;
    private GroupFilter groupFilter;
    private Admin sourceAdminClient;
    private Admin targetAdminClient;
    private SourceAndTarget sourceAndTarget;
    private List<String> knownConsumerGroups = Collections.emptyList();

    public MirrorCheckpointConnector() {
    }

    MirrorCheckpointConnector(List<String> knownConsumerGroups, MirrorCheckpointConfig config) {
        this.knownConsumerGroups = knownConsumerGroups;
        this.config = config;
    }

    public void start(Map<String, String> props) {
        this.config = new MirrorCheckpointConfig(props);
        if (!this.config.enabled()) {
            return;
        }
        String connectorName = this.config.connectorName();
        this.sourceAndTarget = new SourceAndTarget(this.config.sourceClusterAlias(), this.config.targetClusterAlias());
        this.topicFilter = this.config.topicFilter();
        this.groupFilter = this.config.groupFilter();
        this.sourceAdminClient = this.config.forwardingAdmin(this.config.sourceAdminConfig("checkpoint-source-admin"));
        this.targetAdminClient = this.config.forwardingAdmin(this.config.targetAdminConfig("checkpoint-target-admin"));
        this.scheduler = new Scheduler(((Object)((Object)this)).getClass(), this.config.entityLabel(), this.config.adminTimeout());
        this.scheduler.execute(this::createInternalTopics, "creating internal topics");
        this.scheduler.execute(this::loadInitialConsumerGroups, "loading initial consumer groups");
        this.scheduler.scheduleRepeatingDelayed(this::refreshConsumerGroups, this.config.refreshGroupsInterval(), "refreshing consumer groups");
        log.info("Started {} with {} consumer groups.", (Object)connectorName, (Object)this.knownConsumerGroups.size());
        log.debug("Started {} with consumer groups: {}", (Object)connectorName, this.knownConsumerGroups);
    }

    public void stop() {
        if (!this.config.enabled()) {
            return;
        }
        Utils.closeQuietly((AutoCloseable)this.scheduler, (String)"scheduler");
        Utils.closeQuietly((AutoCloseable)this.topicFilter, (String)"topic filter");
        Utils.closeQuietly((AutoCloseable)this.groupFilter, (String)"group filter");
        Utils.closeQuietly((AutoCloseable)this.sourceAdminClient, (String)"source admin client");
        Utils.closeQuietly((AutoCloseable)this.targetAdminClient, (String)"target admin client");
    }

    public Class<? extends Task> taskClass() {
        return MirrorCheckpointTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (!this.config.enabled() || this.knownConsumerGroups.isEmpty() || this.config.emitCheckpointsInterval().isNegative()) {
            return Collections.emptyList();
        }
        int numTasks = Math.min(maxTasks, this.knownConsumerGroups.size());
        List groupsPartitioned = ConnectorUtils.groupPartitions(this.knownConsumerGroups, (int)numTasks);
        return IntStream.range(0, numTasks).mapToObj(i -> this.config.taskConfigForConsumerGroups((List)groupsPartitioned.get(i), i)).collect(Collectors.toList());
    }

    public ConfigDef config() {
        return MirrorCheckpointConfig.CONNECTOR_CONFIG_DEF;
    }

    public String version() {
        return AppInfoParser.getVersion();
    }

    private void refreshConsumerGroups() throws InterruptedException, ExecutionException {
        List<String> consumerGroups = this.findConsumerGroups();
        HashSet<String> newConsumerGroups = new HashSet<String>();
        newConsumerGroups.addAll(consumerGroups);
        newConsumerGroups.removeAll(this.knownConsumerGroups);
        HashSet<String> deadConsumerGroups = new HashSet<String>();
        deadConsumerGroups.addAll(this.knownConsumerGroups);
        deadConsumerGroups.removeAll(consumerGroups);
        if (!newConsumerGroups.isEmpty() || !deadConsumerGroups.isEmpty()) {
            log.info("Found {} consumer groups for {}. {} are new. {} were removed. Previously had {}.", new Object[]{consumerGroups.size(), this.sourceAndTarget, newConsumerGroups.size(), deadConsumerGroups.size(), this.knownConsumerGroups.size()});
            log.debug("Found new consumer groups: {}", newConsumerGroups);
            this.knownConsumerGroups = consumerGroups;
            this.context.requestTaskReconfiguration();
        }
    }

    private void loadInitialConsumerGroups() throws InterruptedException, ExecutionException {
        this.knownConsumerGroups = this.findConsumerGroups();
    }

    List<String> findConsumerGroups() throws InterruptedException, ExecutionException {
        List filteredGroups = this.listConsumerGroups().stream().map(ConsumerGroupListing::groupId).filter(this::shouldReplicateByGroupFilter).collect(Collectors.toList());
        LinkedList<String> checkpointGroups = new LinkedList<String>();
        LinkedList<String> irrelevantGroups = new LinkedList<String>();
        for (String group : filteredGroups) {
            Set consumedTopics = this.listConsumerGroupOffsets(group).keySet().stream().map(TopicPartition::topic).filter(this::shouldReplicateByTopicFilter).collect(Collectors.toSet());
            if (consumedTopics.size() > 0) {
                checkpointGroups.add(group);
                continue;
            }
            irrelevantGroups.add(group);
        }
        log.debug("Ignoring the following groups which do not have any offsets for topics that are accepted by the topic filter: {}", irrelevantGroups);
        return checkpointGroups;
    }

    Collection<ConsumerGroupListing> listConsumerGroups() throws InterruptedException, ExecutionException {
        return (Collection)this.sourceAdminClient.listConsumerGroups().valid().get();
    }

    private void createInternalTopics() {
        MirrorUtils.createSinglePartitionCompactedTopic(this.config.checkpointsTopic(), this.config.checkpointsTopicReplicationFactor(), this.targetAdminClient);
    }

    Map<TopicPartition, OffsetAndMetadata> listConsumerGroupOffsets(String group) throws InterruptedException, ExecutionException {
        return (Map)this.sourceAdminClient.listConsumerGroupOffsets(group).partitionsToOffsetAndMetadata().get();
    }

    boolean shouldReplicateByGroupFilter(String group) {
        return this.groupFilter.shouldReplicateGroup(group);
    }

    boolean shouldReplicateByTopicFilter(String topic) {
        return this.topicFilter.shouldReplicateTopic(topic);
    }
}

