/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.migration.MigrationPropagator;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.SocketServer;
import kafka.raft.KafkaRaftManager;
import kafka.security.CredentialProvider;
import kafka.server.BrokerConfigHandler;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.ControllerApis;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.ControllerMigrationSupport;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.Server;
import kafka.server.Server$SHUTDOWN$;
import kafka.server.Server$SHUTTING_DOWN$;
import kafka.server.Server$STARTED$;
import kafka.server.Server$STARTING$;
import kafka.server.SharedServer;
import kafka.server.SimpleApiVersionManager;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.ScramPublisher;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.metrics.ControllerMetadataMetricsPublisher;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.migration.KRaftMigrationDriver;
import org.apache.kafka.metadata.migration.LegacyPropagator;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.apache.kafka.server.util.Deadline;
import org.apache.kafka.server.util.FutureUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\red\u0001B&M\u0001EC\u0001B\u0018\u0001\u0003\u0006\u0004%\ta\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005A\"AQ\r\u0001BC\u0002\u0013\u0005a\r\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003h\u0011!\u0019\bA!b\u0001\n\u0003!\b\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u000bq\u0004A\u0011A?\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0001\u0002CA\f\u0001\u0001\u0006I!!\u0003\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\b\t\u0013\u0005\u0015\u0002A1A\u0005\u0002\u0005\u001d\u0002\u0002CA\u001c\u0001\u0001\u0006I!!\u000b\t\u000f\u0005=\u0001\u0001\"\u0001\u0002:!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003\"CA0\u0001\t\u0007I\u0011AA1\u0011!\tY\b\u0001Q\u0001\n\u0005\r\u0004\"CA?\u0001\t\u0007I\u0011AA@\u0011!\t9\t\u0001Q\u0001\n\u0005\u0005\u0005\"CAE\u0001\u0001\u0007I\u0011AAF\u0011%\tI\u000b\u0001a\u0001\n\u0003\tY\u000b\u0003\u0005\u00028\u0002\u0001\u000b\u0015BAG\u0011-\tI\f\u0001a\u0001\u0002\u0004%\t!a/\t\u0017\u0005\u001d\u0007\u00011AA\u0002\u0013\u0005\u0011\u0011\u001a\u0005\f\u0003\u001b\u0004\u0001\u0019!A!B\u0013\ti\fC\u0005\u0002P\u0002\u0001\r\u0011\"\u0001\u0002R\"I\u00111\u001d\u0001A\u0002\u0013\u0005\u0011Q\u001d\u0005\t\u0003S\u0004\u0001\u0015)\u0003\u0002T\"Y\u00111\u001f\u0001A\u0002\u0003\u0007I\u0011AA{\u0011-\u0011y\u0001\u0001a\u0001\u0002\u0004%\tA!\u0005\t\u0017\tU\u0001\u00011A\u0001B\u0003&\u0011q\u001f\u0005\f\u0005/\u0001\u0001\u0019!a\u0001\n\u0003\u0011I\u0002C\u0006\u0003&\u0001\u0001\r\u00111A\u0005\u0002\t\u001d\u0002b\u0003B\u0016\u0001\u0001\u0007\t\u0011)Q\u0005\u00057A1B!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00030!Y!Q\b\u0001A\u0002\u0003\u0007I\u0011\u0001B \u0011-\u0011\u0019\u0005\u0001a\u0001\u0002\u0003\u0006KA!\r\t\u0013\t\u0015\u0003A1A\u0005\u0002\t\u001d\u0003\u0002\u0003B/\u0001\u0001\u0006IA!\u0013\t\u0013\t}\u0003\u00011A\u0005\u0002\t\u0005\u0004\"\u0003B9\u0001\u0001\u0007I\u0011\u0001B:\u0011!\u00119\b\u0001Q!\n\t\r\u0004\"\u0003B=\u0001\u0001\u0007I\u0011\u0001B>\u0011%\u0011)\t\u0001a\u0001\n\u0003\u00119\t\u0003\u0005\u0003\f\u0002\u0001\u000b\u0015\u0002B?\u0011-\u0011i\t\u0001a\u0001\u0002\u0004%\tAa$\t\u0017\t}\u0005\u00011AA\u0002\u0013\u0005!\u0011\u0015\u0005\f\u0005K\u0003\u0001\u0019!A!B\u0013\u0011\t\nC\u0006\u0003\u001a\u0002\u0001\r\u00111A\u0005\u0002\t%\u0006b\u0003BZ\u0001\u0001\u0007\t\u0019!C\u0001\u0005kC1B!/\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003,\"Y!1\u0018\u0001A\u0002\u0003\u0007I\u0011\u0001B_\u0011-\u0011i\r\u0001a\u0001\u0002\u0004%\tAa4\t\u0017\tM\u0007\u00011A\u0001B\u0003&!q\u0018\u0005\f\u0005+\u0004\u0001\u0019!a\u0001\n\u0003\u00119\u000eC\u0006\u0003d\u0002\u0001\r\u00111A\u0005\u0002\t\u0015\bb\u0003Bu\u0001\u0001\u0007\t\u0011)Q\u0005\u00053D1Ba;\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003n\"Y!Q\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001B|\u0011-\u0011Y\u0010\u0001a\u0001\u0002\u0003\u0006KAa<\t\u0017\tu\b\u00011AA\u0002\u0013\u0005!q \u0005\f\u0007\u000f\u0001\u0001\u0019!a\u0001\n\u0003\u0019I\u0001C\u0006\u0004\u000e\u0001\u0001\r\u0011!Q!\n\r\u0005\u0001\"CB\b\u0001\u0001\u0007I\u0011AB\t\u0011%\u0019Y\u0002\u0001a\u0001\n\u0003\u0019i\u0002\u0003\u0005\u0004\"\u0001\u0001\u000b\u0015BB\n\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u0007KA\u0011b!\f\u0001\u0005\u0004%\taa\f\t\u0011\r%\u0003\u0001)A\u0005\u0007cAqaa\u0013\u0001\t\u0013\u0019i\u0005C\u0004\u0004^\u0001!\taa\u0018\t\u000f\rE\u0004\u0001\"\u0001\u0004t!91Q\u000f\u0001\u0005\u0002\rM\u0004bBB<\u0001\u0011\u000511\u000f\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJT!!\u0014(\u0002\rM,'O^3s\u0015\u0005y\u0015!B6bM.\f7\u0001A\n\u0004\u0001IC\u0006CA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&AB!osJ+g\r\u0005\u0002Z96\t!L\u0003\u0002\\\u001d\u0006)Q\u000f^5mg&\u0011QL\u0017\u0002\b\u0019><w-\u001b8h\u00031\u0019\b.\u0019:fIN+'O^3s+\u0005\u0001\u0007CA1c\u001b\u0005a\u0015BA2M\u00051\u0019\u0006.\u0019:fIN+'O^3s\u00035\u0019\b.\u0019:fIN+'O^3sA\u0005a1m\u001c8gS\u001e\u001c6\r[3nCV\tq\r\u0005\u0002ia6\t\u0011N\u0003\u0002kW\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002PY*\u0011QN\\\u0001\u0007CB\f7\r[3\u000b\u0003=\f1a\u001c:h\u0013\t\t\u0018NA\tLC\u001a\\\u0017mQ8oM&<7k\u00195f[\u0006\fQbY8oM&<7k\u00195f[\u0006\u0004\u0013!\u00052p_R\u001cHO]1q\u001b\u0016$\u0018\rZ1uCV\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002yS\u0006I!m\\8ugR\u0014\u0018\r]\u0005\u0003u^\u0014\u0011CQ8piN$(/\u00199NKR\fG-\u0019;b\u0003I\u0011wn\u001c;tiJ\f\u0007/T3uC\u0012\fG/\u0019\u0011\u0002\rqJg.\u001b;?)\u0019qx0!\u0001\u0002\u0004A\u0011\u0011\r\u0001\u0005\u0006=\u001e\u0001\r\u0001\u0019\u0005\u0006K\u001e\u0001\ra\u001a\u0005\u0006g\u001e\u0001\r!^\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00145\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0004nKR\u0014\u0018nY:\u000b\u00055[\u0017\u0002BA\u000b\u0003\u001b\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u000511m\u001c8gS\u001e,\"!!\b\u0011\u0007\u0005\fy\"C\u0002\u0002\"1\u00131bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u000b\u0011\t\u0005-\u00121G\u0007\u0003\u0003[Q1aWA\u0018\u0015\r\t\td[\u0001\u0007G>lWn\u001c8\n\t\u0005U\u0012Q\u0006\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0006\u0002\u0002<A!\u0011QHA!\u001b\t\tyD\u0003\u0003\u0002\u0010\u0005=\u0012\u0002BA\"\u0003\u007f\u0011q!T3ue&\u001c7/A\u0006sC\u001a$X*\u00198bO\u0016\u0014XCAA%!\u0019\tY%!\u0015\u0002V5\u0011\u0011Q\n\u0006\u0004\u0003\u001fr\u0015\u0001\u0002:bMRLA!a\u0015\u0002N\t\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\t\u0005\u0003/\nY&\u0004\u0002\u0002Z)!\u0011\u0011GA\t\u0013\u0011\ti&!\u0017\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0003\u0011awnY6\u0016\u0005\u0005\r\u0004\u0003BA3\u0003oj!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003[\ny'\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u001d\u0002t\u0005!Q\u000f^5m\u0015\t\t)(\u0001\u0003kCZ\f\u0017\u0002BA=\u0003O\u0012QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00027pG.\u0004\u0013!E1xC&$8\u000b[;uI><hnQ8oIV\u0011\u0011\u0011\u0011\t\u0005\u0003K\n\u0019)\u0003\u0003\u0002\u0006\u0006\u001d$!C\"p]\u0012LG/[8o\u0003I\tw/Y5u'\",H\u000fZ8x]\u000e{g\u000e\u001a\u0011\u0002\rM$\u0018\r^;t+\t\ti\t\u0005\u0003\u0002\u0010\u0006\rf\u0002BAI\u0003?sA!a%\u0002\u001e:!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001aB\u000ba\u0001\u0010:p_Rt\u0014\"A(\n\u00055s\u0015bAAQ\u0019\u000611+\u001a:wKJLA!!*\u0002(\ni\u0001K]8dKN\u001c8\u000b^1ukNT1!!)M\u0003)\u0019H/\u0019;vg~#S-\u001d\u000b\u0005\u0003[\u000b\u0019\fE\u0002T\u0003_K1!!-U\u0005\u0011)f.\u001b;\t\u0013\u0005UV#!AA\u0002\u00055\u0015a\u0001=%c\u000591\u000f^1ukN\u0004\u0013a\u00067j]VD\u0018j\\'fiJL7m]\"pY2,7\r^8s+\t\ti\f\u0005\u0003\u0002@\u0006\rWBAAa\u0015\r\tyAT\u0005\u0005\u0003\u000b\f\tMA\fMS:,\b0S8NKR\u0014\u0018nY:D_2dWm\u0019;pe\u0006YB.\u001b8vq&{W*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN]0%KF$B!!,\u0002L\"I\u0011Q\u0017\r\u0002\u0002\u0003\u0007\u0011QX\u0001\u0019Y&tW\u000f_%p\u001b\u0016$(/[2t\u0007>dG.Z2u_J\u0004\u0013AC1vi\"|'/\u001b>feV\u0011\u00111\u001b\t\u0006'\u0006U\u0017\u0011\\\u0005\u0004\u0003/$&AB(qi&|g\u000e\u0005\u0003\u0002\\\u0006}WBAAo\u0015\u0011\ty-!\u0005\n\t\u0005\u0005\u0018Q\u001c\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018AD1vi\"|'/\u001b>fe~#S-\u001d\u000b\u0005\u0003[\u000b9\u000fC\u0005\u00026n\t\t\u00111\u0001\u0002T\u0006Y\u0011-\u001e;i_JL'0\u001a:!Q\ra\u0012Q\u001e\t\u0004'\u0006=\u0018bAAy)\nAao\u001c7bi&dW-\u0001\u0006u_.,gnQ1dQ\u0016,\"!a>\u0011\t\u0005e(1B\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0005\u0003\u0011\u0019!\u0001\u0006eK2,w-\u0019;j_:TAA!\u0002\u0003\b\u0005)Ao\\6f]*!!\u0011BA\u0018\u0003!\u0019XmY;sSRL\u0018\u0002\u0002B\u0007\u0003w\u0014A\u0003R3mK\u001e\fG/[8o)>\\WM\\\"bG\",\u0017A\u0004;pW\u0016t7)Y2iK~#S-\u001d\u000b\u0005\u0003[\u0013\u0019\u0002C\u0005\u00026z\t\t\u00111\u0001\u0002x\u0006YAo\\6f]\u000e\u000b7\r[3!\u0003I\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0016\u0005\tm\u0001\u0003\u0002B\u000f\u0005Ci!Aa\b\u000b\u0007\t%a*\u0003\u0003\u0003$\t}!AE\"sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\fac\u0019:fI\u0016tG/[1m!J|g/\u001b3fe~#S-\u001d\u000b\u0005\u0003[\u0013I\u0003C\u0005\u00026\u0006\n\t\u00111\u0001\u0003\u001c\u0005\u00192M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3sA\u0005a1o\\2lKR\u001cVM\u001d<feV\u0011!\u0011\u0007\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)\u0019!q\u0007(\u0002\u000f9,Go^8sW&!!1\bB\u001b\u00051\u0019vnY6fiN+'O^3s\u0003A\u0019xnY6fiN+'O^3s?\u0012*\u0017\u000f\u0006\u0003\u0002.\n\u0005\u0003\"CA[I\u0005\u0005\t\u0019\u0001B\u0019\u00035\u0019xnY6fiN+'O^3sA\u0005\u00013o\\2lKR\u001cVM\u001d<fe\u001aK'o\u001d;C_VtG\rU8si\u001a+H/\u001e:f+\t\u0011I\u0005\u0005\u0004\u0003L\t5#\u0011K\u0007\u0003\u0003WJAAa\u0014\u0002l\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\tM#\u0011L\u0007\u0003\u0005+RAAa\u0016\u0002t\u0005!A.\u00198h\u0013\u0011\u0011YF!\u0016\u0003\u000f%sG/Z4fe\u0006\t3o\\2lKR\u001cVM\u001d<fe\u001aK'o\u001d;C_VtG\rU8si\u001a+H/\u001e:fA\u0005\t2M]3bi\u0016$v\u000e]5d!>d\u0017nY=\u0016\u0005\t\r\u0004#B*\u0002V\n\u0015\u0004\u0003\u0002B4\u0005[j!A!\u001b\u000b\t\t-\u0014\u0011C\u0001\u0007a>d\u0017nY=\n\t\t=$\u0011\u000e\u0002\u0012\u0007J,\u0017\r^3U_BL7\rU8mS\u000eL\u0018!F2sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds~#S-\u001d\u000b\u0005\u0003[\u0013)\bC\u0005\u00026&\n\t\u00111\u0001\u0003d\u0005\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0003E\tG\u000e^3s\u0007>tg-[4Q_2L7-_\u000b\u0003\u0005{\u0002RaUAk\u0005\u007f\u0002BAa\u001a\u0003\u0002&!!1\u0011B5\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-_\u0001\u0016C2$XM]\"p]\u001aLw\rU8mS\u000eLx\fJ3r)\u0011\tiK!#\t\u0013\u0005UF&!AA\u0002\tu\u0014AE1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\u0002\nq#];peVl7i\u001c8ue>dG.\u001a:NKR\u0014\u0018nY:\u0016\u0005\tE\u0005\u0003\u0002BJ\u00057k!A!&\u000b\t\u0005=!q\u0013\u0006\u0004\u00053[\u0017AC2p]R\u0014x\u000e\u001c7fe&!!Q\u0014BK\u0005]\tVo\u001c:v[\u000e{g\u000e\u001e:pY2,'/T3ue&\u001c7/A\u000erk>\u0014X/\\\"p]R\u0014x\u000e\u001c7fe6+GO]5dg~#S-\u001d\u000b\u0005\u0003[\u0013\u0019\u000bC\u0005\u00026>\n\t\u00111\u0001\u0003\u0012\u0006A\u0012/^8sk6\u001cuN\u001c;s_2dWM]'fiJL7m\u001d\u0011)\u0007A\ni/\u0006\u0002\u0003,B!!Q\u0016BX\u001b\t\u00119*\u0003\u0003\u00032\n]%AC\"p]R\u0014x\u000e\u001c7fe\u0006q1m\u001c8ue>dG.\u001a:`I\u0015\fH\u0003BAW\u0005oC\u0011\"!.3\u0003\u0003\u0005\rAa+\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\u000ecV|G/Y'b]\u0006<WM]:\u0016\u0005\t}\u0006\u0003\u0002Ba\u0005\u000ftA!!%\u0003D&\u0019!Q\u0019'\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\t\t%'1\u001a\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0007\t\u0015G*A\trk>$\u0018-T1oC\u001e,'o]0%KF$B!!,\u0003R\"I\u0011QW\u001b\u0002\u0002\u0003\u0007!qX\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u0003i\u0019G.[3oiF+x\u000e^1NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\t\u0011I\u000e\u0005\u0003\u0003\\\n}WB\u0001Bo\u0015\tQG*\u0003\u0003\u0003b\nu'AG\"mS\u0016tG/U;pi\u0006lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018AH2mS\u0016tG/U;pi\u0006lU\r^1eCR\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\tiKa:\t\u0013\u0005U\u0006(!AA\u0002\te\u0017aG2mS\u0016tG/U;pi\u0006lU\r^1eCR\fW*\u00198bO\u0016\u0014\b%\u0001\bd_:$(o\u001c7mKJ\f\u0005/[:\u0016\u0005\t=\bcA1\u0003r&\u0019!1\u001f'\u0003\u001d\r{g\u000e\u001e:pY2,'/\u00119jg\u0006\u00112m\u001c8ue>dG.\u001a:Ba&\u001cx\fJ3r)\u0011\tiK!?\t\u0013\u0005U6(!AA\u0002\t=\u0018aD2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d\u0011\u00023\r|g\u000e\u001e:pY2,'/\u00119jg\"\u000bg\u000e\u001a7feB{w\u000e\\\u000b\u0003\u0007\u0003\u00012!YB\u0002\u0013\r\u0019)\u0001\u0014\u0002\u0018\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM\u001d)p_2\fQdY8oiJ|G\u000e\\3s\u0003BL7\u000fS1oI2,'\u000fU8pY~#S-\u001d\u000b\u0005\u0003[\u001bY\u0001C\u0005\u00026z\n\t\u00111\u0001\u0004\u0002\u0005Q2m\u001c8ue>dG.\u001a:Ba&\u001c\b*\u00198eY\u0016\u0014\bk\\8mA\u0005\u0001R.[4sCRLwN\\*vaB|'\u000f^\u000b\u0003\u0007'\u0001RaUAk\u0007+\u00012!YB\f\u0013\r\u0019I\u0002\u0014\u0002\u001b\u0007>tGO]8mY\u0016\u0014X*[4sCRLwN\\*vaB|'\u000f^\u0001\u0015[&<'/\u0019;j_:\u001cV\u000f\u001d9peR|F%Z9\u0015\t\u000556q\u0004\u0005\n\u0003k\u000b\u0015\u0011!a\u0001\u0007'\t\u0011#\\5he\u0006$\u0018n\u001c8TkB\u0004xN\u001d;!\u0003IY\u0017MZ6b3\u0006lW.\u001a:NKR\u0014\u0018nY:\u0016\u0005\r\u001d\u0002\u0003BA\u0006\u0007SIAaa\u000b\u0002\u000e\t\u00112*\u00194lCf\u000bW.\\3s\u001b\u0016$(/[2t\u0003IiW\r^1eCR\f\u0007+\u001e2mSNDWM]:\u0016\u0005\rE\u0002CBB\u001a\u0007k\u0019I$\u0004\u0002\u0002p%!1qGA8\u0005\u0011a\u0015n\u001d;\u0011\t\rm2QI\u0007\u0003\u0007{QAaa\u0010\u0004B\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0004\u0007\u0007Z\u0017!B5nC\u001e,\u0017\u0002BB$\u0007{\u0011\u0011#T3uC\u0012\fG/\u0019)vE2L7\u000f[3s\u0003MiW\r^1eCR\f\u0007+\u001e2mSNDWM]:!\u0003Ei\u0017-\u001f2f\u0007\"\fgnZ3Ti\u0006$Xo\u001d\u000b\u0007\u0007\u001f\u001a)f!\u0017\u0011\u0007M\u001b\t&C\u0002\u0004TQ\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0004X\u0019\u0003\r!!$\u0002\t\u0019\u0014x.\u001c\u0005\b\u000772\u0005\u0019AAG\u0003\t!x.A\u0005dYV\u001cH/\u001a:JIV\u00111\u0011\r\t\u0005\u0007G\u001aYG\u0004\u0003\u0004f\r\u001d\u0004cAAK)&\u00191\u0011\u000e+\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019iga\u001c\u0003\rM#(/\u001b8h\u0015\r\u0019I\u0007V\u0001\bgR\f'\u000f^;q)\t\ti+\u0001\u0005tQV$Hm\\<o\u00035\tw/Y5u'\",H\u000fZ8x]\u0002")
public class ControllerServer
implements Logging {
    private final SharedServer sharedServer;
    private final KafkaConfigSchema configSchema;
    private final BootstrapMetadata bootstrapMetadata;
    private final KafkaMetricsGroup metricsGroup;
    private final KafkaConfig config;
    private final Time time;
    private final ReentrantLock lock;
    private final Condition awaitShutdownCond;
    private Server.ProcessStatus status;
    private LinuxIoMetricsCollector linuxIoMetricsCollector;
    private volatile Option<Authorizer> authorizer;
    private DelegationTokenCache tokenCache;
    private CredentialProvider credentialProvider;
    private SocketServer socketServer;
    private final CompletableFuture<Integer> socketServerFirstBoundPortFuture;
    private Option<CreateTopicPolicy> createTopicPolicy;
    private Option<AlterConfigPolicy> alterConfigPolicy;
    private volatile QuorumControllerMetrics quorumControllerMetrics;
    private Controller controller;
    private QuotaFactory.QuotaManagers quotaManagers;
    private ClientQuotaMetadataManager clientQuotaMetadataManager;
    private ControllerApis controllerApis;
    private KafkaRequestHandlerPool controllerApisHandlerPool;
    private Option<ControllerMigrationSupport> migrationSupport;
    private final List<MetadataPublisher> metadataPublishers;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SharedServer sharedServer() {
        return this.sharedServer;
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.sharedServer().metrics();
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.sharedServer().raftManager();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition awaitShutdownCond() {
        return this.awaitShutdownCond;
    }

    public Server.ProcessStatus status() {
        return this.status;
    }

    public void status_$eq(Server.ProcessStatus x$1) {
        this.status = x$1;
    }

    public LinuxIoMetricsCollector linuxIoMetricsCollector() {
        return this.linuxIoMetricsCollector;
    }

    public void linuxIoMetricsCollector_$eq(LinuxIoMetricsCollector x$1) {
        this.linuxIoMetricsCollector = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CompletableFuture<Integer> socketServerFirstBoundPortFuture() {
        return this.socketServerFirstBoundPortFuture;
    }

    public Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    public void createTopicPolicy_$eq(Option<CreateTopicPolicy> x$1) {
        this.createTopicPolicy = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public void alterConfigPolicy_$eq(Option<AlterConfigPolicy> x$1) {
        this.alterConfigPolicy = x$1;
    }

    public QuorumControllerMetrics quorumControllerMetrics() {
        return this.quorumControllerMetrics;
    }

    public void quorumControllerMetrics_$eq(QuorumControllerMetrics x$1) {
        this.quorumControllerMetrics = x$1;
    }

    public Controller controller() {
        return this.controller;
    }

    public void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    public ClientQuotaMetadataManager clientQuotaMetadataManager() {
        return this.clientQuotaMetadataManager;
    }

    public void clientQuotaMetadataManager_$eq(ClientQuotaMetadataManager x$1) {
        this.clientQuotaMetadataManager = x$1;
    }

    public ControllerApis controllerApis() {
        return this.controllerApis;
    }

    public void controllerApis_$eq(ControllerApis x$1) {
        this.controllerApis = x$1;
    }

    public KafkaRequestHandlerPool controllerApisHandlerPool() {
        return this.controllerApisHandlerPool;
    }

    public void controllerApisHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.controllerApisHandlerPool = x$1;
    }

    public Option<ControllerMigrationSupport> migrationSupport() {
        return this.migrationSupport;
    }

    public void migrationSupport_$eq(Option<ControllerMigrationSupport> x$1) {
        this.migrationSupport = x$1;
    }

    public KafkaYammerMetrics kafkaYammerMetrics() {
        return KafkaYammerMetrics.INSTANCE;
    }

    public List<MetadataPublisher> metadataPublishers() {
        return this.metadataPublishers;
    }

    private boolean maybeChangeStatus(Server.ProcessStatus from, Server.ProcessStatus to) {
        block9: {
            boolean bl;
            block8: {
                this.lock().lock();
                try {
                    Server.ProcessStatus processStatus = this.status();
                    if (processStatus == null ? from != null : !processStatus.equals(from)) {
                        bl = false;
                        break block8;
                    }
                    this.status_$eq(to);
                    Server.ProcessStatus processStatus2 = to;
                    Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                    if (processStatus2 == null) {
                        if (server$SHUTDOWN$ != null) {
                            break block9;
                        }
                    } else if (!processStatus2.equals(server$SHUTDOWN$)) break block9;
                    this.awaitShutdownCond().signalAll();
                    break block9;
                }
                finally {
                    this.lock().unlock();
                }
            }
            return bl;
        }
        return true;
    }

    public String clusterId() {
        return this.sharedServer().metaProps().clusterId();
    }

    public void startup() {
        if (!this.maybeChangeStatus(Server$SHUTDOWN$.MODULE$, Server$STARTING$.MODULE$)) {
            return;
        }
        Deadline startupDeadline = Deadline.fromDelay((Time)this.time(), (long)Predef$.MODULE$.Long2long(this.config().serverMaxStartupTimeMs()), (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            Authorizer a;
            scala.collection.immutable.Map map;
            this.logIdent_$eq(new LogContext(new StringBuilder(23).append("[ControllerServer id=").append(this.config().nodeId()).append("] ").toString()).logPrefix());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting controller");
            this.config().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.metricsGroup().newGauge("ClusterId", (Gauge)new Gauge<String>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final String value() {
                    return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$2();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.metricsGroup().newGauge("yammer-metrics-count", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final int value() {
                    return ControllerServer.kafka$server$ControllerServer$$$anonfun$startup$4();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.linuxIoMetricsCollector_$eq(new LinuxIoMetricsCollector("/proc", this.time(), this.logger().underlying()));
            if (this.linuxIoMetricsCollector().usable()) {
                this.metricsGroup().newGauge("linux-disk-read-bytes", (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$6();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.metricsGroup().newGauge("linux-disk-write-bytes", (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$8();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            List javaListeners = (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.config().controllerListeners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), Seq$.MODULE$.canBuildFrom())).asJava();
            this.authorizer_$eq(this.config().createNewAuthorizer());
            this.authorizer().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.configure(this.config().originals());
                return BoxedUnit.UNIT;
            });
            Option<Authorizer> option = this.authorizer();
            if (option instanceof Some) {
                Authorizer authZ = (Authorizer)((Some)option).value();
                Broker.ServerInfo controllerAuthorizerInfo = new Broker.ServerInfo(new ClusterResource(this.clusterId()), this.config().nodeId(), javaListeners, (Endpoint)javaListeners.get(0), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.config().earlyStartListeners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Set$.MODULE$.canBuildFrom())).asJava());
                map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(authZ.start((AuthorizerServerInfo)controllerAuthorizerInfo)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Endpoint ep = (Endpoint)x0$1._1();
                    CompletionStage cs = (CompletionStage)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), cs.toCompletableFuture());
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else if (None$.MODULE$.equals(option)) {
                map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(javaListeners).asScala()).map((Function1 & Serializable & scala.Serializable)ep -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ep), CompletableFuture.completedFuture(null)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else {
                throw new MatchError(option);
            }
            SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER, Predef$.MODULE$.Boolean2boolean(this.config().unstableApiVersionsEnabled()), this.config().migrationEnabled());
            this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
            this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
            this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), apiVersionManager));
            if (!this.config().controllerListeners().nonEmpty()) {
                throw new ConfigException("No controller.listener.names defined for controller");
            }
            this.socketServerFirstBoundPortFuture().complete(Predef$.MODULE$.int2Integer(this.socketServer().boundPort(((EndPoint)this.config().controllerListeners().head()).listenerName())));
            this.sharedServer().startForController();
            this.createTopicPolicy_$eq((Option<CreateTopicPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class)));
            this.alterConfigPolicy_$eq((Option<AlterConfigPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class)));
            List controllerNodes = RaftConfig.voterConnectionsToNodes((java.util.Map)((java.util.Map)FutureUtils.waitWithLogging((Logger)this.logger().underlying(), (String)this.logIdent(), (String)"controller quorum voters future", this.sharedServer().controllerQuorumVotersFuture(), (Deadline)startupDeadline, (Time)this.time())));
            QuorumFeatures quorumFeatures = QuorumFeatures.create((int)this.config().nodeId(), (ApiVersions)this.sharedServer().raftManager().apiVersions(), (java.util.Map)QuorumFeatures.defaultFeatureMap(), (Collection)controllerNodes);
            OptionalLong leaderImbalanceCheckIntervalNs = Predef$.MODULE$.Boolean2boolean(this.config().autoLeaderRebalanceEnable()) ? OptionalLong.of(TimeUnit.NANOSECONDS.convert(this.config().leaderImbalanceCheckIntervalSeconds(), TimeUnit.SECONDS)) : OptionalLong.empty();
            OptionalLong maxIdleIntervalNs = (OptionalLong)this.config().metadataMaxIdleIntervalNs().fold((Function0 & Serializable & scala.Serializable)() -> OptionalLong.empty(), (Function1 & Serializable & scala.Serializable)x$1 -> ControllerServer.$anonfun$startup$16(BoxesRunTime.unboxToLong((Object)x$1)));
            this.quorumControllerMetrics_$eq(new QuorumControllerMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), this.time()));
            QuorumController.Builder controllerBuilder = new QuorumController.Builder(this.config().nodeId(), this.sharedServer().metaProps().clusterId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(19).append("quorum-controller-").append(this.config().nodeId()).append("-").toString()).setConfigSchema(this.configSchema()).setRaftClient(this.raftManager().client()).setQuorumFeatures(quorumFeatures).setDefaultReplicationFactor((short)this.config().defaultReplicationFactor()).setDefaultNumPartitions(this.config().numPartitions().intValue()).setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(this.config().brokerSessionTimeoutMs(), TimeUnit.MILLISECONDS)).setLeaderImbalanceCheckIntervalNs(leaderImbalanceCheckIntervalNs).setMaxIdleIntervalNs(maxIdleIntervalNs).setMetrics(this.quorumControllerMetrics()).setCreateTopicPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.createTopicPolicy()))).setAlterConfigPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.alterConfigPolicy()))).setConfigurationValidator((ConfigurationValidator)new ControllerConfigurationValidator()).setStaticConfig(this.config().originals()).setBootstrapMetadata(this.bootstrapMetadata()).setFatalFaultHandler(this.sharedServer().quorumControllerFaultHandler()).setZkMigrationEnabled(this.config().migrationEnabled());
            Option<Authorizer> option2 = this.authorizer();
            if (option2 instanceof Some && (a = (Authorizer)((Some)option2).value()) instanceof ClusterMetadataAuthorizer) {
                ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)a;
                controllerBuilder.setAuthorizer(clusterMetadataAuthorizer);
            }
            this.controller_$eq((Controller)controllerBuilder.build());
            if (this.config().migrationEnabled()) {
                PasswordEncoder passwordEncoder;
                KafkaZkClient zkClient = KafkaZkClient$.MODULE$.createZkClient("KRaft Migration", this.time(), this.config(), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(this.config(), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2()));
                Option<Password> option3 = this.config().passwordEncoderSecret();
                if (option3 instanceof Some) {
                    Password secret = (Password)((Some)option3).value();
                    passwordEncoder = PasswordEncoder$.MODULE$.encrypting(secret, this.config().passwordEncoderKeyFactoryAlgorithm(), this.config().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.config().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.config().passwordEncoderIterations()));
                } else if (None$.MODULE$.equals(option3)) {
                    passwordEncoder = PasswordEncoder$.MODULE$.noop();
                } else {
                    throw new MatchError(option3);
                }
                ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, passwordEncoder);
                MigrationPropagator propagator = new MigrationPropagator(this.config().nodeId(), this.config());
                KRaftMigrationDriver migrationDriver = new KRaftMigrationDriver(this.config().nodeId(), ((QuorumController)this.controller()).zkRecordConsumer(), (MigrationClient)migrationClient, (LegacyPropagator)propagator, publisher -> this.sharedServer().loader().installPublishers(Collections.singletonList(publisher)), this.sharedServer().faultHandlerFactory().build("zk migration", false, () -> {}), quorumFeatures);
                migrationDriver.start();
                this.migrationSupport_$eq((Option<ControllerMigrationSupport>)new Some((Object)new ControllerMigrationSupport(zkClient, migrationDriver, propagator)));
            }
            this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), this.time(), new StringBuilder(12).append("controller-").append(this.config().nodeId()).append("-").toString()));
            this.clientQuotaMetadataManager_$eq(new ClientQuotaMetadataManager(this.quotaManagers(), this.socketServer().connectionQuotas()));
            this.controllerApis_$eq(new ControllerApis(this.socketServer().dataPlaneRequestChannel(), this.authorizer(), this.quotaManagers(), this.time(), this.controller(), this.raftManager(), this.config(), this.sharedServer().metaProps(), (Seq<Node>)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(controllerNodes).asScala()).toSeq(), apiVersionManager));
            this.controllerApisHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().nodeId(), this.socketServer().dataPlaneRequestChannel(), this.controllerApis(), this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), DataPlaneAcceptor$.MODULE$.ThreadPrefix()));
            CompletableFuture<Void> socketServerFuture = this.socketServer().enableRequestProcessing((Map<Endpoint, CompletableFuture<Void>>)map);
            FutureUtils.waitWithLogging((Logger)this.logger().underlying(), (String)this.logIdent(), (String)"all of the authorizer futures to be completed", CompletableFuture.allOf((CompletableFuture[])map.values().toSeq().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))), (Deadline)startupDeadline, (Time)this.time());
            FutureUtils.waitWithLogging((Logger)this.logger().underlying(), (String)this.logIdent(), (String)"all of the SocketServer Acceptors to be started", socketServerFuture, (Deadline)startupDeadline, (Time)this.time());
            this.config().dynamicConfig().addReconfigurables(this);
            this.metadataPublishers().add(new DynamicConfigPublisher(this.config(), this.sharedServer().metadataPublishingFaultHandler(), (scala.collection.immutable.Map<String, ConfigHandler>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Broker()), (Object)new BrokerConfigHandler(this.config(), this.quotaManagers()))}))), "controller"));
            this.metadataPublishers().add(new DynamicClientQuotaPublisher(this.config(), this.sharedServer().metadataPublishingFaultHandler(), "controller", this.clientQuotaMetadataManager()));
            this.metadataPublishers().add(new ScramPublisher(this.config(), this.sharedServer().metadataPublishingFaultHandler(), "controller", this.credentialProvider()));
            this.metadataPublishers().add((MetadataPublisher)new ControllerMetadataMetricsPublisher(this.sharedServer().controllerServerMetrics(), this.sharedServer().metadataPublishingFaultHandler()));
            FutureUtils.waitWithLogging((Logger)this.logger().underlying(), (String)this.logIdent(), (String)"the controller metadata publishers to be installed", (CompletableFuture)this.sharedServer().loader().installPublishers(this.metadataPublishers()), (Deadline)startupDeadline, (Time)this.time());
            return;
        }
        catch (Throwable e) {
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.sharedServer().controllerStartupFaultHandler().handleFault("caught exception", e);
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        if (!this.maybeChangeStatus(Server$STARTED$.MODULE$, Server$SHUTTING_DOWN$.MODULE$)) {
            return;
        }
        try {
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
                this.sharedServer().ensureNotRaftLeader();
                this.metadataPublishers().forEach(p -> this.sharedServer().loader().removeAndClosePublisher(p).get());
                this.metadataPublishers().clear();
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().stopProcessingRequests(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                this.migrationSupport().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.shutdown(this);
                    return BoxedUnit.UNIT;
                });
                if (this.controller() != null) {
                    this.controller().beginShutdown();
                }
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controllerApisHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerApisHandlerPool().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controllerApis() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerApis().close(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.quotaManagers() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.quotaManagers().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controller() != null) {
                    this.controller().close();
                }
                if (this.quorumControllerMetrics() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.quorumControllerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.authorizer().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.close();
                    return BoxedUnit.UNIT;
                }), this, CoreUtils$.MODULE$.swallow$default$3());
                this.createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> policy.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                    return BoxedUnit.UNIT;
                });
                this.alterConfigPolicy().foreach((Function1 & Serializable & scala.Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> policy.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                    return BoxedUnit.UNIT;
                });
                this.socketServerFirstBoundPortFuture().completeExceptionally(new RuntimeException("shutting down"));
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.config().dynamicConfig().clear(), this, CoreUtils$.MODULE$.swallow$default$3());
                this.sharedServer().stopForController();
            }
            catch (Throwable e) {
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fatal error during controller shutdown.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.maybeChangeStatus(Server$SHUTTING_DOWN$.MODULE$, Server$SHUTDOWN$.MODULE$);
        }
    }

    public void awaitShutdown() {
        this.lock().lock();
        try {
            while (true) {
                Server.ProcessStatus processStatus = this.status();
                Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                if (processStatus == null ? server$SHUTDOWN$ != null : !processStatus.equals(server$SHUTDOWN$)) {
                    this.awaitShutdownCond().awaitUninterruptibly();
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public final /* synthetic */ String kafka$server$ControllerServer$$$anonfun$startup$2() {
        return this.clusterId();
    }

    public static final /* synthetic */ int kafka$server$ControllerServer$$$anonfun$startup$4() {
        return KafkaYammerMetrics.defaultRegistry().allMetrics().size();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$6() {
        return this.linuxIoMetricsCollector().readBytes();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$8() {
        return this.linuxIoMetricsCollector().writeBytes();
    }

    public static final /* synthetic */ OptionalLong $anonfun$startup$16(long x$1) {
        return OptionalLong.of(x$1);
    }

    public ControllerServer(SharedServer sharedServer, KafkaConfigSchema configSchema, BootstrapMetadata bootstrapMetadata) {
        this.sharedServer = sharedServer;
        this.configSchema = configSchema;
        this.bootstrapMetadata = bootstrapMetadata;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.config = sharedServer.controllerConfig();
        this.time = sharedServer.time();
        this.lock = new ReentrantLock();
        this.awaitShutdownCond = this.lock().newCondition();
        this.status = Server$SHUTDOWN$.MODULE$;
        this.authorizer = None$.MODULE$;
        this.socketServerFirstBoundPortFuture = new CompletableFuture();
        this.createTopicPolicy = None$.MODULE$;
        this.alterConfigPolicy = None$.MODULE$;
        this.migrationSupport = None$.MODULE$;
        this.metadataPublishers = new ArrayList<MetadataPublisher>();
    }
}

