/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.cluster.Partition;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.log.remote.RemoteIndexCache;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RemoteLogInputStream;
import org.apache.kafka.common.utils.ChildFirstClassLoader;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.metadata.storage.ClassLoaderAwareRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.ClassLoaderAwareRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.LogSegmentData;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.storage.internals.checkpoint.InMemoryLeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;

public class RemoteLogManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLogManager.class);
    private final RemoteLogManagerConfig rlmConfig;
    private final int brokerId;
    private final String logDir;
    private final Time time;
    private final Function<TopicPartition, Optional<UnifiedLog>> fetchLog;
    private final RemoteStorageManager remoteLogStorageManager;
    private final RemoteLogMetadataManager remoteLogMetadataManager;
    private final RemoteIndexCache indexCache;
    private final RLMScheduledThreadPool rlmScheduledThreadPool;
    private final long delayInMs;
    private final ConcurrentHashMap<TopicIdPartition, RLMTaskWithFuture> leaderOrFollowerTasks = new ConcurrentHashMap();
    private final ConcurrentMap<TopicPartition, Uuid> topicPartitionIds = new ConcurrentHashMap<TopicPartition, Uuid>();
    private boolean closed = false;

    public RemoteLogManager(RemoteLogManagerConfig rlmConfig, int brokerId, String logDir, Time time, Function<TopicPartition, Optional<UnifiedLog>> fetchLog) {
        this.rlmConfig = rlmConfig;
        this.brokerId = brokerId;
        this.logDir = logDir;
        this.time = time;
        this.fetchLog = fetchLog;
        this.remoteLogStorageManager = this.createRemoteStorageManager();
        this.remoteLogMetadataManager = this.createRemoteLogMetadataManager();
        this.indexCache = new RemoteIndexCache(1024, this.remoteLogStorageManager, logDir);
        this.delayInMs = rlmConfig.remoteLogManagerTaskIntervalMs();
        this.rlmScheduledThreadPool = new RLMScheduledThreadPool(rlmConfig.remoteLogManagerThreadPoolSize());
    }

    private <T> T createDelegate(ClassLoader classLoader, String className) {
        try {
            return (T)classLoader.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    RemoteStorageManager createRemoteStorageManager() {
        return AccessController.doPrivileged(new PrivilegedAction<RemoteStorageManager>(){
            private final String classPath;
            {
                this.classPath = RemoteLogManager.this.rlmConfig.remoteStorageManagerClassPath();
            }

            @Override
            public RemoteStorageManager run() {
                if (this.classPath != null && !this.classPath.trim().isEmpty()) {
                    ChildFirstClassLoader classLoader = new ChildFirstClassLoader(this.classPath, this.getClass().getClassLoader());
                    RemoteStorageManager delegate = (RemoteStorageManager)RemoteLogManager.this.createDelegate((ClassLoader)classLoader, RemoteLogManager.this.rlmConfig.remoteStorageManagerClassName());
                    return new ClassLoaderAwareRemoteStorageManager(delegate, (ClassLoader)classLoader);
                }
                return (RemoteStorageManager)RemoteLogManager.this.createDelegate(this.getClass().getClassLoader(), RemoteLogManager.this.rlmConfig.remoteStorageManagerClassName());
            }
        });
    }

    private void configureRSM() {
        HashMap<String, Integer> rsmProps = new HashMap<String, Integer>(this.rlmConfig.remoteStorageManagerProps());
        rsmProps.put(KafkaConfig.BrokerIdProp(), this.brokerId);
        this.remoteLogStorageManager.configure(rsmProps);
    }

    RemoteLogMetadataManager createRemoteLogMetadataManager() {
        return AccessController.doPrivileged(new PrivilegedAction<RemoteLogMetadataManager>(){
            private String classPath;
            {
                this.classPath = RemoteLogManager.this.rlmConfig.remoteLogMetadataManagerClassPath();
            }

            @Override
            public RemoteLogMetadataManager run() {
                if (this.classPath != null && !this.classPath.trim().isEmpty()) {
                    ChildFirstClassLoader classLoader = new ChildFirstClassLoader(this.classPath, this.getClass().getClassLoader());
                    RemoteLogMetadataManager delegate = (RemoteLogMetadataManager)RemoteLogManager.this.createDelegate((ClassLoader)classLoader, RemoteLogManager.this.rlmConfig.remoteLogMetadataManagerClassName());
                    return new ClassLoaderAwareRemoteLogMetadataManager(delegate, (ClassLoader)classLoader);
                }
                return (RemoteLogMetadataManager)RemoteLogManager.this.createDelegate(this.getClass().getClassLoader(), RemoteLogManager.this.rlmConfig.remoteLogMetadataManagerClassName());
            }
        });
    }

    private void configureRLMM() {
        HashMap<String, Object> rlmmProps = new HashMap<String, Object>(this.rlmConfig.remoteLogMetadataManagerProps());
        rlmmProps.put(KafkaConfig.BrokerIdProp(), this.brokerId);
        rlmmProps.put(KafkaConfig.LogDirProp(), this.logDir);
        this.remoteLogMetadataManager.configure(rlmmProps);
    }

    public void startup() {
        this.configureRSM();
        this.configureRLMM();
    }

    public RemoteStorageManager storageManager() {
        return this.remoteLogStorageManager;
    }

    private Stream<Partition> filterPartitions(Set<Partition> partitions) {
        return partitions.stream().filter(partition -> partition.log().exists(UnifiedLog::remoteLogEnabled));
    }

    private void cacheTopicPartitionIds(TopicIdPartition topicIdPartition) {
        Uuid previousTopicId = this.topicPartitionIds.put(topicIdPartition.topicPartition(), topicIdPartition.topicId());
        if (previousTopicId != null && previousTopicId != topicIdPartition.topicId()) {
            LOGGER.info("Previous cached topic id {} for {} does not match updated topic id {}", new Object[]{previousTopicId, topicIdPartition.topicPartition(), topicIdPartition.topicId()});
        }
    }

    public RLMScheduledThreadPool rlmScheduledThreadPool() {
        return this.rlmScheduledThreadPool;
    }

    public void onLeadershipChange(Set<Partition> partitionsBecomeLeader, Set<Partition> partitionsBecomeFollower, Map<String, Uuid> topicIds) {
        LOGGER.debug("Received leadership changes for leaders: {} and followers: {}", partitionsBecomeLeader, partitionsBecomeFollower);
        Map<TopicIdPartition, Integer> leaderPartitionsWithLeaderEpoch = this.filterPartitions(partitionsBecomeLeader).collect(Collectors.toMap(partition -> new TopicIdPartition((Uuid)topicIds.get(partition.topic()), partition.topicPartition()), partition -> partition.getLeaderEpoch()));
        Set<TopicIdPartition> leaderPartitions = leaderPartitionsWithLeaderEpoch.keySet();
        Set<TopicIdPartition> followerPartitions = this.filterPartitions(partitionsBecomeFollower).map(p -> new TopicIdPartition((Uuid)topicIds.get(p.topic()), p.topicPartition())).collect(Collectors.toSet());
        if (!leaderPartitions.isEmpty() || !followerPartitions.isEmpty()) {
            LOGGER.debug("Effective topic partitions after filtering compact and internal topics, leaders: {} and followers: {}", leaderPartitions, followerPartitions);
            leaderPartitions.forEach(this::cacheTopicPartitionIds);
            followerPartitions.forEach(this::cacheTopicPartitionIds);
            this.remoteLogMetadataManager.onPartitionLeadershipChanges(leaderPartitions, followerPartitions);
            followerPartitions.forEach(topicIdPartition -> this.doHandleLeaderOrFollowerPartitions((TopicIdPartition)topicIdPartition, rlmTask -> rlmTask.convertToFollower()));
            leaderPartitionsWithLeaderEpoch.forEach((topicIdPartition, leaderEpoch) -> this.doHandleLeaderOrFollowerPartitions((TopicIdPartition)topicIdPartition, rlmTask -> rlmTask.convertToLeader((int)leaderEpoch)));
        }
    }

    public void stopPartitions(TopicPartition topicPartition, boolean delete) {
        if (delete) {
            Uuid topicIdPartition = (Uuid)this.topicPartitionIds.remove(topicPartition);
            LOGGER.debug("Removed partition: {} from topicPartitionIds", (Object)topicIdPartition);
        }
    }

    public Optional<RemoteLogSegmentMetadata> fetchRemoteLogSegmentMetadata(TopicPartition topicPartition, int epochForOffset, long offset) throws RemoteStorageException {
        Uuid topicId = (Uuid)this.topicPartitionIds.get(topicPartition);
        if (topicId == null) {
            throw new KafkaException("No topic id registered for topic partition: " + topicPartition);
        }
        return this.remoteLogMetadataManager.remoteLogSegmentMetadata(new TopicIdPartition(topicId, topicPartition), epochForOffset, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<FileRecords.TimestampAndOffset> lookupTimestamp(RemoteLogSegmentMetadata rlsMetadata, long timestamp, long startingOffset) throws RemoteStorageException, IOException {
        block5: {
            startPos = this.indexCache.lookupTimestamp(rlsMetadata, timestamp, startingOffset);
            remoteSegInputStream = null;
            try {
                remoteSegInputStream = this.remoteLogStorageManager.fetchLogSegment(rlsMetadata, startPos);
                remoteLogInputStream = new RemoteLogInputStream(remoteSegInputStream);
                while ((batch = remoteLogInputStream.nextBatch()) != null) {
                    if (batch.maxTimestamp() < timestamp || batch.lastOffset() < startingOffset) continue;
                    for (Record record : batch) {
                        if (record.timestamp() < timestamp || record.offset() < startingOffset) continue;
                        var12_10 = Optional.of(new FileRecords.TimestampAndOffset(record.timestamp(), record.offset(), this.maybeLeaderEpoch(batch.partitionLeaderEpoch())));
                        break block5;
                    }
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var13_11) {
                Utils.closeQuietly(remoteSegInputStream, (String)"RemoteLogSegmentInputStream");
                throw var13_11;
            }
        }
        Utils.closeQuietly((AutoCloseable)remoteSegInputStream, (String)"RemoteLogSegmentInputStream");
        return var12_10;
lbl-1000:
        // 1 sources

        {
            var9_7 = Optional.empty();
        }
        Utils.closeQuietly((AutoCloseable)remoteSegInputStream, (String)"RemoteLogSegmentInputStream");
        return var9_7;
    }

    private Optional<Integer> maybeLeaderEpoch(int leaderEpoch) {
        return leaderEpoch == -1 ? Optional.empty() : Optional.of(leaderEpoch);
    }

    public Optional<FileRecords.TimestampAndOffset> findOffsetByTimestamp(TopicPartition tp, long timestamp, long startingOffset, LeaderEpochFileCache leaderEpochCache) throws RemoteStorageException, IOException {
        Uuid topicId = (Uuid)this.topicPartitionIds.get(tp);
        if (topicId == null) {
            throw new KafkaException("Topic id does not exist for topic partition: " + tp);
        }
        OptionalInt maybeEpoch = leaderEpochCache.epochForOffset(startingOffset);
        while (maybeEpoch.isPresent()) {
            int epoch = maybeEpoch.getAsInt();
            Iterator iterator = this.remoteLogMetadataManager.listRemoteLogSegments(new TopicIdPartition(topicId, tp), epoch);
            while (iterator.hasNext()) {
                RemoteLogSegmentMetadata rlsMetadata = (RemoteLogSegmentMetadata)iterator.next();
                if (rlsMetadata.maxTimestampMs() < timestamp || rlsMetadata.endOffset() < startingOffset) continue;
                return this.lookupTimestamp(rlsMetadata, timestamp, startingOffset);
            }
            maybeEpoch = leaderEpochCache.nextEpoch(epoch);
        }
        return Optional.empty();
    }

    InMemoryLeaderEpochCheckpoint getLeaderEpochCheckpoint(UnifiedLog log, long startOffset, long endOffset) {
        InMemoryLeaderEpochCheckpoint checkpoint = new InMemoryLeaderEpochCheckpoint();
        if (log.leaderEpochCache().isDefined()) {
            LeaderEpochFileCache cache = ((LeaderEpochFileCache)log.leaderEpochCache().get()).writeTo((LeaderEpochCheckpoint)checkpoint);
            if (startOffset >= 0L) {
                cache.truncateFromStart(startOffset);
            }
            cache.truncateFromEnd(endOffset);
        }
        return checkpoint;
    }

    long findHighestRemoteOffset(TopicIdPartition topicIdPartition) throws RemoteStorageException {
        UnifiedLog log;
        Option<LeaderEpochFileCache> maybeLeaderEpochFileCache;
        Optional offset = Optional.empty();
        Optional<UnifiedLog> maybeLog = this.fetchLog.apply(topicIdPartition.topicPartition());
        if (maybeLog.isPresent() && (maybeLeaderEpochFileCache = (log = maybeLog.get()).leaderEpochCache()).isDefined()) {
            LeaderEpochFileCache cache = (LeaderEpochFileCache)maybeLeaderEpochFileCache.get();
            OptionalInt epoch = cache.latestEpoch();
            while (!offset.isPresent() && epoch.isPresent()) {
                offset = this.remoteLogMetadataManager.highestOffsetForEpoch(topicIdPartition, epoch.getAsInt());
                epoch = cache.previousEpoch(epoch.getAsInt());
            }
        }
        return offset.orElse(-1L);
    }

    void doHandleLeaderOrFollowerPartitions(TopicIdPartition topicPartition, Consumer<RLMTask> convertToLeaderOrFollower) {
        RLMTaskWithFuture rlmTaskWithFuture = this.leaderOrFollowerTasks.computeIfAbsent(topicPartition, topicIdPartition -> {
            RLMTask task = new RLMTask((TopicIdPartition)topicIdPartition);
            convertToLeaderOrFollower.accept(task);
            LOGGER.info("Created a new task: {} and getting scheduled", (Object)task);
            ScheduledFuture future = this.rlmScheduledThreadPool.scheduleWithFixedDelay(task, 0L, this.delayInMs, TimeUnit.MILLISECONDS);
            return new RLMTaskWithFuture(task, future);
        });
        convertToLeaderOrFollower.accept(rlmTaskWithFuture.rlmTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RemoteLogManager remoteLogManager = this;
        synchronized (remoteLogManager) {
            if (!this.closed) {
                this.leaderOrFollowerTasks.values().forEach(RLMTaskWithFuture::cancel);
                Utils.closeQuietly((AutoCloseable)this.remoteLogStorageManager, (String)"RemoteLogStorageManager");
                Utils.closeQuietly((AutoCloseable)this.remoteLogMetadataManager, (String)"RemoteLogMetadataManager");
                Utils.closeQuietly((AutoCloseable)this.indexCache, (String)"RemoteIndexCache");
                try {
                    this.rlmScheduledThreadPool.shutdown();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.leaderOrFollowerTasks.clear();
                this.closed = true;
            }
        }
    }

    static class RLMScheduledThreadPool {
        private static final Logger LOGGER = LoggerFactory.getLogger(RLMScheduledThreadPool.class);
        private final int poolSize;
        private final ScheduledThreadPoolExecutor scheduledThreadPool;

        public RLMScheduledThreadPool(int poolSize) {
            this.poolSize = poolSize;
            this.scheduledThreadPool = this.createPool();
        }

        private ScheduledThreadPoolExecutor createPool() {
            ScheduledThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(this.poolSize);
            threadPool.setRemoveOnCancelPolicy(true);
            threadPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            threadPool.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            threadPool.setThreadFactory(new ThreadFactory(){
                private final AtomicInteger sequence = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    return KafkaThread.daemon((String)("kafka-rlm-thread-pool-" + this.sequence.incrementAndGet()), (Runnable)r);
                }
            });
            return threadPool;
        }

        public ScheduledFuture scheduleWithFixedDelay(Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit) {
            LOGGER.info("Scheduling runnable {} with initial delay: {}, fixed delay: {}", new Object[]{runnable, initialDelay, delay});
            return this.scheduledThreadPool.scheduleWithFixedDelay(runnable, initialDelay, delay, timeUnit);
        }

        public boolean shutdown() throws InterruptedException {
            LOGGER.info("Shutting down scheduled thread pool");
            this.scheduledThreadPool.shutdownNow();
            return this.scheduledThreadPool.awaitTermination(2L, TimeUnit.MINUTES);
        }
    }

    static class RLMTaskWithFuture {
        private final RLMTask rlmTask;
        private final Future<?> future;

        RLMTaskWithFuture(RLMTask rlmTask, Future<?> future) {
            this.rlmTask = rlmTask;
            this.future = future;
        }

        public void cancel() {
            this.rlmTask.cancel();
            try {
                this.future.cancel(true);
            }
            catch (Exception ex) {
                LOGGER.error("Error occurred while canceling the task: {}", (Object)this.rlmTask, (Object)ex);
            }
        }
    }

    class RLMTask
    extends CancellableRunnable {
        private final TopicIdPartition topicIdPartition;
        private final Logger logger;
        private volatile int leaderEpoch;
        private volatile OptionalLong copiedOffsetOption;

        public RLMTask(TopicIdPartition topicIdPartition) {
            this.leaderEpoch = -1;
            this.copiedOffsetOption = OptionalLong.empty();
            this.topicIdPartition = topicIdPartition;
            LogContext logContext = new LogContext("[RemoteLogManager=" + RemoteLogManager.this.brokerId + " partition=" + topicIdPartition + "] ");
            this.logger = logContext.logger(RLMTask.class);
        }

        boolean isLeader() {
            return this.leaderEpoch >= 0;
        }

        public void convertToLeader(int leaderEpochVal) {
            if (leaderEpochVal < 0) {
                throw new KafkaException("leaderEpoch value for topic partition " + this.topicIdPartition + " can not be negative");
            }
            if (this.leaderEpoch != leaderEpochVal) {
                this.leaderEpoch = leaderEpochVal;
            }
            this.copiedOffsetOption = OptionalLong.empty();
        }

        public void convertToFollower() {
            this.leaderEpoch = -1;
        }

        private void maybeUpdateReadOffset() throws RemoteStorageException {
            if (!this.copiedOffsetOption.isPresent()) {
                this.logger.info("Find the highest remote offset for partition: {} after becoming leader, leaderEpoch: {}", (Object)this.topicIdPartition, (Object)this.leaderEpoch);
                this.copiedOffsetOption = OptionalLong.of(RemoteLogManager.this.findHighestRemoteOffset(this.topicIdPartition));
            }
        }

        public void copyLogSegmentsToRemote() throws InterruptedException {
            block13: {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    this.maybeUpdateReadOffset();
                    long copiedOffset = this.copiedOffsetOption.getAsLong();
                    Optional maybeLog = (Optional)RemoteLogManager.this.fetchLog.apply(this.topicIdPartition.topicPartition());
                    if (!maybeLog.isPresent()) {
                        return;
                    }
                    UnifiedLog log = (UnifiedLog)maybeLog.get();
                    long lso = log.lastStableOffset();
                    if (lso < 0L) {
                        this.logger.warn("lastStableOffset for partition {} is {}, which should not be negative.", (Object)this.topicIdPartition, (Object)lso);
                    } else if (lso > 0L && copiedOffset < lso) {
                        long toOffset = lso;
                        this.logger.debug("Checking for segments to copy, copiedOffset: {} and toOffset: {}", (Object)copiedOffset, (Object)toOffset);
                        long activeSegBaseOffset = log.activeSegment().baseOffset();
                        long fromOffset = Math.max(copiedOffset + 1L, log.logStartOffset());
                        ArrayList<LogSegment> sortedSegments = new ArrayList<LogSegment>(JavaConverters.asJavaCollection(log.logSegments(fromOffset, toOffset)));
                        sortedSegments.sort(Comparator.comparingLong(LogSegment::baseOffset));
                        List sortedBaseOffsets = sortedSegments.stream().map(x -> x.baseOffset()).collect(Collectors.toList());
                        int activeSegIndex = Collections.binarySearch(sortedBaseOffsets, activeSegBaseOffset);
                        if (activeSegIndex < 0) {
                            this.logger.debug("No segments found to be copied for partition {} with copiedOffset: {} and active segment's base-offset: {}", new Object[]{this.topicIdPartition, copiedOffset, activeSegBaseOffset});
                        } else {
                            ListIterator<LogSegment> logSegmentsIter = sortedSegments.subList(0, activeSegIndex).listIterator();
                            while (logSegmentsIter.hasNext()) {
                                LogSegment segment = (LogSegment)logSegmentsIter.next();
                                if (this.isCancelled() || !this.isLeader()) {
                                    this.logger.info("Skipping copying log segments as the current task state is changed, cancelled: {} leader:{}", (Object)this.isCancelled(), (Object)this.isLeader());
                                    return;
                                }
                                this.copyLogSegment(log, segment, this.getNextSegmentBaseOffset(activeSegBaseOffset, logSegmentsIter));
                            }
                        }
                    } else {
                        this.logger.debug("Skipping copying segments, current read-offset:{}, and LSO:{}", (Object)copiedOffset, (Object)lso);
                    }
                }
                catch (InterruptedException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    if (this.isCancelled()) break block13;
                    this.logger.error("Error occurred while copying log segments of partition: {}", (Object)this.topicIdPartition, (Object)ex);
                }
            }
        }

        private long getNextSegmentBaseOffset(long activeSegBaseOffset, ListIterator<LogSegment> logSegmentsIter) {
            long nextSegmentBaseOffset;
            if (logSegmentsIter.hasNext()) {
                nextSegmentBaseOffset = logSegmentsIter.next().baseOffset();
                logSegmentsIter.previous();
            } else {
                nextSegmentBaseOffset = activeSegBaseOffset;
            }
            return nextSegmentBaseOffset;
        }

        private void copyLogSegment(UnifiedLog log, LogSegment segment, long nextSegmentBaseOffset) throws InterruptedException, ExecutionException, RemoteStorageException, IOException {
            File logFile = segment.log().file();
            String logFileName = logFile.getName();
            this.logger.info("Copying {} to remote storage.", (Object)logFileName);
            RemoteLogSegmentId id = new RemoteLogSegmentId(this.topicIdPartition, Uuid.randomUuid());
            long endOffset = nextSegmentBaseOffset - 1L;
            File producerStateSnapshotFile = log.producerStateManager().fetchSnapshot(nextSegmentBaseOffset).orElse(null);
            List epochEntries = RemoteLogManager.this.getLeaderEpochCheckpoint(log, segment.baseOffset(), nextSegmentBaseOffset).read();
            HashMap segmentLeaderEpochs = new HashMap(epochEntries.size());
            epochEntries.forEach(entry -> segmentLeaderEpochs.put(entry.epoch, entry.startOffset));
            RemoteLogSegmentMetadata copySegmentStartedRlsm = new RemoteLogSegmentMetadata(id, segment.baseOffset(), endOffset, segment.largestTimestamp(), RemoteLogManager.this.brokerId, RemoteLogManager.this.time.milliseconds(), segment.log().sizeInBytes(), segmentLeaderEpochs);
            RemoteLogManager.this.remoteLogMetadataManager.addRemoteLogSegmentMetadata(copySegmentStartedRlsm).get();
            ByteBuffer leaderEpochsIndex = RemoteLogManager.this.getLeaderEpochCheckpoint(log, -1L, nextSegmentBaseOffset).readAsByteBuffer();
            LogSegmentData segmentData = new LogSegmentData(logFile.toPath(), this.toPathIfExists(((OffsetIndex)segment.lazyOffsetIndex().get()).file()), this.toPathIfExists(((TimeIndex)segment.lazyTimeIndex().get()).file()), Optional.ofNullable(this.toPathIfExists(segment.txnIndex().file())), producerStateSnapshotFile.toPath(), leaderEpochsIndex);
            RemoteLogManager.this.remoteLogStorageManager.copyLogSegmentData(copySegmentStartedRlsm, segmentData);
            RemoteLogSegmentMetadataUpdate copySegmentFinishedRlsm = new RemoteLogSegmentMetadataUpdate(id, RemoteLogManager.this.time.milliseconds(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, RemoteLogManager.this.brokerId);
            RemoteLogManager.this.remoteLogMetadataManager.updateRemoteLogSegmentMetadata(copySegmentFinishedRlsm).get();
            this.copiedOffsetOption = OptionalLong.of(endOffset);
            log.updateHighestOffsetInRemoteStorage(endOffset);
            this.logger.info("Copied {} to remote storage with segment-id: {}", (Object)logFileName, (Object)copySegmentFinishedRlsm.remoteLogSegmentId());
        }

        private Path toPathIfExists(File file) {
            return file.exists() ? file.toPath() : null;
        }

        @Override
        public void run() {
            block6: {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    if (this.isLeader()) {
                        this.copyLogSegmentsToRemote();
                    }
                }
                catch (InterruptedException ex) {
                    if (!this.isCancelled()) {
                        this.logger.warn("Current thread for topic-partition-id {} is interrupted, this task won't be rescheduled. Reason: {}", (Object)this.topicIdPartition, (Object)ex.getMessage());
                    }
                }
                catch (Exception ex) {
                    if (this.isCancelled()) break block6;
                    this.logger.warn("Current task for topic-partition {} received error but it will be scheduled. Reason: {}", (Object)this.topicIdPartition, (Object)ex.getMessage());
                }
            }
        }

        public String toString() {
            return this.getClass().toString() + "[" + this.topicIdPartition + "]";
        }
    }

    private static abstract class CancellableRunnable
    implements Runnable {
        private volatile boolean cancelled = false;

        private CancellableRunnable() {
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

