/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.image.node.ClusterImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;

public final class ClusterImage {
    public static final ClusterImage EMPTY = new ClusterImage(Collections.emptyMap());
    private final Map<Integer, BrokerRegistration> brokers;

    public ClusterImage(Map<Integer, BrokerRegistration> brokers) {
        this.brokers = Collections.unmodifiableMap(brokers);
    }

    public boolean isEmpty() {
        return this.brokers.isEmpty();
    }

    public Map<Integer, BrokerRegistration> brokers() {
        return this.brokers;
    }

    public BrokerRegistration broker(int nodeId) {
        return this.brokers.get(nodeId);
    }

    public boolean containsBroker(int brokerId) {
        return this.brokers.containsKey(brokerId);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (BrokerRegistration broker : this.brokers.values()) {
            writer.write(broker.toRecord(options));
        }
    }

    public int hashCode() {
        return this.brokers.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterImage)) {
            return false;
        }
        ClusterImage other = (ClusterImage)o;
        return this.brokers.equals(other.brokers);
    }

    public String toString() {
        return new ClusterImageNode(this).stringify();
    }
}

