/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaAlterLogDirsTierStateMachine;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\n\u0015\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\nY\u0001\u0011\t\u0011)A\u0005[AB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003\"A!\t\u0001B\u0001B\u0003%1\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0003R\u0001\u0011E#\u000bC\u0003d\u0001\u0011EC\rC\u0003j\u0001\u0011E#\u000eC\u0003m\u0001\u0011ES\u000eC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0004\u0002\u001e\u0001!\t%a\b\t\u0013\u0005u\u0002A1A\u0005R\u0005}\u0002\u0002CA$\u0001\u0001\u0006I!!\u0011\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011q\f\u0001\u0005R\u0005\u0005$!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012T!!\u0006\f\u0002\rM,'O^3s\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003QI!!\b\u000b\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006!a.Y7f!\t\u0001\u0013F\u0004\u0002\"OA\u0011!%J\u0007\u0002G)\u0011A\u0005G\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003Q\u0015\na\u0001\\3bI\u0016\u0014\bCA\u000e/\u0013\tyCC\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\n\u00051b\u0012\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\tY2'\u0003\u00025)\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u000e8\u0013\tADC\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005mY\u0014B\u0001\u001f\u0015\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugB\u00111dP\u0005\u0003\u0001R\u0011\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\n\u0005ub\u0012A\u00044fi\u000eD')Y2l\u001f\u001a4Wj\u001d\t\u0003\t\u0016k\u0011!J\u0005\u0003\r\u0016\u00121!\u00138u\u0003\u0019a\u0014N\\5u}QA\u0011JS&M\u001b:{\u0005\u000b\u0005\u0002\u001c\u0001!)a\u0004\u0003a\u0001?!)A\u0006\u0003a\u0001[!)\u0011\u0007\u0003a\u0001e!)Q\u0007\u0003a\u0001m!)\u0011\b\u0003a\u0001u!)Q\b\u0003a\u0001}!)!\t\u0003a\u0001\u0007\u0006YA.\u0019;fgR,\u0005o\\2i)\t\u0019f\u000bE\u0002E)\u000eK!!V\u0013\u0003\r=\u0003H/[8o\u0011\u00159\u0016\u00021\u0001Y\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"!W1\u000e\u0003iS!a\u0017/\u0002\r\r|W.\\8o\u0015\t9RL\u0003\u0002_?\u00061\u0011\r]1dQ\u0016T\u0011\u0001Y\u0001\u0004_J<\u0017B\u00012[\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0002fQB\u0011AIZ\u0005\u0003O\u0016\u0012A\u0001T8oO\")qK\u0003a\u00011\u0006aAn\\4F]\u0012|eMZ:fiR\u0011Qm\u001b\u0005\u0006/.\u0001\r\u0001W\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGc\u00018vmB\u0019A\tV8\u0011\u0005A\u001cX\"A9\u000b\u0005m\u0013(BA\u000b]\u0013\t!\u0018O\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000b]c\u0001\u0019\u0001-\t\u000b]d\u0001\u0019A\"\u0002\u000b\u0015\u0004xn\u00195\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)\u001dQ\u00181BA\u0007\u0003#\u00012\u0001\u0012+|!\ra\u0018qA\u0007\u0002{*\u0011ap`\u0001\u0004Y><'\u0002BA\u0001\u0003\u0007\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005\u0015A,A\u0004ti>\u0014\u0018mZ3\n\u0007\u0005%QPA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\u0006/6\u0001\r\u0001\u0017\u0005\u0007\u0003\u001fi\u0001\u0019A3\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0003'i\u0001\u0019AA\u000b\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!\u0011qCA\r\u001b\u0005\u0001\u0011bAA\u000e9\tIa)\u001a;dQ\u0012\u000bG/Y\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\t\u0005\u0005\u0012Q\u0006\t\u0006\u0003G\tI\u0003W\u0007\u0003\u0003KQ1!a\n&\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003W\t)CA\u0002TKRDq!a\f\u000f\u0001\u0004\t\t$\u0001\nj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\u001c\bcBA\u0012\u0003gA\u0016qG\u0005\u0005\u0003k\t)CA\u0002NCB\u00042aGA\u001d\u0013\r\tY\u0004\u0006\u0002\u0012\u0013:LG/[1m\r\u0016$8\r[*uCR,\u0017aH5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fIV\u0011\u0011\u0011\t\t\u0004\t\u0006\r\u0013bAA#K\t9!i\\8mK\u0006t\u0017\u0001I5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fI\u0002\n\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0007\u0003\u001b\n\u0019&!\u0016\u0011\u0007\u0011\u000by%C\u0002\u0002R\u0015\u0012A!\u00168ji\")q+\u0005a\u00011\"9\u0011qK\tA\u0002\u0005e\u0013a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007m\tY&C\u0002\u0002^Q\u0011Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR1\u0011QJA2\u0003KBQa\u0016\nA\u0002aCa!a\u001a\u0013\u0001\u0004)\u0017AB8gMN,G\u000f")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final boolean isOffsetForLeaderEpochSupported;

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, true);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.replicaMgr.futureLogExists(tp);
        return bl;
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, int fetchBackOffMs) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, leader, failedPartitions, new ReplicaAlterLogDirsTierStateMachine(), fetchBackOffMs, false, brokerTopicStats);
        this.isOffsetForLeaderEpochSupported = true;
    }
}

