/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.coordinator.group.Record;

class Result<T> {
    private final List<Record> records;
    private final T response;

    public Result(List<Record> records, T response) {
        this.records = Objects.requireNonNull(records);
        this.response = Objects.requireNonNull(response);
    }

    public List<Record> records() {
        return this.records;
    }

    public T response() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (!this.records.equals(result.records)) {
            return false;
        }
        return this.response.equals(result.response);
    }

    public int hashCode() {
        int result = this.records.hashCode();
        result = 31 * result + this.response.hashCode();
        return result;
    }

    public String toString() {
        return "Result(records=" + this.records + ", response=" + this.response + ")";
    }
}

