/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import scala.Array$;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d4QAD\b\u0001\u001fUA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tC\u0001\u0011\t\u0011)A\u0005E!AQ\u0005\u0001B\u0001B\u0003%a\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"\u0002\u001f\u0001\t\u0003i\u0004B\u0002#\u0001A\u0003%a\u0004\u0003\u0004F\u0001\u0001\u0006IA\u0012\u0005\u0007\u0013\u0002\u0001\u000b\u0015\u0002\u0010\t\u0013)\u0003\u0001\u0019!A!B\u0013q\u0004BB(\u0001A\u0013%\u0001\u000bC\u0003U\u0001\u0011\u0005Q\u000bC\u0003_\u0001\u0011\u0005qLA\u0006US6LgnZ,iK\u0016d'B\u0001\t\u0012\u0003\u0015!\u0018.\\3s\u0015\t\u00112#A\u0003vi&d7OC\u0001\u0015\u0003\u0015Y\u0017MZ6b'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\u0007i&\u001c7.T:\u0004\u0001A\u0011qcH\u0005\u0003Aa\u0011A\u0001T8oO\u0006Iq\u000f[3fYNK'0\u001a\t\u0003/\rJ!\u0001\n\r\u0003\u0007%sG/A\u0004ti\u0006\u0014H/T:\u0002\u0017Q\f7o[\"pk:$XM\u001d\t\u0003QEj\u0011!\u000b\u0006\u0003U-\na!\u0019;p[&\u001c'B\u0001\u0017.\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003]=\nA!\u001e;jY*\t\u0001'\u0001\u0003kCZ\f\u0017B\u0001\u001a*\u00055\tEo\\7jG&sG/Z4fe\u0006)\u0011/^3vKB\u0019QG\u000e\u001d\u000e\u0003-J!aN\u0016\u0003\u0015\u0011+G.Y=Rk\u0016,X\r\u0005\u0002:u5\tq\"\u0003\u0002<\u001f\tiA+[7feR\u000b7o\u001b'jgR\fa\u0001P5oSRtDC\u0002 @\u0001\u0006\u00135\t\u0005\u0002:\u0001!)AD\u0002a\u0001=!)\u0011E\u0002a\u0001E!)QE\u0002a\u0001=!)aE\u0002a\u0001O!)1G\u0002a\u0001i\u0005A\u0011N\u001c;feZ\fG.A\u0004ck\u000e\\W\r^:\u0011\u0007]9\u0005(\u0003\u0002I1\t)\u0011I\u001d:bs\u0006Y1-\u001e:sK:$H+[7f\u00035yg/\u001a:gY><x\u000b[3fY\"\u0012!\u0002\u0014\t\u0003/5K!A\u0014\r\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001#\u00193e\u001fZ,'O\u001a7po^CW-\u001a7\u0015\u0003E\u0003\"a\u0006*\n\u0005MC\"\u0001B+oSR\f1!\u00193e)\t1\u0016\f\u0005\u0002\u0018/&\u0011\u0001\f\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015QF\u00021\u0001\\\u00039!\u0018.\\3s)\u0006\u001c8.\u00128uef\u0004\"!\u000f/\n\u0005u{!A\u0004+j[\u0016\u0014H+Y:l\u000b:$(/_\u0001\rC\u00124\u0018M\\2f\u00072|7m\u001b\u000b\u0003#\u0002DQ!Y\u0007A\u0002y\ta\u0001^5nK6\u001b\bF\u0001\u0001d!\t!W-D\u0001\u0012\u0013\t1\u0017CA\u0007o_:$\bN]3bIN\fg-\u001a")
public class TimingWheel {
    private final long tickMs;
    private final int wheelSize;
    private final AtomicInteger taskCounter;
    private final DelayQueue<TimerTaskList> queue;
    private final long interval;
    private final TimerTaskList[] buckets;
    private long currentTime;
    private volatile TimingWheel overflowWheel;

    private synchronized void addOverflowWheel() {
        if (this.overflowWheel == null) {
            this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.taskCounter, this.queue);
        }
    }

    public boolean add(TimerTaskEntry timerTaskEntry) {
        long expiration = timerTaskEntry.expirationMs();
        if (timerTaskEntry.cancelled()) {
            return false;
        }
        if (expiration < this.currentTime + this.tickMs) {
            return false;
        }
        if (expiration < this.currentTime + this.interval) {
            long virtualId = expiration / this.tickMs;
            TimerTaskList bucket = this.buckets[(int)(virtualId % (long)this.wheelSize)];
            bucket.add(timerTaskEntry);
            if (bucket.setExpiration(virtualId * this.tickMs)) {
                this.queue.offer(bucket);
            }
            return true;
        }
        if (this.overflowWheel == null) {
            this.addOverflowWheel();
        }
        return this.overflowWheel.add(timerTaskEntry);
    }

    public void advanceClock(long timeMs) {
        if (timeMs >= this.currentTime + this.tickMs) {
            this.currentTime = timeMs - timeMs % this.tickMs;
            if (this.overflowWheel != null) {
                this.overflowWheel.advanceClock(this.currentTime);
                return;
            }
        }
    }

    public static final /* synthetic */ TimerTaskList $anonfun$buckets$1(TimingWheel $this, int x$1) {
        return new TimerTaskList($this.taskCounter);
    }

    public TimingWheel(long tickMs, int wheelSize, long startMs, AtomicInteger taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.taskCounter = taskCounter;
        this.queue = queue;
        this.interval = tickMs * (long)wheelSize;
        this.buckets = (TimerTaskList[])Array$.MODULE$.tabulate(wheelSize, (Function1 & java.io.Serializable & Serializable)x$1 -> TimingWheel.$anonfun$buckets$1(this, BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(TimerTaskList.class));
        this.currentTime = startMs - startMs % tickMs;
    }
}

